/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.utils;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Patterns;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.exception.GroupOperationException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.exception.system.SystemException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;

public class Utils {
    private static final String USERNAME_PATTERN_REX = "[a-zA-Z0-9-_\\.]{3,64}$";
    private static final String PASSWORD_PATTERN_REX = "^[\\u0020-\\u007E]{4,50}$";
    private static final String KEY_PATTERN_REX = "^[a-zA-Z0-9._-]{1,64}$";
    private static final String COUNTRY_PATTERN_REX = "^[A-Z]{2}$";
    private static final String BUCKET_NAME_PATTERN_REX = "^[a-zA-Z0-9-_]{2,64}$";
    private static final String QUALIFIED_BUCKET_NAME_PATTERN_REX = "^(CRYPTO:)?([a-zA-Z0-9-_]{2,64})$";
    private static final String FILE_BUCKET_NAME_PATTERN_REX = "^[a-zA-Z0-9-_]{2,64}$";
    private static final String PHONE_PATTERN_REX = "[\\+]?[0-9.-]+";
    private static final String GLOBAL_PHONE_PATTERN_REX = "^[\\+][0-9.-]+";
    private static final String LOCAL_PHONE_PATTERN_REX = "^[0-9]*$";
    private static final String PUT_DISTANCE_INTO_PATTERN = "^[a-zA-Z_][a-zA-Z0-9_]*$";
    private static final String VENDOR_THING_ID_PATTERN_REX = "[a-zA-Z0-9-_\\.]{1,200}";
    private static final String THING_PASSWORD_PATTERN_REX = "^\\p{Print}{1,200}$";
    private static final String THING_GENERIC_FIELD_PATTERN_REX = "[a-zA-Z0-9-_\\. ]{0,100}";
    private static final String KEY_PATTERN_GROUP_ID_REX = "^[a-z0-9._-]{1,30}$";
    private static final Pattern OBJECT_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_\\.]{2,100}$");
    private static final int MIN_DISPLAY_NAME_LENGTH = 1;
    private static final int MAX_DISPLAY_NAME_LENGTH = 50;
    private static final String PREFIX_THING_ID = "th.";
    public static final int SEED = 23;
    private static final int PRIME_NUMBER = 37;

    public static boolean isValidObjectID(@NonNull String objectID) {
        return OBJECT_ID_PATTERN.matcher(objectID).matches();
    }

    public static boolean isThingID(@Nullable String id) {
        if (Utils.isEmpty(id)) {
            return false;
        }
        return id.startsWith(PREFIX_THING_ID);
    }

    public static boolean validateBucketName(@NonNull String name) {
        return Pattern.matches("^[a-zA-Z0-9-_]{2,64}$", name);
    }

    public static boolean validateQualifiedBucketName(@NonNull String name) {
        return Pattern.matches(QUALIFIED_BUCKET_NAME_PATTERN_REX, name);
    }

    public static boolean validateCalculatedDistance(@NonNull String name) {
        return Pattern.matches(PUT_DISTANCE_INTO_PATTERN, name);
    }

    public static boolean validateFileBucketName(@NonNull String name) {
        return Pattern.matches("^[a-zA-Z0-9-_]{2,64}$", name) && !name.matches(".*\\.\\./.*") && !name.matches(".*\\./.*");
    }

    public static boolean validateEmail(@NonNull String email) {
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public static boolean validateLocalPhoneNumber(@NonNull String number) {
        return Pattern.matches(LOCAL_PHONE_PATTERN_REX, number);
    }

    public static boolean validatePhoneNumber(@Nullable String number) {
        if (TextUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        return Pattern.matches(PHONE_PATTERN_REX, number);
    }

    public static boolean validateGlobalPhone(@Nullable String number) {
        if (TextUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        return Pattern.matches(GLOBAL_PHONE_PATTERN_REX, number);
    }

    public static boolean validateUsername(@NonNull String username) {
        return Pattern.matches(USERNAME_PATTERN_REX, username);
    }

    public static boolean validateKey(@NonNull String key) {
        return Pattern.matches(KEY_PATTERN_REX, key);
    }

    public static boolean validatePassword(@NonNull String pw) {
        return Pattern.matches(PASSWORD_PATTERN_REX, pw);
    }

    public static boolean validateDisplayname(@Nullable String displayname) {
        if (TextUtils.isEmpty((CharSequence)displayname)) {
            return false;
        }
        int length = displayname.length();
        return length >= 1 && length <= 50;
    }

    public static boolean validateCountry(@NonNull String country) {
        return Pattern.matches(COUNTRY_PATTERN_REX, country);
    }

    public static boolean validateGroupID(@NonNull String groupID) {
        return Pattern.matches(KEY_PATTERN_GROUP_ID_REX, groupID);
    }

    public static boolean validateThingPassword(@NonNull String pw) {
        return Pattern.matches(THING_PASSWORD_PATTERN_REX, pw);
    }

    public static boolean validateVendorThingID(@NonNull String id) {
        return Pattern.matches(VENDOR_THING_ID_PATTERN_REX, id);
    }

    public static boolean validateThingGenericField(@NonNull String field) {
        return Pattern.matches(THING_GENERIC_FIELD_PATTERN_REX, field);
    }

    public static void checkInitialize(boolean checkLogin) {
        if (Kii.getAppId() == null) {
            throw new IllegalStateException("KiiClient is not initialized!");
        }
        if (checkLogin && KiiUser.getCurrentUser() == null) {
            throw new IllegalStateException("No login user, please login first!");
        }
    }

    public static boolean isEmpty(@Nullable Object s) {
        if (s == null) {
            return true;
        }
        if (s instanceof String && ((String)s).trim().length() == 0) {
            return true;
        }
        if (s instanceof Map) {
            return ((Map)s).isEmpty();
        }
        if (s instanceof List) {
            return ((List)s).isEmpty();
        }
        return false;
    }

    @NonNull
    public static String path(Object ... segments) {
        String path = "";
        boolean first = true;
        for (Object segment : segments) {
            if (segment instanceof Object[]) {
                segment = Utils.path((Object[])segment);
            }
            if (Utils.isEmpty(segment)) continue;
            if (first) {
                path = segment.toString();
                first = false;
                continue;
            }
            if (!path.endsWith("/") && !segment.toString().startsWith("/")) {
                path = path + "/";
            }
            path = path + segment.toString();
        }
        return path;
    }

    @Nullable
    public static String capitalize(@Nullable String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isAlphaString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Utils.isAlpha(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isNumericString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Utils.isNumeric(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(char c) {
        return Utils.isAlpha(c) || Utils.isNumeric(c);
    }

    public static boolean isAlphaNumericString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Utils.isAlphaNumeric(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void throwException(@NonNull GroupOperationException e) throws BadRequestException, IOException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        Throwable exp = e.getCause();
        if (exp instanceof BadRequestException) {
            throw (BadRequestException)exp;
        }
        if (exp instanceof ConflictException) {
            throw (ConflictException)exp;
        }
        if (exp instanceof ForbiddenException) {
            throw (ForbiddenException)exp;
        }
        if (exp instanceof NotFoundException) {
            throw (NotFoundException)exp;
        }
        if (exp instanceof UnauthorizedException) {
            throw (UnauthorizedException)exp;
        }
        if (exp instanceof UndefinedException) {
            throw (UndefinedException)exp;
        }
        if (exp instanceof IOException) {
            throw (IOException)exp;
        }
        throw new SystemException(SystemException.Reason.__UNKNOWN__.toString(), e, SystemException.Reason.__UNKNOWN__);
    }

    public static int hash(int aInt) {
        return 851 + aInt;
    }

    public static int hash(@NonNull String value) {
        return Utils.hash(value.hashCode());
    }

    @NonNull
    public static Uri getUFEUri(@NonNull Uri cloudUri) {
        String ufeUri = cloudUri.toString().replace("kiicloud://", Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "/"));
        return Uri.parse((String)ufeUri);
    }

    @NonNull
    public static FileHolder createHolderByUri(@NonNull Uri holderUri) {
        List segments = holderUri.getPathSegments();
        String authority = holderUri.getAuthority();
        return KiiObject.createByUri(holderUri);
    }

    @NonNull
    public static String getCurrentUserId() {
        Uri uri = KiiUser.getCurrentUser().toUri();
        return uri.getLastPathSegment();
    }

    @Nullable
    public static String getHeaderValueByName(@NonNull Header[] headers, @NonNull String name) {
        for (Header h : headers) {
            if (!name.equalsIgnoreCase(h.getName())) continue;
            return h.getValue();
        }
        return null;
    }

    public static int lengthInBytes(@NonNull String str) {
        return str.getBytes().length;
    }

    public static final long safeAdd(long left, long right) throws ArithmeticException {
        if (right > 0L ? left > Long.MAX_VALUE - right : left < Long.MIN_VALUE - right) {
            throw new ArithmeticException("Addition of " + left + " and " + right + " result in long overflow");
        }
        return left + right;
    }

    public static final long safeMultiply(long left, long right) throws ArithmeticException {
        if (right > 0L ? left > Long.MAX_VALUE / right || left < Long.MIN_VALUE / right : (right < -1L ? left > Long.MIN_VALUE / right || left < Long.MAX_VALUE / right : right == -1L && left == Long.MIN_VALUE)) {
            throw new ArithmeticException("Multiplication of " + left + " and " + right + " result in long overflow");
        }
        return left * right;
    }

    public static boolean isUpperCase(String s) {
        if (!Character.isUpperCase(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isLowerCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(String s) {
        return s.toUpperCase().equals(s);
    }

    public static boolean isAllLowerCase(String s) {
        return s.toLowerCase().equals(s);
    }
}

