/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.utils.BitmapManager;
import com.kii.cloud.storage.utils.FileUtils;
import com.kii.cloud.storage.utils.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageUtils {
    private static final String TAG = "ThumbnailUtils";
    private static final int MAX_NUM_PIXELS_THUMBNAIL = 196608;
    private static final int MAX_NUM_PIXELS_MICRO_THUMBNAIL = 65536;
    private static final int UNCONSTRAINED = -1;
    private static final int OPTIONS_NONE = 0;
    private static final int OPTIONS_SCALE_UP = 1;
    public static final int OPTIONS_RECYCLE_INPUT = 2;
    public static final int TARGET_SIZE_MINI_THUMBNAIL = 320;
    public static final int TARGET_SIZE_MICRO_THUMBNAIL = 150;
    public static final int TARGET_SIZE_UPLOAD_PICTURE = 1920;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Bitmap createImageThumbnail2(@NonNull Context context, @NonNull String filePath, int kind) {
        FileDescriptor fd;
        BitmapFactory.Options options;
        ParcelFileDescriptor pfd;
        Bitmap bitmap;
        int maxPixels;
        int targetSize;
        block12: {
            block11: {
                boolean wantMini = kind == 1;
                targetSize = wantMini ? 320 : 150;
                maxPixels = wantMini ? 196608 : 65536;
                bitmap = null;
                File file = new File(filePath);
                if (!file.exists()) {
                    return null;
                }
                pfd = null;
                if (pfd == null) {
                    pfd = ImageUtils.makeInputStream(Uri.fromFile((File)file), context.getContentResolver());
                }
                if (pfd != null) break block11;
                Bitmap bitmap2 = null;
                ImageUtils.closeSilently(pfd);
                return bitmap2;
            }
            options = new BitmapFactory.Options();
            fd = pfd.getFileDescriptor();
            options.inJustDecodeBounds = true;
            BitmapManager.instance().decodeFileDescriptor(fd, options);
            if (!options.mCancel && options.outWidth != -1 && options.outHeight != -1) break block12;
            Bitmap bitmap3 = null;
            ImageUtils.closeSilently(pfd);
            return bitmap3;
        }
        try {
            options.inSampleSize = ImageUtils.computeSampleSize(options, targetSize, maxPixels);
            options.inJustDecodeBounds = false;
            options.inDither = false;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            bitmap = BitmapManager.instance().decodeFileDescriptor(fd, options);
            int or = ImageUtils.getOrientation(filePath);
            bitmap = ImageUtils.rotateBitmap(bitmap, or);
        }
        catch (OutOfMemoryError ex) {
            Bitmap bitmap4;
            try {
                Log.e(TAG, "Got oom exception ", ex);
                bitmap4 = null;
            }
            catch (Throwable throwable) {
                ImageUtils.closeSilently(pfd);
                throw throwable;
            }
            ImageUtils.closeSilently(pfd);
            return bitmap4;
        }
        ImageUtils.closeSilently(pfd);
        if (bitmap != null) {
            Log.d("TEST", "bitmap Height:" + bitmap.getHeight());
        }
        if (kind == 3 && bitmap != null) {
            bitmap = ImageUtils.extractThumbnail(bitmap, 150, 150, 2);
        }
        if (bitmap != null) {
            Log.d("TEST", "bitmap Height:" + bitmap.getHeight());
        }
        return bitmap;
    }

    private static int getOrientation(String filename) {
        int or = 0;
        try {
            ExifInterface ei = new ExifInterface(filename);
            or = ei.getAttributeInt("Orientation", 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return or;
    }

    private static Bitmap rotateBitmap(Bitmap bitmap, int or) {
        int degree = ImageUtils.getRotateFroOption(or);
        if (degree != 0) {
            Matrix mtx = new Matrix();
            mtx.postRotate((float)degree);
            int w = bitmap.getWidth();
            int h = bitmap.getHeight();
            Bitmap rotatedBMP = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)false);
            bitmap.recycle();
            bitmap = rotatedBMP;
        }
        return bitmap;
    }

    private static int getRotateFroOption(int option) {
        int rotate = 0;
        switch (option) {
            case 1: {
                rotate = 0;
                break;
            }
            case 6: {
                rotate = 90;
                break;
            }
            case 3: {
                rotate = 180;
                break;
            }
            case 8: {
                rotate = 270;
            }
        }
        return rotate;
    }

    @Nullable
    public static Bitmap extractThumbnail(@Nullable Bitmap source, int width, int height) {
        return ImageUtils.extractThumbnail(source, width, height, 0);
    }

    @Nullable
    public static Bitmap extractThumbnail(@Nullable Bitmap source, int width, int height, int options) {
        if (source == null) {
            return null;
        }
        float scale = source.getWidth() < source.getHeight() ? (float)width / (float)source.getWidth() : (float)height / (float)source.getHeight();
        Matrix matrix = new Matrix();
        matrix.setScale(scale, scale);
        Bitmap thumbnail = ImageUtils.transform(matrix, source, width, height, 1 | options);
        return thumbnail;
    }

    private static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = ImageUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    private static void closeSilently(ParcelFileDescriptor c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ParcelFileDescriptor makeInputStream(Uri uri, ContentResolver cr) {
        try {
            return cr.openFileDescriptor(uri, "r");
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static Bitmap transform(Matrix scaler, Bitmap source, int targetWidth, int targetHeight, int options) {
        int dy1;
        int dx1;
        Bitmap b2;
        float scale;
        float viewAspect;
        float bitmapHeightF;
        boolean scaleUp = (options & 1) != 0;
        boolean recycle = (options & 2) != 0;
        int deltaX = source.getWidth() - targetWidth;
        int deltaY = source.getHeight() - targetHeight;
        if (!(scaleUp || deltaX >= 0 && deltaY >= 0)) {
            Bitmap b22 = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b22);
            int deltaXHalf = Math.max(0, deltaX / 2);
            int deltaYHalf = Math.max(0, deltaY / 2);
            Rect src = new Rect(deltaXHalf, deltaYHalf, deltaXHalf + Math.min(targetWidth, source.getWidth()), deltaYHalf + Math.min(targetHeight, source.getHeight()));
            int dstX = (targetWidth - src.width()) / 2;
            int dstY = (targetHeight - src.height()) / 2;
            Rect dst = new Rect(dstX, dstY, targetWidth - dstX, targetHeight - dstY);
            c.drawBitmap(source, src, dst, null);
            if (recycle) {
                source.recycle();
            }
            return b22;
        }
        float bitmapWidthF = source.getWidth();
        float bitmapAspect = bitmapWidthF / (bitmapHeightF = (float)source.getHeight());
        if (bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight)) {
            scale = (float)targetHeight / bitmapHeightF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        } else {
            scale = (float)targetWidth / bitmapWidthF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        }
        Bitmap b1 = scaler != null ? Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)scaler, (boolean)true) : source;
        if (recycle && b1 != source) {
            source.recycle();
        }
        if ((b2 = Bitmap.createBitmap((Bitmap)b1, (int)((dx1 = Math.max(0, b1.getWidth() - targetWidth)) / 2), (int)((dy1 = Math.max(0, b1.getHeight() - targetHeight)) / 2), (int)targetWidth, (int)targetHeight)) != b1 && (recycle || b1 != source)) {
            b1.recycle();
        }
        return b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String generateThumbnail(@NonNull Context context, @NonNull String pathImage, @NonNull String destPath, @NonNull String mimeType) {
        try {
            File dest = new File(destPath);
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                Log.e(TAG, "Create folder failed:" + dest.getAbsolutePath());
                return null;
            }
            Bitmap b = null;
            if (mimeType.startsWith("image")) {
                b = ImageUtils.createImageThumbnail2(context, pathImage, 1);
            } else if (mimeType.startsWith("video") && Build.VERSION.SDK_INT > 7) {
                b = ThumbnailUtils.createVideoThumbnail((String)pathImage, (int)3);
            }
            if (b == null) return null;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(dest);
                b.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fos);
                String string = dest.getAbsolutePath();
                return string;
            }
            catch (IOException iOException) {
                return null;
            }
            finally {
                if (fos != null) {
                    FileUtils.closeSilently(fos);
                }
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "generateThumbnailForImage Exception:" + ex.getMessage());
            return null;
        }
    }
}

