/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.utils.BitmapManager;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageThumbnailUtil {
    public static final int TARGET_SIZE_MINI_THUMBNAIL = 320;
    private static final int MAX_NUM_PIXELS_THUMBNAIL = 102400;
    private static final int UNCONSTRAINED = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] createImageThumbnail(@NonNull String filePath) throws IOException {
        FileDescriptor fd;
        BitmapFactory.Options options;
        ByteArrayOutputStream os;
        FileInputStream fis;
        Bitmap bitmap;
        block4: {
            byte[] byArray;
            bitmap = null;
            File file = new File(filePath);
            if (!file.exists()) {
                return null;
            }
            fis = null;
            os = null;
            try {
                fis = new FileInputStream(file);
                options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                fd = fis.getFD();
                BitmapManager.instance().decodeFileDescriptor(fd, options);
                if (!options.mCancel && options.outWidth != -1 && options.outHeight != -1) break block4;
                byArray = null;
            }
            catch (Throwable throwable) {
                ImageThumbnailUtil.closeSilently(fis);
                ImageThumbnailUtil.closeSilently(os);
                throw throwable;
            }
            ImageThumbnailUtil.closeSilently(fis);
            ImageThumbnailUtil.closeSilently(os);
            return byArray;
        }
        options.inSampleSize = ImageThumbnailUtil.computeSampleSize(options, 320, 102400);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        bitmap = BitmapManager.instance().decodeFileDescriptor(fd, options);
        int or = ImageThumbnailUtil.getOrientation(filePath);
        bitmap = ImageThumbnailUtil.rotateBitmap(bitmap, or);
        os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)os);
        byte[] byArray = os.toByteArray();
        ImageThumbnailUtil.closeSilently(fis);
        ImageThumbnailUtil.closeSilently(os);
        return byArray;
    }

    private static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = ImageThumbnailUtil.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    private static int getOrientation(String filename) {
        int or = 0;
        try {
            ExifInterface ei = new ExifInterface(filename);
            or = ei.getAttributeInt("Orientation", 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return or;
    }

    private static Bitmap rotateBitmap(Bitmap bitmap, int or) {
        int degree = ImageThumbnailUtil.getRotateFroOption(or);
        if (degree != 0) {
            Matrix mtx = new Matrix();
            mtx.postRotate((float)degree);
            int w = bitmap.getWidth();
            int h = bitmap.getHeight();
            Bitmap rotatedBMP = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)false);
            bitmap.recycle();
            bitmap = rotatedBMP;
        }
        return bitmap;
    }

    private static int getRotateFroOption(int option) {
        int rotate = 0;
        switch (option) {
            case 1: {
                rotate = 0;
                break;
            }
            case 6: {
                rotate = 90;
                break;
            }
            case 3: {
                rotate = 180;
                break;
            }
            case 8: {
                rotate = 270;
            }
        }
        return rotate;
    }

    private static void closeSilently(Closeable fd) {
        if (fd != null) {
            try {
                fd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

