/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.utils.Log;
import java.io.FileDescriptor;
import java.util.WeakHashMap;

public class BitmapManager {
    private static final String TAG = "BitmapManager";
    private final WeakHashMap<Thread, ThreadStatus> mThreadStatus = new WeakHashMap();
    private static BitmapManager sManager = null;

    private BitmapManager() {
    }

    private synchronized ThreadStatus getOrCreateThreadStatus(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        if (status == null) {
            status = new ThreadStatus();
            this.mThreadStatus.put(t, status);
        }
        return status;
    }

    private synchronized void setDecodingOptions(Thread t, BitmapFactory.Options options) {
        this.getOrCreateThreadStatus((Thread)t).mOptions = options;
    }

    synchronized void removeDecodingOptions(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        status.mOptions = null;
    }

    public synchronized boolean canThreadDecoding(@NonNull Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        if (status == null) {
            return true;
        }
        boolean result = status.mState != State.CANCEL;
        return result;
    }

    public synchronized void allowThreadDecoding(@NonNull Thread t) {
        this.getOrCreateThreadStatus((Thread)t).mState = State.ALLOW;
    }

    @NonNull
    public static synchronized BitmapManager instance() {
        if (sManager == null) {
            sManager = new BitmapManager();
        }
        return sManager;
    }

    @Nullable
    public Bitmap decodeFileDescriptor(@NonNull FileDescriptor fd, @NonNull BitmapFactory.Options options) {
        if (options.mCancel) {
            return null;
        }
        Thread thread = Thread.currentThread();
        if (!this.canThreadDecoding(thread)) {
            Log.d(TAG, "Thread " + thread + " is not allowed to decode.");
            return null;
        }
        this.setDecodingOptions(thread, options);
        Bitmap b = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        this.removeDecodingOptions(thread);
        return b;
    }

    private static class ThreadStatus {
        public State mState = State.ALLOW;
        public BitmapFactory.Options mOptions;

        private ThreadStatus() {
        }

        public String toString() {
            String s = this.mState == State.CANCEL ? "Cancel" : (this.mState == State.ALLOW ? "Allow" : "?");
            s = "thread state = " + s + ", options = " + this.mOptions;
            return s;
        }
    }

    private static enum State {
        CANCEL,
        ALLOW;

    }
}

