/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.social.twitter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;

public class KiiTwitterLoginActivity
extends Activity {
    private static final String CALLBACK_SCHEME = "kiicloud";
    private static final String CALLBACK_AUTHORITY = "twittercallback";
    static final String CALLBACK = "kiicloud://twittercallback";
    static final String EXTRA_TOKEN = "token";
    private static final String AUTHORIZE_URL = "https://api.twitter.com/oauth/authorize";
    private static final String PARAM_KEY_OAUTH_VERIFIER = "oauth_verifier";
    static final String EXTRA_OAUTH_VERIFIER = "verifier";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent it = this.getIntent();
        if (it == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        String requestToken = it.getStringExtra(EXTRA_TOKEN);
        WebView webView = new WebView((Context)this);
        webView.setWebViewClient((WebViewClient)new KiiTwitterWebViewClient());
        webView.getSettings().setSavePassword(false);
        webView.getSettings().setSaveFormData(false);
        this.setContentView((View)webView);
        webView.loadUrl("https://api.twitter.com/oauth/authorize?oauth_token=" + requestToken);
    }

    class KiiTwitterWebViewClient
    extends WebViewClient {
        KiiTwitterWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            Uri uri = Uri.parse((String)url);
            if (!KiiTwitterLoginActivity.CALLBACK_SCHEME.equals(uri.getScheme())) {
                return;
            }
            if (!KiiTwitterLoginActivity.CALLBACK_AUTHORITY.equals(uri.getAuthority())) {
                return;
            }
            String verifier = uri.getQueryParameter(KiiTwitterLoginActivity.PARAM_KEY_OAUTH_VERIFIER);
            if (verifier == null) {
                KiiTwitterLoginActivity.this.setResult(0);
                KiiTwitterLoginActivity.this.finish();
                return;
            }
            Intent data = new Intent();
            data.putExtra(KiiTwitterLoginActivity.EXTRA_OAUTH_VERIFIER, verifier);
            KiiTwitterLoginActivity.this.setResult(-1, data);
            KiiTwitterLoginActivity.this.finish();
        }
    }
}

