/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.social.twitter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage._KiiUserInternalBridge;
import com.kii.cloud.storage.callback.KiiSocialCallBack;
import com.kii.cloud.storage.exception.social.InvalidActivityException;
import com.kii.cloud.storage.exception.social.OAuthException;
import com.kii.cloud.storage.exception.social.SocialException;
import com.kii.cloud.storage.exception.social.UserCancelException;
import com.kii.cloud.storage.social.KiiBaseSocialConnect;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.social.connector.KiiSocialNetworkConnector;
import com.kii.cloud.storage.social.twitter.KiiTwitterLoginActivity;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.scribe.kii.builder.ServiceBuilder;
import org.scribe.kii.builder.api.TwitterApi;
import org.scribe.kii.model.Token;
import org.scribe.kii.model.Verifier;
import org.scribe.kii.oauth.OAuthService;

public class KiiTwitterConnect
extends KiiBaseSocialConnect
implements KiiSocialConnect {
    private static final String REQUEST_UFE_TOKEN = "accessToken";
    private static final String REQUEST_UFE_TOKEN_SECRET = "accessTokenSecret";
    private static final String TWITTER_ACCESS_TOKEN_KEY = "oauth_token";
    private static final String TWITTER_ACCESS_TOKEN_SECRET_KEY = "oauth_token_secret";
    public static final int REQUEST_CODE = 32666;
    private OAuthService mOauthService;
    private KiiBaseSocialConnect.Type mRequestType;
    private KiiSocialCallBack mCallback = null;
    private Token mRequestToken = null;
    private String mConsumerKey = null;
    private String mConsumerSecret = null;
    @Deprecated
    private Class<?> loginActivity = KiiTwitterLoginActivity.class;

    private KiiTwitterConnect() {
    }

    static KiiTwitterConnect newInstance() {
        return new KiiTwitterConnect();
    }

    static KiiTwitterConnect newInstance(Bundle b) {
        return new KiiTwitterConnect(b);
    }

    @Override
    public void initialize(@NonNull String consumerKey, @NonNull String consumerSecret, @Nullable Bundle options) {
        if (TextUtils.isEmpty((CharSequence)consumerKey)) {
            throw new IllegalArgumentException("SocialNetwork consumerkey is null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)consumerSecret)) {
            throw new IllegalArgumentException("SocialNetwork consumerSecret is null or empty");
        }
        this.mConsumerKey = consumerKey;
        this.mConsumerSecret = consumerSecret;
        this.mOauthService = new ServiceBuilder().provider(TwitterApi.class).apiKey(consumerKey).apiSecret(consumerSecret).callback("kiicloud://twittercallback").build();
    }

    @Override
    public void logIn(@NonNull Activity activity, @Nullable Bundle options, @NonNull KiiSocialCallBack callback) {
        if (activity == null) {
            throw new IllegalArgumentException("SocialNetworkConnection called with null activity.");
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("KiiSocialConnect not initialized.");
        }
        if (this.containsAccessToken(options).booleanValue()) {
            JSONObject object = new JSONObject();
            try {
                object.put(REQUEST_UFE_TOKEN, (Object)options.getString(TWITTER_ACCESS_TOKEN_KEY));
                object.put(REQUEST_UFE_TOKEN_SECRET, (Object)options.getString(TWITTER_ACCESS_TOKEN_SECRET_KEY));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.login(object, callback);
            return;
        }
        GetRequestTokenTask task = new GetRequestTokenTask(activity, KiiBaseSocialConnect.Type.LOGIN, callback);
        task.execute(new Void[0]);
    }

    @Override
    public boolean isLinked() {
        if (KiiUser.isLoggedIn()) {
            return KiiUser.getCurrentUser().isLinkedWithSocialProvider(KiiSocialNetworkConnector.Provider.TWITTER);
        }
        return false;
    }

    @Override
    public void link(@NonNull Activity activity, @Nullable Bundle options, @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        if (activity == null) {
            throw new IllegalArgumentException("SocialNetworkConnection called with null activity.");
        }
        if (activity.isFinishing()) {
            callback.onLinkCompleted(this.getNetwork(), KiiUser.getCurrentUser(), new InvalidActivityException("Passed activity has finished", null));
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("KiiSocialConnect not initialized.");
        }
        if (this.containsAccessToken(options).booleanValue()) {
            JSONObject object = new JSONObject();
            try {
                object.put(REQUEST_UFE_TOKEN, (Object)options.getString(TWITTER_ACCESS_TOKEN_KEY));
                object.put(REQUEST_UFE_TOKEN_SECRET, (Object)options.getString(TWITTER_ACCESS_TOKEN_SECRET_KEY));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.link(object, callback);
            return;
        }
        if (!this.isLoggedIn()) {
            GetRequestTokenTask task = new GetRequestTokenTask(activity, KiiBaseSocialConnect.Type.LINK, callback);
            task.execute(new Void[0]);
        } else {
            JSONObject requestJson = new JSONObject();
            try {
                Bundle tokenBundle = _KiiUserInternalBridge.getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.TWITTER);
                requestJson.put(REQUEST_UFE_TOKEN, (Object)tokenBundle.getString(TWITTER_ACCESS_TOKEN_KEY));
                requestJson.put(REQUEST_UFE_TOKEN_SECRET, (Object)tokenBundle.getString(TWITTER_ACCESS_TOKEN_SECRET_KEY));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.link(requestJson, callback);
        }
    }

    @Override
    public void unlink(@NonNull Activity activity, @Nullable Bundle options, @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        if (activity == null) {
            throw new IllegalArgumentException("SocialNetworkConnection called with null activity.");
        }
        if (activity.isFinishing()) {
            callback.onUnLinkCompleted(this.getNetwork(), null, new InvalidActivityException("Passed activity has finished.", null));
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("KiiSocialConnect not initialized.");
        }
        this.unlink(activity, callback);
    }

    @Override
    public void respondAuthOnActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != 32666) {
            return;
        }
        if (resultCode != -1) {
            this.callCompleteCallbackOnFailure(this.mCallback, new UserCancelException("User cancels the authentication", null), this.mRequestType);
            return;
        }
        if (data == null) {
            this.callCompleteCallbackOnFailure(this.mCallback, new IllegalArgumentException("data is null"), this.mRequestType);
            return;
        }
        String verifier = data.getStringExtra("verifier");
        if (verifier == null) {
            this.callCompleteCallbackOnFailure(this.mCallback, new IllegalArgumentException("verifier is null"), this.mRequestType);
            return;
        }
        GetAccessTokenTask task = new GetAccessTokenTask(new Verifier(verifier));
        task.execute(new Void[0]);
    }

    @Override
    @Nullable
    public String getAccessToken() {
        Bundle tokenBundle = _KiiUserInternalBridge.getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.TWITTER);
        if (tokenBundle == null) {
            return null;
        }
        return tokenBundle.getString(TWITTER_ACCESS_TOKEN_KEY);
    }

    @Override
    public long getAccessExpires() {
        return 0L;
    }

    @Override
    protected String getSocialNetworkName() {
        return "twitter";
    }

    @Override
    protected String getLoginContentType() {
        return "application/vnd.kii.AuthTokenTwitterRequest+json";
    }

    @Override
    protected String getLinkContentType() {
        return "application/vnd.kii.LinkTwitterRequest+json";
    }

    @Override
    protected KiiSocialConnect.SocialNetwork getNetwork() {
        return KiiSocialConnect.SocialNetwork.TWITTER;
    }

    @Override
    protected void onLoginCompleted(JSONObject requestJson, Bundle tokenBundle) {
        try {
            String token = requestJson.getString(REQUEST_UFE_TOKEN);
            String secret = requestJson.getString(REQUEST_UFE_TOKEN_SECRET);
            if (token != null && secret != null) {
                tokenBundle.putString(TWITTER_ACCESS_TOKEN_KEY, token);
                tokenBundle.putString(TWITTER_ACCESS_TOKEN_SECRET_KEY, secret);
                _KiiUserInternalBridge.updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.TWITTER, tokenBundle);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    protected void onLinkCompleted(JSONObject requestJson) {
        try {
            String token = requestJson.getString(REQUEST_UFE_TOKEN);
            String secret = requestJson.getString(REQUEST_UFE_TOKEN_SECRET);
            if (token != null && secret != null) {
                Bundle tokenBundle = new Bundle();
                tokenBundle.putString(TWITTER_ACCESS_TOKEN_KEY, token);
                tokenBundle.putString(TWITTER_ACCESS_TOKEN_SECRET_KEY, secret);
                _KiiUserInternalBridge.updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.TWITTER, tokenBundle);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    protected void onPreUnlink(Activity activity) throws IOException, SocialException {
    }

    private boolean isInitialized() {
        return this.mOauthService != null;
    }

    private boolean isLoggedIn() {
        return this.getAccessToken() != null;
    }

    @Override
    @Nullable
    public Bundle getAccessTokenBundle() {
        return _KiiUserInternalBridge.getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.TWITTER);
    }

    private Boolean containsAccessToken(Bundle options) {
        if (options == null) {
            return false;
        }
        if (!options.containsKey(TWITTER_ACCESS_TOKEN_KEY) && !options.containsKey(TWITTER_ACCESS_TOKEN_SECRET_KEY)) {
            return false;
        }
        String accessToken = options.getString(TWITTER_ACCESS_TOKEN_KEY);
        String accessTokenSecret = options.getString(TWITTER_ACCESS_TOKEN_SECRET_KEY);
        if (TextUtils.isEmpty((CharSequence)accessToken) || TextUtils.isEmpty((CharSequence)accessTokenSecret)) {
            throw new IllegalArgumentException("Twitter access token and access token secret should not be null or empty");
        }
        return true;
    }

    @Override
    protected final void onUnlinkCompleted() {
        _KiiUserInternalBridge.clearSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.TWITTER);
    }

    Bundle getParcelableBundle() {
        Bundle b = new Bundle();
        b.putString("consumerKey", this.mConsumerKey);
        b.putString("consumerSecret", this.mConsumerSecret);
        return b;
    }

    void setParcelableBundle(Bundle b) {
        String consumerKey = b.getString("consumerKey");
        String consumerSecret = b.getString("consumerSecret");
        if (consumerKey == null || consumerSecret == null) {
            return;
        }
        this.mConsumerKey = consumerKey;
        this.mConsumerSecret = consumerSecret;
    }

    private KiiTwitterConnect(Bundle b) {
        String consumerKey = b.getString("consumerKey");
        String consumerSecret = b.getString("consumerSecret");
        if (consumerKey == null || consumerSecret == null) {
            return;
        }
        this.mConsumerKey = consumerKey;
        this.mConsumerSecret = consumerSecret;
        this.mOauthService = new ServiceBuilder().provider(TwitterApi.class).apiKey(consumerKey).apiSecret(consumerSecret).callback("kiicloud://twittercallback").build();
    }

    private class GetAccessTokenTask
    extends AsyncTask<Void, Void, Token> {
        private Verifier mVerifier;
        private Exception ex = null;

        private GetAccessTokenTask(Verifier verifier) {
            this.mVerifier = verifier;
        }

        protected Token doInBackground(Void ... params) {
            try {
                return KiiTwitterConnect.this.mOauthService.getAccessToken(KiiTwitterConnect.this.mRequestToken, this.mVerifier);
            }
            catch (Exception e) {
                this.ex = e;
                return null;
            }
        }

        protected void onPostExecute(Token result) {
            super.onPostExecute((Object)result);
            if (result == null) {
                KiiTwitterConnect.this.callCompleteCallbackOnFailure(KiiTwitterConnect.this.mCallback, new OAuthException("failed to get access token", this.ex), KiiTwitterConnect.this.mRequestType);
                return;
            }
            JSONObject object = new JSONObject();
            try {
                object.put(KiiTwitterConnect.REQUEST_UFE_TOKEN, (Object)result.getToken());
                object.put(KiiTwitterConnect.REQUEST_UFE_TOKEN_SECRET, (Object)result.getSecret());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (KiiTwitterConnect.this.mRequestType == KiiBaseSocialConnect.Type.LOGIN) {
                KiiTwitterConnect.this.login(object, KiiTwitterConnect.this.mCallback);
            } else {
                KiiTwitterConnect.this.link(object, KiiTwitterConnect.this.mCallback);
            }
        }
    }

    private class GetRequestTokenTask
    extends AsyncTask<Void, Void, Token> {
        private Activity mActivity;
        private Exception ex = null;

        private GetRequestTokenTask(Activity activity, KiiBaseSocialConnect.Type type, KiiSocialCallBack callback) {
            this.mActivity = activity;
            KiiTwitterConnect.this.mRequestType = type;
            KiiTwitterConnect.this.mCallback = callback;
        }

        protected Token doInBackground(Void ... params) {
            try {
                return KiiTwitterConnect.this.mOauthService.getRequestToken();
            }
            catch (Exception e) {
                this.ex = e;
                return null;
            }
        }

        protected void onPostExecute(Token result) {
            super.onPostExecute((Object)result);
            if (result == null) {
                KiiTwitterConnect.this.callCompleteCallbackOnFailure(KiiTwitterConnect.this.mCallback, new OAuthException("failed to get request token", this.ex), KiiTwitterConnect.this.mRequestType);
                return;
            }
            KiiTwitterConnect.this.mRequestToken = result;
            Intent it = new Intent((Context)this.mActivity, KiiTwitterConnect.this.loginActivity);
            it.putExtra("token", result.getToken());
            this.mActivity.startActivityForResult(it, 32666);
        }
    }
}

