/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.social.qq;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage._KiiUserInternalBridge;
import com.kii.cloud.storage.callback.KiiSocialCallBack;
import com.kii.cloud.storage.exception.social.SocialException;
import com.kii.cloud.storage.social.KiiBaseSocialConnect;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.social.connector.KiiSocialNetworkConnector;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiQQConnect
extends KiiBaseSocialConnect
implements KiiSocialConnect {
    private static final String REQUEST_UFE_TOKEN = "accessToken";
    private static final String REQUEST_UFE_OPENID = "openID";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String OPENID = "openID";
    private String mConsumerKey = null;

    private KiiQQConnect() {
    }

    static KiiQQConnect newInstance() {
        return new KiiQQConnect();
    }

    @Override
    public void initialize(@Nullable String consumerKey, @Nullable String consumerSecret, @Nullable Bundle options) {
    }

    @Override
    public void logIn(@Nullable Activity activity, @NonNull Bundle options, @NonNull KiiSocialCallBack callback) {
        KiiQQConnect.validateOptions(options);
        JSONObject object = new JSONObject();
        try {
            object.put(REQUEST_UFE_TOKEN, (Object)options.getString(ACCESS_TOKEN));
            object.put("openID", (Object)options.getString("openID"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.login(object, callback);
    }

    @Override
    public boolean isLinked() {
        if (KiiUser.isLoggedIn()) {
            return KiiUser.getCurrentUser().isLinkedWithSocialProvider(KiiSocialNetworkConnector.Provider.QQ);
        }
        return false;
    }

    @Override
    public void link(@Nullable Activity activity, @NonNull Bundle options, @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        KiiQQConnect.validateOptions(options);
        JSONObject object = new JSONObject();
        try {
            object.put(REQUEST_UFE_TOKEN, (Object)options.getString(ACCESS_TOKEN));
            object.put("openID", (Object)options.getString("openID"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.link(object, callback);
    }

    @Override
    public void unlink(@Nullable Activity activity, @Nullable Bundle options, @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        this.unlink(activity, callback);
    }

    @Override
    public void respondAuthOnActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    }

    @Override
    @Nullable
    public String getAccessToken() {
        Bundle tokenBundle = this.getAccessTokenBundle();
        if (tokenBundle == null) {
            return null;
        }
        return tokenBundle.getString(ACCESS_TOKEN);
    }

    @Override
    public long getAccessExpires() {
        return 0L;
    }

    @Override
    @Nullable
    public Bundle getAccessTokenBundle() {
        return _KiiUserInternalBridge.getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.QQ);
    }

    @Override
    protected String getSocialNetworkName() {
        return "qq";
    }

    @Override
    protected String getLoginContentType() {
        return "application/vnd.kii.AuthTokenQQRequest+json";
    }

    @Override
    protected String getLinkContentType() {
        return "application/vnd.kii.LinkQQRequest+json";
    }

    @Override
    protected KiiSocialConnect.SocialNetwork getNetwork() {
        return KiiSocialConnect.SocialNetwork.QQ;
    }

    @Override
    protected void onLoginCompleted(JSONObject requestJson, Bundle tokenBundle) {
        try {
            String qqAccesstoken = requestJson.getString(REQUEST_UFE_TOKEN);
            String openID = requestJson.getString("openID");
            tokenBundle.putString(ACCESS_TOKEN, qqAccesstoken);
            tokenBundle.putString("openID", openID);
            _KiiUserInternalBridge.updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.QQ, tokenBundle);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    protected void onLinkCompleted(JSONObject requestJson) {
        try {
            String qqAccesstoken = requestJson.getString(REQUEST_UFE_TOKEN);
            String openID = requestJson.getString("openID");
            if (qqAccesstoken != null && openID != null) {
                Bundle tokenBundle = new Bundle();
                tokenBundle.putString(ACCESS_TOKEN, qqAccesstoken);
                tokenBundle.putString("openID", openID);
                _KiiUserInternalBridge.updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.QQ, tokenBundle);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    protected void onPreUnlink(Activity activity) throws IOException, SocialException {
    }

    @Override
    protected void onUnlinkCompleted() {
        _KiiUserInternalBridge.clearSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.QQ);
    }

    private static void validateOptions(Bundle options) {
        if (options == null) {
            throw new IllegalArgumentException("Opitons is null or empty");
        }
        if (!options.containsKey(ACCESS_TOKEN) && !options.containsKey("openID")) {
            throw new IllegalArgumentException("Options should contain QQ access token and openID");
        }
        String accessToken = options.getString(ACCESS_TOKEN);
        String openID = options.getString("openID");
        if (TextUtils.isEmpty((CharSequence)accessToken) || TextUtils.isEmpty((CharSequence)openID)) {
            throw new IllegalArgumentException("QQ access token and openID should not be null or empty");
        }
    }
}

