/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.resumabletransfer.AlreadyStartedException;
import com.kii.cloud.storage.resumabletransfer.StateStoreAccessException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UPNoEntry;
import com.kii.cloud.storage.resumabletransfer.impl.UPOnGoing;
import com.kii.cloud.storage.resumabletransfer.impl.UPState;
import com.kii.cloud.storage.resumabletransfer.impl.UploadFuture;
import com.kii.cloud.storage.resumabletransfer.impl.UploadFutureExecutor;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogic;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class UPSuspended
implements UPState {
    @Override
    public void transfer(final @NonNull KiiUploaderImpl uploader) throws SuspendedException, TerminatedException, AlreadyStartedException {
        uploader.setState(new UPOnGoing());
        UploadFutureExecutor ufm = uploader.getUploadFutureExecutor();
        final UploaderLogic cl = uploader.getLogic();
        UploadFuture newFuture = new UploadFuture(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean resumable = cl.resumable(uploader, UPSuspended.this);
                if (!resumable) {
                    uploader.setState(new UPNoEntry());
                    throw new TerminatedException("File body has been changed.");
                }
                cl.chunkUpload(uploader, UPSuspended.this);
                cl.commitUpload(uploader, UPSuspended.this);
                return null;
            }
        });
        try {
            ufm.executeFuture(newFuture);
            newFuture.get();
            uploader.setState(new UPNoEntry());
        }
        catch (InterruptedException e) {
            throw new SuspendedException("Transfer has suspended.", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TerminatedException) {
                throw (TerminatedException)cause;
            }
            if (cause instanceof SuspendedException) {
                throw (SuspendedException)cause;
            }
            throw new RuntimeException("Unexpected error", cause);
        }
        catch (CancellationException e) {
            cl.setCancelled();
            if (uploader.cancelledByTermination()) {
                try {
                    uploader.getTransferStore().remove(uploader);
                    uploader.setState(new UPNoEntry());
                    throw new TerminatedException("transfer has terminated");
                }
                catch (StoreException e1) {
                    uploader.setState(new UPSuspended());
                    throw new SuspendedException("transfer is suspended");
                }
            }
            uploader.setState(new UPSuspended());
            throw new SuspendedException("transfer is suspended");
        }
        finally {
            uploader.cancelDone();
        }
    }

    @Override
    public void suspend(@NonNull KiiUploaderImpl uploader) {
        uploader.cancelDone();
    }

    @Override
    public void terminate(@NonNull KiiUploaderImpl uploader) throws StateStoreAccessException {
        try {
            uploader.getTransferStore().remove(uploader);
            uploader.setState(new UPNoEntry());
        }
        catch (StoreException e) {
            throw new StateStoreAccessException("Failed to delete entry in database");
        }
        finally {
            uploader.cancelDone();
        }
    }

    @Override
    public void abortGettingUploadId(@Nullable KiiUploaderImpl uploader, @Nullable Throwable cause) throws TerminatedException {
        throw new IllegalStateException("Unexpected state.");
    }

    @Override
    public void abortChunkUploading(@NonNull KiiUploaderImpl uploader, @NonNull Throwable cause) throws SuspendedException, TerminatedException {
        if (uploader.getLogic().isRecoverble(cause)) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
        try {
            uploader.getTransferStore().remove(uploader);
            uploader.setState(new UPNoEntry());
            throw new TerminatedException(cause);
        }
        catch (StoreException ioe) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
    }

    @Override
    public void abortCommit(@NonNull KiiUploaderImpl uploader, @NonNull Throwable cause) throws TerminatedException, SuspendedException {
        if (uploader.getLogic().isRecoverble(cause)) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
        try {
            uploader.getTransferStore().remove(uploader);
            uploader.setState(new UPNoEntry());
            throw new TerminatedException(cause);
        }
        catch (StoreException ioe) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
    }

    @Override
    public void abortResumableCheck(@NonNull KiiUploaderImpl uploader, @NonNull Throwable cause) throws TerminatedException, SuspendedException {
        if (uploader.getLogic().isRecoverble(cause)) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
        try {
            uploader.getTransferStore().remove(uploader);
            uploader.setState(new UPNoEntry());
            throw new TerminatedException(cause);
        }
        catch (StoreException ioe) {
            uploader.setState(new UPSuspended());
            throw new SuspendedException(cause);
        }
    }
}

