/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.resumabletransfer.AlreadyStartedException;
import com.kii.cloud.storage.resumabletransfer.NoEntryException;
import com.kii.cloud.storage.resumabletransfer.StateStoreAccessException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UPNoEntry;
import com.kii.cloud.storage.resumabletransfer.impl.UPState;
import com.kii.cloud.storage.resumabletransfer.impl.UPSuspended;
import com.kii.cloud.storage.resumabletransfer.impl.UploadFutureExecutor;

public class UPOnGoing
implements UPState {
    @Override
    public void transfer(@Nullable KiiUploaderImpl uploader) throws AlreadyStartedException {
        throw new AlreadyStartedException("Transfer has already started.");
    }

    @Override
    public void suspend(@NonNull KiiUploaderImpl uploader) throws NoEntryException {
        UploadFutureExecutor ufm = uploader.getUploadFutureExecutor();
        try {
            ufm.cancelFuture();
            uploader.setState(new UPSuspended());
        }
        catch (UploadFutureExecutor.AlreadyDoneException e) {
            uploader.cancelDone();
            throw new NoEntryException("Already done");
        }
    }

    @Override
    public void terminate(@NonNull KiiUploaderImpl uploader) throws NoEntryException, StateStoreAccessException {
        UploadFutureExecutor ufm = uploader.getUploadFutureExecutor();
        try {
            ufm.cancelFuture();
            uploader.getTransferStore().remove(uploader);
            uploader.setState(new UPNoEntry());
        }
        catch (StoreException e) {
            uploader.setState(new UPSuspended());
            throw new StateStoreAccessException("Failed to change status on database");
        }
        catch (UploadFutureExecutor.AlreadyDoneException e) {
            uploader.cancelDone();
            throw new NoEntryException("Already done");
        }
    }

    @Override
    public void abortGettingUploadId(@Nullable KiiUploaderImpl uploader, @Nullable Throwable cause) throws TerminatedException {
        throw new IllegalStateException("Unexpected state.");
    }

    @Override
    public void abortChunkUploading(@Nullable KiiUploaderImpl uploader, @Nullable Throwable cause) throws SuspendedException {
        throw new IllegalStateException("Unexpected state.");
    }

    @Override
    public void abortCommit(@Nullable KiiUploaderImpl uploader, @Nullable Throwable cause) throws TerminatedException, SuspendedException {
        throw new IllegalStateException("Unexpected state.");
    }

    @Override
    public void abortResumableCheck(@Nullable KiiUploaderImpl uploader, @Nullable Throwable cause) throws TerminatedException, SuspendedException {
        throw new IllegalStateException("Unexpected state.");
    }
}

