/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.Context;
import android.media.ExifInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage._KiiInstanceManager;
import com.kii.cloud.storage.engine._HttpClientFactory;
import com.kii.cloud.storage.engine._HttpClientFactoryOptions;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.RedirectionException;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.photocolle.KiiCloudPhotoColle;
import com.kii.cloud.storage.photocolle.PhotoColleSocialConnect;
import com.kii.cloud.storage.photocolle._KiiCloudPhotoColleInternalBridge;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.FileModifiedException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.PhotoColleFileHolder;
import com.kii.cloud.storage.resumabletransfer.impl.PhotoColleMIMEUtil;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UPState;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogic;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.MimeUtil;
import com.kii.cloud.storage.utils.Utils;
import com.kii.sdk.photocolle.AuthenticateCallback;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.Authority;
import com.kii.sdk.photocolle.FileType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

class PhotoColleUploaderLogic
implements UploaderLogic {
    private static final String TAG = "PhotoColleUploaderLogic";
    private static final _HttpClientFactory CLIENT_FACTORY = new _HttpClientFactory();
    private boolean cancelled = false;

    PhotoColleUploaderLogic() {
    }

    @Override
    public void setCancelled() {
        this.cancelled = true;
    }

    @Override
    public void startUpload(@NonNull KiiUploaderImpl uploader, @NonNull UPState state) throws TerminatedException {
        if (this.cancelled) {
            return;
        }
        try {
            HttpPost request = this.createStartUploadRequest(uploader);
            _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(false);
            HttpResponse response = CLIENT_FACTORY.createClient(options).execute((HttpUriRequest)request);
            uploader.setUploadId(this.getUploadID(response));
            if (this.cancelled) {
                return;
            }
            uploader.getTransferStore().save(uploader);
        }
        catch (StoreException e) {
            state.abortGettingUploadId(uploader, e);
        }
        catch (AppException e) {
            state.abortGettingUploadId(uploader, e);
        }
        catch (IOException e) {
            state.abortGettingUploadId(uploader, e);
        }
    }

    @Override
    public void chunkUpload(@NonNull KiiUploaderImpl uploader, @NonNull UPState state) throws SuspendedException, TerminatedException {
        while (!uploader.hasAllChunkSent()) {
            if (this.cancelled) {
                return;
            }
            try {
                if (uploader.hasFileChangeFromInitiation()) {
                    throw new FileModifiedException("File body has been changed.");
                }
                long completedInBytes = this.upload(uploader);
                if (this.cancelled) {
                    return;
                }
                uploader.setCompletedInBytes(completedInBytes);
                uploader.getTransferStore().save(uploader);
                uploader.executeProgressCallbackOnMainThread();
            }
            catch (AppException e) {
                state.abortChunkUploading(uploader, e);
            }
            catch (IOException e) {
                state.abortChunkUploading(uploader, e);
            }
            catch (StoreException e) {
                state.abortChunkUploading(uploader, e);
            }
            catch (FileModifiedException e) {
                state.abortChunkUploading(uploader, e);
            }
        }
    }

    @Override
    public boolean resumable(@Nullable KiiUploaderImpl uploader, @Nullable UPState state) throws TerminatedException, SuspendedException {
        return true;
    }

    @Override
    public void commitUpload(@NonNull KiiUploaderImpl uploader, @NonNull UPState state) throws SuspendedException, TerminatedException {
        if (this.cancelled) {
            return;
        }
        try {
            _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(false);
            HttpPost request = this.createCommitRequest(uploader.getUploadId(), PhotoColleUploaderLogic.generateAccessToken(uploader.getContext()));
            HttpResponse response = CLIENT_FACTORY.createClient(options).execute((HttpUriRequest)request);
            PhotoColleFileHolder fileHolder = (PhotoColleFileHolder)uploader.getFileHolderInternal();
            fileHolder.dataId = this.getDataId(response);
            uploader.getTransferStore().remove(uploader);
        }
        catch (AppException e) {
            state.abortCommit(uploader, e);
        }
        catch (IOException e) {
            state.abortCommit(uploader, e);
        }
        catch (StoreException e) {
            state.abortCommit(uploader, e);
        }
    }

    @Override
    public boolean isRecoverble(@Nullable Throwable cause) {
        if (cause instanceof IOException) {
            return true;
        }
        if (cause instanceof UndefinedException) {
            int status = ((UndefinedException)cause).getStatus();
            return status != 416 && status != 406;
        }
        return false;
    }

    private HttpPost createStartUploadRequest(KiiUploaderImpl uploader) throws IOException {
        Utils.checkInitialize(false);
        HttpPost request = new HttpPost(PhotoColleUploaderLogic.getStartUploadURI());
        request.setHeader("Authorization", PhotoColleUploaderLogic.generateAccessToken(uploader.getContext()));
        request.setHeader("x-kii-appid", Kii.getAppId());
        request.setHeader("x-kii-appkey", Kii.getAppKey());
        request.setHeader("x-kii-client-hash", uploader.getHashGenerator().getHash(uploader.getSourceFile()));
        String innerEntity = this.createMetaInfo(uploader.getSourceFile()).toString();
        Log.v(TAG, "request body: " + innerEntity);
        StringEntity entity = new StringEntity(innerEntity, "UTF8");
        entity.setContentType("application/vnd.com.kii.sync.Generic2+json");
        request.setEntity((HttpEntity)entity);
        return request;
    }

    /*
     * Exception decompiling
     */
    private String getUploadID(HttpResponse response) throws AppException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JSONObject createMetaInfo(File sourceFile) throws IOException {
        JSONObject retval = new JSONObject();
        try {
            retval.put("CreationTime", (Object)Long.toString(sourceFile.lastModified()));
            retval.put("UpdateTime", (Object)Long.toString(sourceFile.lastModified()));
            String mimeType = PhotoColleMIMEUtil.getMIMETypeByExtension(MimeUtil.getSuffixOfFile(sourceFile.getName()));
            FileType type = PhotoColleUploaderLogic.getType(mimeType);
            retval.put("MimeType", (Object)mimeType);
            retval.put("Type", (Object)type.getLabel());
            retval.put("Title", (Object)sourceFile.getName());
            retval.put("UniqueKey", (Object)PhotoColleUploaderLogic.getUniqueKey(sourceFile, type));
            retval.put("VirtualRoot", (Object)"docomo");
            retval.put("Size", (Object)Long.toString(sourceFile.length()));
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
        return retval;
    }

    private static FileType getType(String mimeType) {
        FileType retval = null;
        if ("image/jpeg".equals(mimeType) || "image/pjpeg".equals(mimeType)) {
            retval = FileType.IMAGE;
        } else if ("video/3gpp".equals(mimeType) || "video/avi".equals(mimeType) || "video/quicktime".equals(mimeType) || "video/mp4".equals(mimeType) || "video/vnd.mts".equals(mimeType) || "video/mpeg".equals(mimeType)) {
            retval = FileType.VIDEO;
        } else {
            throw new RuntimeException("Unsupported MIME type: " + mimeType);
        }
        return retval;
    }

    private static String getUniqueKey(File file, FileType type) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(file.getName());
        builder.append('_');
        switch (type) {
            case IMAGE: {
                ExifInterface exif = new ExifInterface(file.getPath());
                String dateTime = exif.getAttribute("DateTime");
                if (dateTime != null) {
                    dateTime = dateTime.replaceAll("[: ]", "");
                    builder.append(dateTime);
                    builder.append("000");
                    break;
                }
                builder.append("00000000000000000");
                break;
            }
            case VIDEO: {
                builder.append("00000000000000000");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported FileType error.");
            }
        }
        builder.append('_');
        builder.append(file.length());
        return builder.toString();
    }

    private static URI getStartUploadURI() {
        return PhotoColleUploaderLogic.getBaseURI();
    }

    private static URI getBaseURI() {
        try {
            return new URL(_KiiCloudPhotoColleInternalBridge.getBaseUrl() + "/app/dcm_slb/api/0.8/Generic2/uploads").toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("URL is abnormal", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("URL is abnormal", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long upload(KiiUploaderImpl uploader) throws AppException, IOException {
        long completedInBytes = uploader.getCompletedInBytes();
        long totalInBytes = uploader.getTotalInBytes();
        File file = uploader.getSourceFile();
        if (!file.exists()) {
            throw new FileNotFoundException("source file does not exist");
        }
        String mimeType = PhotoColleMIMEUtil.getMIMETypeByExtension(MimeUtil.getSuffixOfFile(file.getName()));
        int chunkSize = uploader.getChunkSize();
        String tempFilename = "temp" + System.currentTimeMillis();
        File tmpFile = PhotoColleUploaderLogic.generateTemporaryChunkFileInPrivateArea(uploader.getContext(), file, tempFilename, completedInBytes, chunkSize);
        try {
            int readTotal = (int)tmpFile.length();
            if (readTotal <= 0) {
                throw new IOException("Can not read content.");
            }
            _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(true);
            HttpPut request = this.createUploadRequest(uploader.getUploadId(), mimeType, PhotoColleUploaderLogic.getContentRange(completedInBytes, totalInBytes, readTotal), uploader.getHashGenerator().getHash(uploader.getSourceFile()), tmpFile, PhotoColleUploaderLogic.generateAccessToken(uploader.getContext()));
            HttpResponse response = CLIENT_FACTORY.createClient(options).execute((HttpUriRequest)request);
            this.checkUploadResponse(response);
            long l = completedInBytes += (long)readTotal;
            return l;
        }
        finally {
            uploader.getContext().deleteFile(tempFilename);
        }
    }

    private HttpPut createUploadRequest(String uploadId, String mimeType, String range, String hash, File file, String accessToken) {
        Utils.checkInitialize(false);
        HttpPut request = new HttpPut(PhotoColleUploaderLogic.getUploadURI(uploadId));
        request.setHeader("Authorization", accessToken);
        request.setHeader("x-kii-appid", Kii.getAppId());
        request.setHeader("x-kii-appkey", Kii.getAppKey());
        request.setHeader("Content-Type", mimeType);
        request.setHeader("content-range", range);
        request.setHeader("if-match", hash);
        FileEntity entity = new FileEntity(file, mimeType);
        entity.setContentType(mimeType);
        request.setEntity((HttpEntity)entity);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkUploadResponse(HttpResponse response) throws AppException, IOException {
        if (response == null) {
            throw new IOException("failed to get response.");
        }
        HttpEntity entity = null;
        try {
            entity = response.getEntity();
            StatusLine statusLine = response.getStatusLine();
            String body = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            int status = statusLine.getStatusCode();
            if (300 <= status && status < 400) {
                throw new RedirectionException("Redirected by network.");
            }
            switch (statusLine.getStatusCode()) {
                case 204: {
                    return;
                }
                case 400: {
                    if ("Cant get valid address from access token.".equals(body)) {
                        throw new UnauthorizedException("Unauthorized access", null, body);
                    }
                    BadRequestException.Reason reason = BadRequestException.Reason.INVALID_INPUT_DATA;
                    throw new BadRequestException(reason.toString(), null, reason, body);
                }
                case 404: {
                    NotFoundException.Reason reason = NotFoundException.Reason.OBJECT_NOT_FOUND;
                    throw new NotFoundException(reason.toString(), null, reason, body);
                }
                case 409: {
                    ConflictException.Reason reason = ConflictException.Reason.OBJECT_ALREADY_EXISTS;
                    throw new ConflictException(reason.toString(), null, reason, body);
                }
                default: {
                    throw new UndefinedException(status, body);
                }
            }
        }
        finally {
            if (entity != null) {
                entity.consumeContent();
            }
        }
    }

    private static URI getUploadURI(String uploadId) {
        try {
            return new URI(PhotoColleUploaderLogic.getBaseURI().toString() + "/" + uploadId + "/data");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("fail to get upload uri", e);
        }
    }

    private HttpPost createCommitRequest(String uploadId, String accessToken) {
        Utils.checkInitialize(false);
        HttpPost request = new HttpPost(PhotoColleUploaderLogic.getCommitURI(uploadId));
        request.setHeader("Authorization", accessToken);
        request.setHeader("x-kii-appid", Kii.getAppId());
        request.setHeader("x-kii-appkey", Kii.getAppKey());
        return request;
    }

    /*
     * Exception decompiling
     */
    private String getDataId(HttpResponse response) throws AppException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File generateTemporaryChunkFileInPrivateArea(Context context, File sourceFile, String filename, long completedInBytes, int chunkSize) throws IOException {
        BufferedInputStream bif = null;
        FilterOutputStream bos = null;
        try {
            int readlen;
            FileOutputStream fos = context.openFileOutput(filename, 0);
            bos = new BufferedOutputStream(fos);
            bif = new BufferedInputStream(new FileInputStream(sourceFile));
            bif.skip(completedInBytes);
            byte[] buffer = new byte[8192];
            int readTotal = 0;
            while (readTotal < chunkSize && (readlen = bif.read(buffer)) >= 0) {
                if ((readTotal += readlen) >= chunkSize) {
                    ((BufferedOutputStream)bos).write(buffer, 0, readlen - (readTotal - chunkSize));
                    readTotal = chunkSize;
                    continue;
                }
                ((BufferedOutputStream)bos).write(buffer, 0, readlen);
            }
            ((BufferedOutputStream)bos).flush();
            File file = new File(context.getFilesDir(), filename);
            return file;
        }
        finally {
            try {
                if (bif != null) {
                    bif.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String getContentRange(long completedInBytes, long totalInBytes, int readInBytes) {
        return "bytes=" + completedInBytes + "-" + (completedInBytes + (long)readInBytes - 1L) + "/" + totalInBytes;
    }

    private static URI getCommitURI(String uploadId) {
        try {
            return new URI(PhotoColleUploaderLogic.getBaseURI().toString() + "/" + uploadId + "/status/committed");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("fail to get commit uri", e);
        }
    }

    private static String generateAccessToken(Context context) {
        PhotoColleSocialConnect connect = _KiiInstanceManager.getInstance().getPhotoColleSocialConnect();
        KiiCloudPhotoColle photoColle = connect.getKiiCloudPhotocolle(context);
        AuthenticationContext authContext = photoColle.getAuthenticationContext();
        if (authContext.getRemainingTime(TimeUnit.SECONDS) < 300L) {
            final CountDownLatch latch = new CountDownLatch(1);
            Authority.refreshToken((AuthenticationContext)authContext, (AuthenticateCallback)new AuthenticateCallback(){

                public void onAuthenticated(AuthenticationContext refreshedContext, Exception exception) {
                    latch.countDown();
                }
            });
            try {
                latch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "Bearer " + authContext.getAccessToken();
    }
}

