/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteFullException;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferStatus;
import com.kii.cloud.storage.resumabletransfer.KiiUploader;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderFactory;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.PhotoColleFileHolder;
import com.kii.cloud.storage.resumabletransfer.impl.PhotoColleRTransferInfoStoreDB;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferUploadInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderInfoImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PhotoColleRTransferInfoStore
implements RTransferUploadInfoStore {
    private static PhotoColleRTransferInfoStore INSTANCE = new PhotoColleRTransferInfoStore();
    private PhotoColleRTransferInfoStoreDB db;

    @NonNull
    public static PhotoColleRTransferInfoStore getInstance() {
        return INSTANCE;
    }

    private synchronized void init(Context ctx) {
        if (this.db == null) {
            this.db = PhotoColleRTransferInfoStoreDB.getInstance();
            this.db.init(ctx);
        }
    }

    @Override
    public void save(@NonNull KiiUploaderImpl uploader) throws StoreException {
        try {
            this.init(uploader.getContext());
            if (this.isStored(uploader)) {
                this.update(uploader);
            } else {
                this.insert(uploader);
            }
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
    }

    private void insert(KiiUploaderImpl uploader) throws StoreException {
        ContentValues cv = new ContentValues();
        Uri holderUri = uploader.getHolderUri();
        cv.put("holder_uri", holderUri.toString());
        cv.put("completed_size", Long.valueOf(uploader.getCompletedInBytes()));
        cv.put("file_modified_time", Long.valueOf(uploader.getSourceFile().lastModified()));
        cv.put("source_file_path", uploader.getSourceFile().getAbsolutePath());
        cv.put("total_size", Long.valueOf(uploader.getSourceFile().length()));
        cv.put("upload_id", uploader.getUploadId());
        cv.put("initiator_uri", uploader.getInitiatorUri().toString());
        long ret = this.db.insert(cv);
        if (ret == -1L) {
            throw new StoreException("insert returns -1");
        }
    }

    private void update(KiiUploaderImpl uploader) throws StoreException {
        ContentValues cv = new ContentValues();
        Uri uri = uploader.getHolderUri();
        String path = uploader.getSourceFile().getAbsolutePath();
        cv.put("completed_size", Long.valueOf(uploader.getCompletedInBytes()));
        int num = this.db.update(cv, "holder_uri=? AND source_file_path=?", new String[]{uri.toString(), path});
        if (num < 1) {
            throw new StoreException("update returns less than 1");
        }
    }

    @Override
    public void remove(@NonNull KiiUploaderImpl uploader) throws StoreException {
        this.init(uploader.getContext());
        try {
            this.db.delete("holder_uri=? AND source_file_path=?", new String[]{uploader.getHolderUri().toString(), uploader.getSourceFile().getAbsolutePath()});
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
    }

    @Override
    public boolean isStored(@NonNull KiiUploaderImpl uploader) throws StoreException {
        this.init(uploader.getContext());
        Cursor cursor = null;
        Uri holderUri = uploader.getHolderUri();
        if (holderUri == null) {
            return false;
        }
        try {
            cursor = this.db.query("holder_uri=? AND source_file_path=?", new String[]{holderUri.toString(), uploader.getSourceFile().getAbsolutePath()});
            boolean bl = cursor.moveToNext();
            return bl;
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public UploaderInfoImpl findByUploader(@NonNull KiiUploaderImpl uploader) throws StoreException {
        this.init(uploader.getContext());
        Cursor cursor = null;
        Uri holderUri = uploader.getHolderUri();
        if (holderUri == null) {
            return new UploaderInfoImpl(KiiRTransferStatus.NOENTRY, 0L, uploader.getTotalInBytes(), uploader.getSourceFile().lastModified(), uploader.getSourceFile().getAbsolutePath(), null);
        }
        try {
            cursor = this.db.query("holder_uri=? AND source_file_path=? AND initiator_uri=?", new String[]{holderUri.toString(), uploader.getSourceFile().getAbsolutePath(), uploader.getInitiatorUri().toString()});
            if (cursor.moveToNext()) {
                KiiRTransferStatus status = uploader.doingTransfer() ? KiiRTransferStatus.ONGOING : KiiRTransferStatus.SUSPENDED;
                UploaderInfoImpl uploaderInfoImpl = new UploaderInfoImpl(status, PhotoColleRTransferInfoStore.getLong(cursor, "completed_size"), PhotoColleRTransferInfoStore.getLong(cursor, "total_size"), PhotoColleRTransferInfoStore.getLong(cursor, "file_modified_time"), PhotoColleRTransferInfoStore.getString(cursor, "source_file_path"), PhotoColleRTransferInfoStore.getString(cursor, "upload_id"));
                return uploaderInfoImpl;
            }
            UploaderInfoImpl uploaderInfoImpl = new UploaderInfoImpl(KiiRTransferStatus.NOENTRY, 0L, uploader.getTotalInBytes(), uploader.getSourceFile().lastModified(), uploader.getSourceFile().getAbsolutePath(), null);
            return uploaderInfoImpl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @NonNull
    public List<KiiUploader> findUploadEntriesByInitiatorUri(@NonNull Context context, @NonNull Uri initiatorUri) throws StoreException {
        this.init(context);
        try (Cursor cursor = null;){
            cursor = this.db.query("initiator_uri = ?", new String[]{initiatorUri.toString()});
            if (cursor == null) {
                ArrayList<KiiUploader> arrayList = new ArrayList<KiiUploader>();
                return arrayList;
            }
            ArrayList<KiiUploader> retval = new ArrayList<KiiUploader>();
            while (cursor.moveToNext()) {
                KiiUploaderImpl uploader = KiiUploaderFactory.newPhotoColleUploader(context, new PhotoColleFileHolder(Uri.parse((String)PhotoColleRTransferInfoStore.getString(cursor, "holder_uri"))), new File(PhotoColleRTransferInfoStore.getString(cursor, "source_file_path")));
                uploader.setCompletedInBytes(PhotoColleRTransferInfoStore.getLong(cursor, "completed_size"));
                uploader.setUploadId(PhotoColleRTransferInfoStore.getString(cursor, "upload_id"));
                retval.add(uploader);
            }
            ArrayList<KiiUploader> arrayList = retval;
            return arrayList;
        }
    }

    private static long getLong(Cursor cursor, String column) {
        return cursor.getLong(cursor.getColumnIndexOrThrow(column));
    }

    private static String getString(Cursor cursor, String column) {
        return cursor.getString(cursor.getColumnIndexOrThrow(column));
    }
}

