/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.impl.FileHolderInternal;
import java.io.File;
import java.io.IOException;

class PhotoColleFileHolder
implements FileHolderInternal {
    private final Uri holderUri;
    String dataId = null;

    PhotoColleFileHolder(File source) {
        this(PhotoColleFileHolder.generateHolderUri(source));
    }

    PhotoColleFileHolder(Uri holderUri) {
        if (holderUri == null) {
            throw new IllegalArgumentException("holderUri is null.");
        }
        this.holderUri = holderUri;
    }

    @Override
    @NonNull
    public Uri getHolderUri() throws InvalidHolderException {
        return this.holderUri;
    }

    @Override
    public boolean holderExists() throws InvalidHolderException {
        return true;
    }

    @Override
    public void saveHolder() throws AppException, IOException {
    }

    @Override
    @Nullable
    public FileHolder getFileHolder() {
        return null;
    }

    private static Uri generateHolderUri(File sourceFile) {
        assert (sourceFile != null);
        Uri.Builder builder = Uri.fromFile((File)sourceFile).buildUpon();
        builder.appendPath(KiiUser.getCurrentUser().toUri().toString());
        return builder.build();
    }
}

