/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.impl.FileHolderInternal;
import com.kii.cloud.storage.resumabletransfer.impl.HashGenerator;
import com.kii.cloud.storage.resumabletransfer.impl.KiiCloudFileHolder;
import com.kii.cloud.storage.resumabletransfer.impl.KiiCloudRTransferInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.KiiCloudUploaderLogicFactory;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.LWHashGenerator;
import com.kii.cloud.storage.resumabletransfer.impl.PhotoColleFileHolder;
import com.kii.cloud.storage.resumabletransfer.impl.PhotoColleRTransferInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.PhotoColleUploaderLogicFactory;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferUploadInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogic;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogicFactory;
import java.io.File;
import java.util.UUID;
import java.util.WeakHashMap;

public class KiiUploaderFactory {
    static WeakHashMap<String, KiiUploaderImpl> map = new WeakHashMap();

    @NonNull
    public static KiiUploaderImpl newUploader(@NonNull Context context, @Nullable FileHolder fileHolder, @NonNull File sourceFile) {
        KiiCloudFileHolder kiiCloudFileHolder = new KiiCloudFileHolder(fileHolder);
        return KiiUploaderFactory.newUploaderInner(context, kiiCloudFileHolder, sourceFile, new KiiCloudUploaderLogicFactory(), KiiCloudRTransferInfoStore.getInstance(), new LWHashGenerator());
    }

    @NonNull
    public static KiiUploaderImpl newPhotoColleUploader(@NonNull Context context, @NonNull File sourceFile) {
        return KiiUploaderFactory.newUploaderInner(context, new PhotoColleFileHolder(sourceFile), sourceFile, new PhotoColleUploaderLogicFactory(), PhotoColleRTransferInfoStore.getInstance(), new LWHashGenerator());
    }

    @NonNull
    public static KiiUploaderImpl newPhotoColleUploader(@NonNull Context context, @Nullable PhotoColleFileHolder fileHolder, @NonNull File sourceFile) {
        return KiiUploaderFactory.newUploaderInner(context, fileHolder, sourceFile, new PhotoColleUploaderLogicFactory(), PhotoColleRTransferInfoStore.getInstance(), new LWHashGenerator());
    }

    private static synchronized KiiUploaderImpl newUploaderInner(Context context, FileHolderInternal fileHolder, File sourceFile, UploaderLogicFactory<? extends UploaderLogic> logicFactory, RTransferUploadInfoStore transferStore, HashGenerator hashGenerator) {
        String key;
        Uri uri = null;
        try {
            uri = fileHolder.getHolderUri();
        }
        catch (InvalidHolderException invalidHolderException) {
            // empty catch block
        }
        if (uri == null) {
            uri = KiiUploaderFactory.generateDummyUri();
        }
        if (map.containsKey(key = KiiUploaderFactory.getKey(uri, sourceFile.getAbsolutePath()))) {
            return map.get(key);
        }
        KiiUploaderImpl uploader = new KiiUploaderImpl(context, fileHolder, sourceFile, logicFactory, transferStore, hashGenerator);
        uploader.setHolderUri(uri);
        uploader.setKey(key);
        map.put(key, uploader);
        return uploader;
    }

    private static Uri generateDummyUri() {
        return Uri.parse((String)("kiidummy://uploader/" + UUID.randomUUID().toString()));
    }

    private static String getKey(KiiUploaderImpl uploader) {
        Uri uri = uploader.getHolderUri();
        String path = uploader.getSourceFile().getAbsolutePath();
        return KiiUploaderFactory.getKey(uri, path);
    }

    private static String getKey(Uri uri, String path) {
        return uri.toString() + path;
    }

    public static synchronized void onRealUriGenerated(@NonNull KiiUploaderImpl uploader, @NonNull Uri realUri) {
        String key = KiiUploaderFactory.getKey(uploader);
        map.remove(key);
        String newKey = KiiUploaderFactory.getKey(realUri, uploader.getSourceFile().getAbsolutePath());
        uploader.setKey(newKey);
        map.put(newKey, uploader);
    }

    public static void discardMap() {
        map = new WeakHashMap();
    }
}

