/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.KiiBaseBucket;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.resumabletransfer.KiiDownloader;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferManager;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferManagerCallback;
import com.kii.cloud.storage.resumabletransfer.KiiUploader;
import com.kii.cloud.storage.resumabletransfer.StateStoreAccessException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiCloudRTransferInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferCommonLogic;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class KiiRTransferManagerImpl
extends KiiRTransferManager {
    private KiiBaseBucket bucket;
    private Uri bucketUri;
    private Handler mainHandler = new Handler(Looper.getMainLooper());

    public KiiRTransferManagerImpl(@NonNull KiiBaseBucket bucket, @NonNull Uri bucketUri) {
        this.bucket = bucket;
        this.bucketUri = bucketUri;
    }

    @Override
    @NonNull
    public KiiBaseBucket getBucket() {
        return this.bucket;
    }

    @Override
    @NonNull
    public List<KiiUploader> listUploadEntries(@NonNull Context context) throws StateStoreAccessException {
        return this.listUploadEntries(context, KiiUser.getCurrentUser());
    }

    @Override
    @NonNull
    public List<KiiUploader> listUploadEntries(@NonNull Context context, @Nullable KiiUser user) throws StateStoreAccessException {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        Uri initiatorUri = RTransferCommonLogic.initiatorUri(user);
        try {
            List<KiiUploader> list = KiiCloudRTransferInfoStore.getInstance().findUploadEntriesByBucketUriAndInitiatorUri(context, this.bucketUri, initiatorUri);
            return list;
        }
        catch (StoreException e) {
            throw new StateStoreAccessException("Failed to accees storage");
        }
    }

    @Override
    public void listUploadEntries(@NonNull Context context, @NonNull KiiRTransferManagerCallback callback) {
        this.listUploadEntries(context, KiiUser.getCurrentUser(), callback);
    }

    private void postToMainThread(Runnable runnable) {
        this.mainHandler.post(runnable);
    }

    @Override
    public void listUploadEntries(final @NonNull Context context, final @Nullable KiiUser user, final @NonNull KiiRTransferManagerCallback callback) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Can't get the result without callback.");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                final AtomicReference<StateStoreAccessException> ex = new AtomicReference<StateStoreAccessException>();
                final AtomicReference<List<KiiUploader>> listRef = new AtomicReference<List<KiiUploader>>();
                try {
                    List<KiiUploader> list = KiiRTransferManagerImpl.this.listUploadEntries(context, user);
                    listRef.set(list);
                }
                catch (StateStoreAccessException e) {
                    ex.set(e);
                }
                KiiRTransferManagerImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        callback.listUploadEntriesCompleted(KiiRTransferManagerImpl.this, (List<KiiUploader>)((List)listRef.get()), (Exception)ex.get());
                    }
                });
            }
        }).start();
    }

    @Override
    @NonNull
    public List<KiiDownloader> listDownloadEntries(@NonNull Context context) throws StateStoreAccessException {
        return this.listDownloadEntries(context, KiiUser.getCurrentUser());
    }

    @Override
    @NonNull
    public List<KiiDownloader> listDownloadEntries(@NonNull Context context, @Nullable KiiUser user) throws StateStoreAccessException {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        Uri initiatorUri = RTransferCommonLogic.initiatorUri(user);
        try {
            List<KiiDownloader> list = KiiCloudRTransferInfoStore.getInstance().findDownloadEntriesByBucketUriAndInitiatorUri(context, this.bucketUri, initiatorUri);
            return list;
        }
        catch (StoreException e) {
            throw new StateStoreAccessException("Failed to accees storage");
        }
    }

    @Override
    public void listDownloadEntries(@NonNull Context context, @NonNull KiiRTransferManagerCallback callback) {
        this.listDownloadEntries(context, KiiUser.getCurrentUser(), callback);
    }

    @Override
    public void listDownloadEntries(final @NonNull Context context, final @Nullable KiiUser user, final @NonNull KiiRTransferManagerCallback callback) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Can't get the result without callback.");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                final AtomicReference<StateStoreAccessException> ex = new AtomicReference<StateStoreAccessException>();
                final AtomicReference<List<KiiDownloader>> listRef = new AtomicReference<List<KiiDownloader>>();
                try {
                    List<KiiDownloader> list = KiiRTransferManagerImpl.this.listDownloadEntries(context, user);
                    listRef.set(list);
                }
                catch (StateStoreAccessException e) {
                    ex.set(e);
                }
                KiiRTransferManagerImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        callback.listDownloadEntriesCompleted(KiiRTransferManagerImpl.this, (List<KiiDownloader>)((List)listRef.get()), (Exception)ex.get());
                    }
                });
            }
        }).start();
    }
}

