/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.resumabletransfer.AlreadyStartedException;
import com.kii.cloud.storage.resumabletransfer.KiiDownloader;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferCallback;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferInfo;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferProgressCallback;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferStatus;
import com.kii.cloud.storage.resumabletransfer.NoEntryException;
import com.kii.cloud.storage.resumabletransfer.StateStoreAccessException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.DNNoEntry;
import com.kii.cloud.storage.resumabletransfer.impl.DNOnGoing;
import com.kii.cloud.storage.resumabletransfer.impl.DNState;
import com.kii.cloud.storage.resumabletransfer.impl.DNSuspended;
import com.kii.cloud.storage.resumabletransfer.impl.DownloadFutureExecutor;
import com.kii.cloud.storage.resumabletransfer.impl.DownloaderInfoImpl;
import com.kii.cloud.storage.resumabletransfer.impl.DownloaderSemaphore;
import com.kii.cloud.storage.resumabletransfer.impl.FileHolderInternal;
import com.kii.cloud.storage.resumabletransfer.impl.FileModifiedException;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferCommonLogic;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferDownloadInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.utils.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class KiiDownloaderImpl
extends KiiDownloader {
    static final String TAG = "KiiDownloaderImpl";
    static final int DEFAULT_CHUNK_SIZE = 524288;
    private Context context;
    private FileHolderInternal fileHolderInternal;
    private File destFile;
    private int chunkSize;
    private long completedInBytes;
    private long totalInBytes;
    private String eTag;
    private boolean cancelByTermination;
    private Semaphore cancelSemaphore = new Semaphore(1);
    private DNState state;
    private DownloadFutureExecutor dnFutureExecutor = new DownloadFutureExecutor();
    private KiiRTransferProgressCallback prgCallback;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private Uri holderUri;
    private String key;
    private long lastModified;
    private long destFileSize;
    private Uri initiatorUri;
    private RTransferDownloadInfoStore transferStore;

    public KiiDownloaderImpl(@NonNull Context context, @NonNull FileHolderInternal fileHolderInternal, @NonNull File destFile, @Nullable RTransferDownloadInfoStore transferStore) {
        this.context = context.getApplicationContext();
        this.fileHolderInternal = fileHolderInternal;
        this.destFile = destFile;
        this.chunkSize = 524288;
        this.lastModified = destFile.lastModified();
        this.initiatorUri = RTransferCommonLogic.initiatorUri(KiiUser.getCurrentUser());
        this.transferStore = transferStore;
    }

    Uri getInitiatorUri() {
        return this.initiatorUri;
    }

    synchronized void setState(DNState state) {
        if (state instanceof DNNoEntry) {
            this.setCompletedInBytes(0L);
            this.setDestFileSize(this.destFile.length());
            this.setLastModified(this.destFile.lastModified());
            this.setEtag(null);
        }
        this.state = state;
    }

    synchronized DNState getState() {
        return this.state;
    }

    @Override
    @Nullable
    public FileHolder getFileHolder() {
        return this.fileHolderInternal.getFileHolder();
    }

    Context getContext() {
        return this.context;
    }

    @Override
    public void transfer(@Nullable KiiRTransferProgressCallback progress) throws AlreadyStartedException, SuspendedException, TerminatedException, StateStoreAccessException {
        this.doTransfer(progress);
    }

    @Override
    public void transferAsync(final @Nullable KiiRTransferCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiDownloaderImpl.this);
                        }
                    }
                });
                final AtomicReference<Exception> ex = new AtomicReference<Exception>();
                try {
                    KiiDownloaderImpl.this.doTransfer(callback);
                }
                catch (Exception e) {
                    ex.set(e);
                }
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onTransferCompleted(KiiDownloaderImpl.this, (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransfer(KiiRTransferProgressCallback progress) throws AlreadyStartedException, TerminatedException, SuspendedException, StateStoreAccessException {
        Semaphore sem = null;
        try {
            DownloaderInfoImpl info;
            KiiDownloaderImpl kiiDownloaderImpl = this;
            synchronized (kiiDownloaderImpl) {
                sem = DownloaderSemaphore.getSemaphore(this);
                info = this.getTransferStore().findByDownloader(this);
                if (!sem.tryAcquire()) {
                    throw new AlreadyStartedException("Transfer already started from another thread.");
                }
            }
            this.setProgressCallback(progress);
            DNState state = this.getState();
            Log.v(TAG, "DNState: " + (state == null ? "null" : state.getClass().getCanonicalName()));
            if (state == null) {
                state = this.determinStateFromInfo(info);
                this.setState(state);
                if (state instanceof DNSuspended) {
                    this.setCompletedInBytes(info.getCompletedSizeInBytes());
                    this.setTotalInBytes(info.totalSizeInBytes);
                    this.setEtag(info.getEtag());
                }
            }
            File newDestFile = this.getDestFile();
            if (!(state instanceof DNNoEntry) && this.hasFileChanged(newDestFile, info)) {
                this.getTransferStore().remove(this);
                state = new DNNoEntry();
                this.setState(state);
                throw new TerminatedException("Destination file body has changed.", new FileModifiedException("Destination file has modified"));
            }
            state.transfer(this);
        }
        catch (StoreException e) {
            throw new StateStoreAccessException("Failed to access storage");
        }
        finally {
            if (sem != null) {
                Log.v(TAG, "sem release");
                sem.release();
            }
        }
    }

    @Override
    public void suspend() throws NoEntryException, StateStoreAccessException {
        this.doSuspend();
    }

    @Override
    public void suspendAsync(final @Nullable KiiRTransferCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiDownloaderImpl.this);
                        }
                    }
                });
                final AtomicReference<Exception> ex = new AtomicReference<Exception>();
                try {
                    KiiDownloaderImpl.this.doSuspend();
                }
                catch (Exception e) {
                    ex.set(e);
                }
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSuspendCompleted(KiiDownloaderImpl.this, (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    private void doSuspend() throws StateStoreAccessException, NoEntryException {
        try {
            this.startCancel(false);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Unexpected error", e1);
        }
        DNState state = this.getState();
        if (state == null) {
            boolean stored = false;
            try {
                stored = this.getTransferStore().isStored(this);
            }
            catch (StoreException e) {
                throw new StateStoreAccessException("Failed to access storage");
            }
            state = stored ? new DNSuspended() : new DNNoEntry();
            this.setState(state);
        }
        state.suspend(this);
        this.truncateUnfinishedChunk();
    }

    @Override
    public void terminate() throws NoEntryException, StateStoreAccessException {
        this.doTerminate();
    }

    @Override
    public void terminateAsync(final @Nullable KiiRTransferCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiDownloaderImpl.this);
                        }
                    }
                });
                final AtomicReference<Exception> ex = new AtomicReference<Exception>();
                try {
                    KiiDownloaderImpl.this.doTerminate();
                }
                catch (Exception e) {
                    ex.set(e);
                }
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onTerminateCompleted(KiiDownloaderImpl.this, (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    private void doTerminate() throws StateStoreAccessException, NoEntryException {
        try {
            this.startCancel(true);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Unexpected error", e1);
        }
        DNState state = this.getState();
        if (state == null) {
            boolean stored = false;
            try {
                stored = this.getTransferStore().isStored(this);
            }
            catch (StoreException e) {
                throw new StateStoreAccessException("Failed to access storage");
            }
            state = stored ? new DNSuspended() : new DNNoEntry();
            this.setState(state);
        }
        state.terminate(this);
        this.setCompletedInBytes(0L);
    }

    @Override
    @Nullable
    public KiiRTransferInfo info() throws StateStoreAccessException {
        try {
            return this.getTransferStore().findByDownloader(this);
        }
        catch (StoreException e) {
            throw new StateStoreAccessException("Failed to access storage");
        }
    }

    @Override
    public void infoAsync(final @NonNull KiiRTransferCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Can't get the result without callback ");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiDownloaderImpl.this);
                        }
                    }
                });
                final AtomicReference<Exception> ex = new AtomicReference<Exception>();
                final AtomicReference<KiiRTransferInfo> infoRef = new AtomicReference<KiiRTransferInfo>();
                try {
                    KiiRTransferInfo info = KiiDownloaderImpl.this.info();
                    infoRef.set(info);
                }
                catch (Exception e) {
                    ex.set(e);
                }
                KiiDownloaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onInfoCompleted(KiiDownloaderImpl.this, (KiiRTransferInfo)infoRef.get(), (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    @NonNull
    public File getDestFile() {
        return this.destFile;
    }

    FileHolderInternal getFileHolderInternal() {
        return this.fileHolderInternal;
    }

    void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    long getCompletedInBytes() {
        return this.completedInBytes;
    }

    long getTotalInBytes() {
        return this.totalInBytes;
    }

    void setCompletedInBytes(long completedInBytes) {
        this.completedInBytes = completedInBytes;
    }

    void setTotalInBytes(long totalInBytes) {
        this.totalInBytes = totalInBytes;
    }

    boolean hasAllChunkReceived() {
        return this.getCompletedInBytes() >= this.getTotalInBytes();
    }

    String getEtag() {
        return this.eTag;
    }

    void setEtag(String eTag) {
        this.eTag = eTag;
    }

    void startCancel(boolean terminate) throws InterruptedException {
        this.cancelSemaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
        this.cancelByTermination = terminate;
    }

    void cancelDone() {
        this.cancelSemaphore.release();
    }

    boolean cancelledByTermination() {
        return this.cancelByTermination;
    }

    synchronized DownloadFutureExecutor getDownloadFutureExecutor() {
        return this.dnFutureExecutor;
    }

    synchronized boolean doingTransfer() {
        if (DownloaderSemaphore.getSemaphore(this).tryAcquire()) {
            DownloaderSemaphore.getSemaphore(this).release();
            return false;
        }
        return true;
    }

    @Nullable
    public KiiRTransferProgressCallback getProgressCallback() {
        return this.prgCallback;
    }

    public void setProgressCallback(@Nullable KiiRTransferProgressCallback prgCallback) {
        this.prgCallback = prgCallback;
    }

    private DNState determinStateFromInfo(DownloaderInfoImpl info) throws StoreException {
        if (info.status == KiiRTransferStatus.NOENTRY) {
            return new DNNoEntry();
        }
        if (info.status == KiiRTransferStatus.ONGOING) {
            return new DNOnGoing();
        }
        return new DNSuspended();
    }

    private boolean hasFileChanged(File newDestFile, DownloaderInfoImpl info) {
        if (!newDestFile.getAbsolutePath().equals(info.getDestFilePath())) {
            return true;
        }
        return newDestFile.lastModified() != info.getDestFileModifiedTime();
    }

    void executeProgressCallbackOnMainThread() {
        final long completdInBytes = this.getCompletedInBytes();
        final long totalInBytes = this.getTotalInBytes();
        final KiiRTransferProgressCallback pCallback = this.getProgressCallback();
        if (pCallback != null) {
            this.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    pCallback.onProgress(KiiDownloaderImpl.this, completdInBytes, totalInBytes);
                }
            });
        }
    }

    private void postToMainThread(Runnable runnable) {
        this.getMainHandler().post(runnable);
    }

    private synchronized Handler getMainHandler() {
        return this.mainHandler;
    }

    synchronized Uri getHolderUri() {
        return this.holderUri;
    }

    synchronized void setHolderUri(Uri holderUri) {
        this.holderUri = holderUri;
    }

    void setKey(String key) {
        this.key = key;
    }

    long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long lastModifiedTime) {
        this.lastModified = lastModifiedTime;
    }

    long getDestFileSize() {
        return this.destFileSize;
    }

    void setDestFileSize(long destFileSize) {
        this.destFileSize = destFileSize;
    }

    RTransferDownloadInfoStore getTransferStore() {
        return this.transferStore;
    }

    synchronized void truncateUnfinishedChunk() throws StateStoreAccessException {
        Log.i(TAG, "Downloaded file size : " + this.getDestFile().length());
        if (this.getDestFile().length() % (long)this.getChunkSize() != 0L && this.getDestFile().length() > this.getCompletedInBytes()) {
            Log.i(TAG, "Do file align to : " + this.getDestFile().length() + " -> " + this.getCompletedInBytes());
            RandomAccessFile rFile = null;
            try {
                rFile = new RandomAccessFile(this.getDestFile(), "rwd");
                rFile.setLength(this.getCompletedInBytes());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (rFile != null) {
                    try {
                        rFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.setLastModified(this.getDestFile().lastModified());
            try {
                this.getTransferStore().save(this);
            }
            catch (StoreException e) {
                throw new StateStoreAccessException("Failed to access storage");
            }
        }
    }
}

