/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.FileModifiedException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.ResumableTransferApi;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UPState;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogic;
import com.kii.cloud.storage.utils.Log;
import java.io.IOException;

public class KiiCloudUploaderLogic
implements UploaderLogic {
    public static final String TAG = "CommonLogic";
    private boolean cancelled = false;

    @Override
    public void setCancelled() {
        this.cancelled = true;
    }

    @Override
    public void startUpload(@NonNull KiiUploaderImpl uploader, @NonNull UPState state) throws TerminatedException {
        if (this.cancelled) {
            return;
        }
        try {
            ResumableTransferApi.startUpload(uploader);
            if (this.cancelled) {
                return;
            }
            uploader.getTransferStore().save(uploader);
        }
        catch (AppException e) {
            state.abortGettingUploadId(uploader, e);
        }
        catch (IOException e) {
            state.abortGettingUploadId(uploader, e);
        }
        catch (StoreException e) {
            state.abortGettingUploadId(uploader, e);
        }
    }

    @Override
    public void chunkUpload(@NonNull KiiUploaderImpl uploader, @NonNull UPState state) throws SuspendedException, TerminatedException {
        while (!uploader.hasAllChunkSent()) {
            if (this.cancelled) {
                return;
            }
            try {
                if (uploader.hasFileChangeFromInitiation()) {
                    throw new FileModifiedException("File body has been changed.");
                }
                long completedInBytes = ResumableTransferApi.upload(uploader);
                if (this.cancelled) {
                    return;
                }
                uploader.setCompletedInBytes(completedInBytes);
                uploader.getTransferStore().save(uploader);
                uploader.executeProgressCallbackOnMainThread();
            }
            catch (AppException e) {
                state.abortChunkUploading(uploader, e);
            }
            catch (IOException e) {
                state.abortChunkUploading(uploader, e);
            }
            catch (StoreException e) {
                state.abortChunkUploading(uploader, e);
            }
            catch (FileModifiedException e) {
                state.abortChunkUploading(uploader, e);
            }
        }
    }

    @Override
    public boolean resumable(@NonNull KiiUploaderImpl uploader, @NonNull UPState state) throws TerminatedException, SuspendedException {
        try {
            String hash = ResumableTransferApi.getHash(uploader);
            String currHash = "\"" + uploader.getHashGenerator().getHash(uploader.getSourceFile()) + "\"";
            Log.v(TAG, "currHash: " + currHash);
            boolean resumable = hash.equals(currHash);
            if (!resumable) {
                uploader.getTransferStore().remove(uploader);
            }
            return resumable;
        }
        catch (AppException e) {
            state.abortResumableCheck(uploader, e);
        }
        catch (IOException e) {
            state.abortResumableCheck(uploader, e);
        }
        catch (StoreException e) {
            state.abortResumableCheck(uploader, e);
        }
        throw new RuntimeException("Should not reach here");
    }

    @Override
    public void commitUpload(@NonNull KiiUploaderImpl uploader, @NonNull UPState state) throws SuspendedException, TerminatedException {
        if (this.cancelled) {
            return;
        }
        try {
            ResumableTransferApi.commit(uploader);
            uploader.getTransferStore().remove(uploader);
        }
        catch (AppException e) {
            state.abortCommit(uploader, e);
        }
        catch (IOException e) {
            state.abortCommit(uploader, e);
        }
        catch (StoreException e) {
            state.abortCommit(uploader, e);
        }
    }

    @Override
    public boolean isRecoverble(@Nullable Throwable cause) {
        if (cause instanceof IOException) {
            return true;
        }
        if (cause instanceof UndefinedException) {
            int status = ((UndefinedException)cause).getStatus();
            return status != 416 && status != 412;
        }
        return false;
    }
}

