/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteFullException;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.KiiDownloader;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferStatus;
import com.kii.cloud.storage.resumabletransfer.KiiUploader;
import com.kii.cloud.storage.resumabletransfer.impl.DownloaderInfoImpl;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderFactory;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderFactory;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferDownloadInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferInfoStoreDB;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferUploadInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderInfoImpl;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KiiCloudRTransferInfoStore
implements RTransferUploadInfoStore,
RTransferDownloadInfoStore {
    private static KiiCloudRTransferInfoStore INSTANCE = new KiiCloudRTransferInfoStore();
    private RTransferInfoStoreDB db;
    private static final String TAG = "KiiCloudRTransferInfoStore";

    @NonNull
    public static KiiCloudRTransferInfoStore getInstance() {
        return INSTANCE;
    }

    private synchronized void init(Context ctx) {
        if (this.db == null) {
            this.db = RTransferInfoStoreDB.getInstance();
            this.db.init(ctx);
        }
    }

    @Override
    public void save(@NonNull KiiUploaderImpl uploader) throws StoreException {
        try {
            this.init(uploader.getContext());
            if (this.isStored(uploader)) {
                this.update(uploader);
            } else {
                this.insert(uploader);
            }
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
    }

    private void insert(KiiUploaderImpl uploader) throws StoreException {
        ContentValues cv = new ContentValues();
        Uri holderUri = uploader.getHolderUri();
        cv.put("holder_uri", holderUri.toString());
        cv.put("completed_size", Long.valueOf(uploader.getCompletedInBytes()));
        cv.put("direction", Integer.valueOf(0));
        cv.put("file_modified_time", Long.valueOf(uploader.getSourceFile().lastModified()));
        cv.put("source_file_path", uploader.getSourceFile().getAbsolutePath());
        cv.put("total_size", Long.valueOf(uploader.getSourceFile().length()));
        cv.put("upload_id", uploader.getUploadId());
        cv.put("initiator_uri", uploader.getInitiatorUri().toString());
        long ret = this.db.insert(cv);
        if (ret == -1L) {
            throw new StoreException("insert returns -1");
        }
    }

    private void update(KiiUploaderImpl uploader) throws StoreException {
        ContentValues cv = new ContentValues();
        Uri uri = uploader.getHolderUri();
        String path = uploader.getSourceFile().getAbsolutePath();
        cv.put("completed_size", Long.valueOf(uploader.getCompletedInBytes()));
        int num = this.db.update(cv, "holder_uri=? AND source_file_path=?", new String[]{uri.toString(), path});
        if (num < 1) {
            throw new StoreException("update returns less than 1");
        }
    }

    @Override
    public void remove(@NonNull KiiUploaderImpl uploader) throws StoreException {
        this.init(uploader.getContext());
        try {
            String queryStr = "holder_uri=? AND source_file_path=?";
            String uriStr = uploader.getHolderUri().toString();
            Object[] queryParam = new String[]{uriStr, uploader.getSourceFile().getAbsolutePath()};
            Log.v(TAG, "queryStr: " + queryStr);
            Log.v(TAG, "queryParam: " + Arrays.toString(queryParam));
            int count = this.db.delete(queryStr, (String[])queryParam);
            Log.v(TAG, "removed count: " + count);
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
    }

    @Override
    public boolean isStored(@NonNull KiiUploaderImpl uploader) throws StoreException {
        this.init(uploader.getContext());
        Cursor c = null;
        Uri holderUri = uploader.getHolderUri();
        if (holderUri == null) {
            return false;
        }
        try {
            c = this.db.query("holder_uri=? AND direction=? AND source_file_path=?", new String[]{holderUri.toString(), String.valueOf(0), uploader.getSourceFile().getAbsolutePath()});
            boolean bl = c.moveToNext();
            return bl;
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public UploaderInfoImpl findByUploader(@NonNull KiiUploaderImpl uploader) throws StoreException {
        this.init(uploader.getContext());
        Cursor c = null;
        Uri holderUri = uploader.getHolderUri();
        if (holderUri == null) {
            UploaderInfoImpl info = new UploaderInfoImpl(KiiRTransferStatus.NOENTRY, 0L, uploader.getTotalInBytes(), uploader.getSourceFile().lastModified(), uploader.getSourceFile().getAbsolutePath(), null);
            return info;
        }
        try {
            UploaderInfoImpl info;
            String filepath = uploader.getSourceFile().getAbsolutePath();
            c = this.db.query("holder_uri=? AND source_file_path=? AND initiator_uri=?", new String[]{holderUri.toString(), filepath, uploader.getInitiatorUri().toString()});
            if (c.moveToNext()) {
                UploaderInfoImpl info2;
                Log.v(TAG, "findByUploader c.getCount(): " + c.getCount());
                long complSize = c.getLong(c.getColumnIndex("completed_size"));
                long totalSize = c.getLong(c.getColumnIndex("total_size"));
                long fileModified = c.getLong(c.getColumnIndex("file_modified_time"));
                String sourceFilePath = c.getString(c.getColumnIndex("source_file_path"));
                String uploadId = c.getString(c.getColumnIndex("upload_id"));
                KiiRTransferStatus status = uploader.doingTransfer() ? KiiRTransferStatus.ONGOING : KiiRTransferStatus.SUSPENDED;
                UploaderInfoImpl uploaderInfoImpl = info2 = new UploaderInfoImpl(status, complSize, totalSize, fileModified, sourceFilePath, uploadId);
                return uploaderInfoImpl;
            }
            UploaderInfoImpl uploaderInfoImpl = info = new UploaderInfoImpl(KiiRTransferStatus.NOENTRY, 0L, uploader.getTotalInBytes(), uploader.getSourceFile().lastModified(), uploader.getSourceFile().getAbsolutePath(), null);
            return uploaderInfoImpl;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<KiiUploader> findUploadEntriesByBucketUriAndInitiatorUri(@NonNull Context context, @NonNull Uri bucketUri, @NonNull Uri initiatorUri) throws StoreException {
        this.init(context);
        ArrayList<KiiUploader> list = new ArrayList<KiiUploader>();
        try (Cursor c = null;){
            c = RTransferInfoStoreDB.getInstance().query("holder_uri LIKE ? AND direction=? AND initiator_uri=?", new String[]{bucketUri.toString() + "%", String.valueOf(0), initiatorUri.toString()});
            if (c == null || !c.moveToFirst()) {
                ArrayList<KiiUploader> arrayList = list;
                return arrayList;
            }
            do {
                long complSize = c.getLong(c.getColumnIndex("completed_size"));
                String sourceFilePath = c.getString(c.getColumnIndex("source_file_path"));
                String holderUri = c.getString(c.getColumnIndex("holder_uri"));
                String uploadId = c.getString(c.getColumnIndex("upload_id"));
                Uri uri = Uri.parse((String)holderUri);
                KiiUploaderImpl uploader = KiiUploaderFactory.newUploader(context, Utils.createHolderByUri(uri), new File(sourceFilePath));
                uploader.setCompletedInBytes(complSize);
                uploader.setUploadId(uploadId);
                list.add(uploader);
            } while (c.moveToNext());
            ArrayList<KiiUploader> arrayList = list;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<KiiDownloader> findDownloadEntriesByBucketUriAndInitiatorUri(@NonNull Context context, @NonNull Uri bucketUri, @NonNull Uri initiatorUri) throws StoreException {
        this.init(context);
        ArrayList<KiiDownloader> list = new ArrayList<KiiDownloader>();
        try (Cursor c = null;){
            c = RTransferInfoStoreDB.getInstance().query("holder_uri LIKE ? AND direction=? AND initiator_uri=?", new String[]{bucketUri.toString() + "%", String.valueOf(1), initiatorUri.toString()});
            if (c == null || !c.moveToFirst()) {
                ArrayList<KiiDownloader> arrayList = list;
                return arrayList;
            }
            do {
                long complSize = c.getLong(c.getColumnIndex("completed_size"));
                String destFilePath = c.getString(c.getColumnIndex("dest_file_path"));
                String holderUri = c.getString(c.getColumnIndex("holder_uri"));
                Uri uri = Uri.parse((String)holderUri);
                String etag = c.getString(c.getColumnIndex("etag"));
                try {
                    KiiDownloaderImpl downloader = KiiDownloaderFactory.newDownloader(context, Utils.createHolderByUri(uri), new File(destFilePath));
                    downloader.setCompletedInBytes(complSize);
                    downloader.setEtag(etag);
                    list.add(downloader);
                }
                catch (InvalidHolderException e) {
                    throw new RuntimeException("Unexpected error", e);
                }
            } while (c.moveToNext());
            ArrayList<KiiDownloader> arrayList = list;
            return arrayList;
        }
    }

    @Override
    public void save(@NonNull KiiDownloaderImpl downloader) throws StoreException {
        try {
            this.init(downloader.getContext());
            if (this.isStored(downloader)) {
                int num = this.update(downloader);
                if (num < 1) {
                    throw new StoreException("update returns less than 1");
                }
            } else {
                this.insert(downloader);
            }
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
    }

    @Override
    public boolean updateIfExists(@NonNull KiiDownloaderImpl downloader) throws StoreException {
        try {
            this.init(downloader.getContext());
            int num = this.update(downloader);
            Log.v(TAG, "updated row: " + num);
            return num > 0;
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
    }

    private void insert(KiiDownloaderImpl downloader) throws StoreException {
        ContentValues cv = new ContentValues();
        Uri holderUri = downloader.getHolderUri();
        cv.put("holder_uri", holderUri.toString());
        cv.put("completed_size", Long.valueOf(downloader.getCompletedInBytes()));
        cv.put("direction", Integer.valueOf(1));
        cv.put("file_modified_time", Long.valueOf(downloader.getLastModified()));
        cv.put("total_size", Long.valueOf(downloader.getTotalInBytes()));
        cv.put("etag", downloader.getEtag());
        cv.put("dest_file_path", downloader.getDestFile().getAbsolutePath());
        cv.put("initiator_uri", downloader.getInitiatorUri().toString());
        long ret = this.db.insert(cv);
        if (ret == -1L) {
            throw new StoreException("insert returns -1");
        }
    }

    private int update(KiiDownloaderImpl downloader) throws StoreException {
        ContentValues cv = new ContentValues();
        cv.put("completed_size", Long.valueOf(downloader.getCompletedInBytes()));
        cv.put("etag", downloader.getEtag());
        cv.put("file_modified_time", Long.valueOf(downloader.getLastModified()));
        String uri = downloader.getHolderUri().toString();
        String whereClause = "holder_uri=? AND direction=? AND dest_file_path=?";
        String[] whereArgs = new String[]{uri, String.valueOf(1), downloader.getDestFile().getAbsolutePath()};
        int num = this.db.update(cv, whereClause, whereArgs);
        return num;
    }

    @Override
    public void remove(@NonNull KiiDownloaderImpl downloader) throws StoreException {
        this.init(downloader.getContext());
        try {
            String uri = downloader.getHolderUri().toString();
            String whereClause = "holder_uri=? AND direction=? AND dest_file_path=?";
            String[] whereArgs = new String[]{uri, String.valueOf(1), downloader.getDestFile().getAbsolutePath()};
            int count = this.db.delete(whereClause, whereArgs);
            Log.v(TAG, "removed(dn): " + count);
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
    }

    @Override
    public boolean isStored(@NonNull KiiDownloaderImpl downloader) throws StoreException {
        this.init(downloader.getContext());
        Cursor c = null;
        Uri holderUri = downloader.getHolderUri();
        if (holderUri == null) {
            return false;
        }
        try {
            String selection = "holder_uri=? AND direction=? AND dest_file_path=?";
            String[] selectionArgs = new String[]{holderUri.toString(), String.valueOf(1), downloader.getDestFile().getAbsolutePath()};
            c = this.db.query(selection, selectionArgs);
            boolean bl = c.moveToNext();
            return bl;
        }
        catch (SQLiteDiskIOException e) {
            throw new StoreException((SQLException)e);
        }
        catch (SQLiteFullException e) {
            throw new StoreException((SQLException)e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public DownloaderInfoImpl findByDownloader(@NonNull KiiDownloaderImpl downloader) throws StoreException {
        this.init(downloader.getContext());
        Cursor c = null;
        Uri holderUri = downloader.getHolderUri();
        if (holderUri == null) {
            DownloaderInfoImpl info = new DownloaderInfoImpl(KiiRTransferStatus.NOENTRY, 0L, downloader.getTotalInBytes(), downloader.getDestFile().getAbsolutePath(), downloader.getDestFile().lastModified(), null);
            return info;
        }
        try {
            DownloaderInfoImpl info;
            String filepath = downloader.getDestFile().getAbsolutePath();
            String selection = "holder_uri=? AND direction=? AND dest_file_path=? AND initiator_uri=?";
            String[] selectionArgs = new String[]{holderUri.toString(), String.valueOf(1), filepath, downloader.getInitiatorUri().toString()};
            c = this.db.query(selection, selectionArgs);
            Log.v(TAG, "found row: " + c.getCount());
            if (c.moveToNext()) {
                DownloaderInfoImpl info2;
                long complSize = c.getLong(c.getColumnIndex("completed_size"));
                long totalSize = c.getLong(c.getColumnIndex("total_size"));
                String destFilePath = c.getString(c.getColumnIndex("dest_file_path"));
                String etag = c.getString(c.getColumnIndex("etag"));
                long lastModified = c.getLong(c.getColumnIndex("file_modified_time"));
                KiiRTransferStatus status = null;
                status = downloader.doingTransfer() ? KiiRTransferStatus.ONGOING : KiiRTransferStatus.SUSPENDED;
                DownloaderInfoImpl downloaderInfoImpl = info2 = new DownloaderInfoImpl(status, complSize, totalSize, destFilePath, lastModified, etag);
                return downloaderInfoImpl;
            }
            DownloaderInfoImpl downloaderInfoImpl = info = new DownloaderInfoImpl(KiiRTransferStatus.NOENTRY, 0L, downloader.getTotalInBytes(), downloader.getDestFile().getAbsolutePath(), downloader.getDestFile().lastModified(), null);
            return downloaderInfoImpl;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }
}

