/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.DNState;
import com.kii.cloud.storage.resumabletransfer.impl.FileModifiedException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.ResumableTransferApi;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.utils.Log;
import java.io.IOException;

public class DownloaderCommonLogic {
    public static final String TAG = "DownloaderCommonLogic";
    private boolean cancelled = false;

    public void setCancelled() {
        this.cancelled = true;
    }

    @Deprecated
    public boolean cancelled() {
        return this.cancelled;
    }

    public void chunkDownload(@NonNull KiiDownloaderImpl downloader, @NonNull DNState state) throws SuspendedException, TerminatedException {
        block15: {
            try {
                if (this.cancelled) {
                    return;
                }
                downloader.getTransferStore().save(downloader);
                while (!downloader.hasAllChunkReceived()) {
                    if (this.cancelled) {
                        return;
                    }
                    if (downloader.getCompletedInBytes() != 0L && this.hasFileChanged(downloader)) {
                        throw new FileModifiedException("Dest file body has been changed.");
                    }
                    long completedInBytes = ResumableTransferApi.download(downloader, this);
                    if (this.cancelled) {
                        return;
                    }
                    downloader.setCompletedInBytes(completedInBytes);
                    downloader.setLastModified(downloader.getDestFile().lastModified());
                    downloader.setDestFileSize(downloader.getDestFile().length());
                    boolean isUpdated = downloader.getTransferStore().updateIfExists(downloader);
                    if (!isUpdated) {
                        downloader.setCompletedInBytes(0L);
                    }
                    if (this.cancelled) {
                        return;
                    }
                    downloader.executeProgressCallbackOnMainThread();
                }
                downloader.getTransferStore().remove(downloader);
            }
            catch (AppException e) {
                if (!this.cancelled) {
                    state.abortChunkDownloading(downloader, e);
                }
            }
            catch (IOException e) {
                if (!this.cancelled) {
                    state.abortChunkDownloading(downloader, e);
                }
            }
            catch (StoreException e) {
                if (!this.cancelled) {
                    state.abortChunkDownloading(downloader, e);
                }
            }
            catch (FileModifiedException e) {
                if (this.cancelled) break block15;
                state.abortChunkDownloading(downloader, e);
            }
        }
    }

    public boolean resumable(@NonNull KiiDownloaderImpl downloader, @NonNull DNState state) throws TerminatedException, SuspendedException {
        try {
            String eTag = ResumableTransferApi.getBodyEtag(downloader);
            String currEtag = downloader.getEtag();
            boolean resumable = eTag.equals(currEtag);
            if (!resumable) {
                downloader.getTransferStore().remove(downloader);
            }
            Log.v(TAG, "resumable: " + resumable);
            return resumable;
        }
        catch (AppException e) {
            state.abortResumableCheck(downloader, e);
        }
        catch (IOException e) {
            state.abortResumableCheck(downloader, e);
        }
        catch (StoreException e) {
            state.abortResumableCheck(downloader, e);
        }
        throw new RuntimeException("Should not reach here");
    }

    public static boolean isRecoverble(@Nullable Throwable cause) {
        if (cause instanceof IOException) {
            return true;
        }
        if (cause instanceof UndefinedException) {
            int status = ((UndefinedException)cause).getStatus();
            return status != 416 && status != 412;
        }
        return cause instanceof StoreException;
    }

    public void getBodyLengthInBytes(@NonNull KiiDownloaderImpl downloader, @NonNull DNState state) throws SuspendedException, TerminatedException {
        try {
            long totalLength = ResumableTransferApi.getBodyLengthInBytes(downloader);
            if (totalLength <= 0L) {
                throw new NotFoundException("Body does not exists in the cloud", null, NotFoundException.Reason.OBJECT_BODY_NOT_FOUND, null);
            }
            downloader.setTotalInBytes(totalLength);
        }
        catch (AppException e) {
            state.abortChunkDownloading(downloader, e);
        }
        catch (IOException e) {
            state.abortChunkDownloading(downloader, e);
        }
    }

    private boolean hasFileChanged(KiiDownloaderImpl downloader) {
        Log.v(TAG, "hasFileChanged: ");
        Log.v(TAG, "downloader.getLastModified() " + downloader.getLastModified());
        Log.v(TAG, "downloader.getDestFile().lastModified() " + downloader.getDestFile().lastModified());
        Log.v(TAG, "downloader.getDestFileSize() " + downloader.getDestFileSize());
        Log.v(TAG, "downloader.getDestFile().length() " + downloader.getDestFile().length());
        if (downloader.getLastModified() != downloader.getDestFile().lastModified()) {
            return true;
        }
        return downloader.getDestFileSize() != downloader.getDestFile().length();
    }
}

