/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.resumabletransfer.AlreadyStartedException;
import com.kii.cloud.storage.resumabletransfer.NoEntryException;
import com.kii.cloud.storage.resumabletransfer.StateStoreAccessException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.DNOnGoing;
import com.kii.cloud.storage.resumabletransfer.impl.DNState;
import com.kii.cloud.storage.resumabletransfer.impl.DNSuspended;
import com.kii.cloud.storage.resumabletransfer.impl.DownloadFuture;
import com.kii.cloud.storage.resumabletransfer.impl.DownloaderCommonLogic;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class DNNoEntry
implements DNState {
    @Override
    public void transfer(final @NonNull KiiDownloaderImpl downloader) throws AlreadyStartedException, TerminatedException, SuspendedException {
        final DownloaderCommonLogic cl = new DownloaderCommonLogic();
        downloader.setState(new DNOnGoing());
        DownloadFuture ufNew = new DownloadFuture(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cl.getBodyLengthInBytes(downloader, DNNoEntry.this);
                cl.chunkDownload(downloader, DNNoEntry.this);
                return null;
            }
        });
        try {
            downloader.getDownloadFutureExecutor().executeFuture(ufNew);
            ufNew.get();
            downloader.setState(new DNNoEntry());
        }
        catch (InterruptedException e) {
            throw new SuspendedException("Transfer suspended", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TerminatedException) {
                throw (TerminatedException)cause;
            }
            if (cause instanceof SuspendedException) {
                throw (SuspendedException)cause;
            }
            throw new RuntimeException("Unexpected error", cause);
        }
        catch (CancellationException e) {
            cl.setCancelled();
            if (downloader.cancelledByTermination()) {
                try {
                    downloader.getTransferStore().remove(downloader);
                    downloader.setState(new DNNoEntry());
                    throw new TerminatedException("transfer has terminated");
                }
                catch (StoreException e1) {
                    downloader.setState(new DNSuspended());
                    throw new SuspendedException("transfer is suspended");
                }
            }
            downloader.setState(new DNSuspended());
            throw new SuspendedException("transfer is suspended");
        }
        finally {
            downloader.cancelDone();
        }
    }

    @Override
    public void suspend(@NonNull KiiDownloaderImpl downloader) throws NoEntryException {
        downloader.cancelDone();
        throw new NoEntryException("No entry.");
    }

    @Override
    public void terminate(@NonNull KiiDownloaderImpl downloader) throws NoEntryException, StateStoreAccessException {
        downloader.cancelDone();
        throw new NoEntryException("No entry.");
    }

    @Override
    public void abortChunkDownloading(@NonNull KiiDownloaderImpl downloader, @Nullable Throwable cause) throws SuspendedException, TerminatedException {
        if (DownloaderCommonLogic.isRecoverble(cause)) {
            downloader.setState(new DNSuspended());
            throw new SuspendedException(cause);
        }
        try {
            downloader.getTransferStore().remove(downloader);
            downloader.setState(new DNNoEntry());
            throw new TerminatedException(cause);
        }
        catch (StoreException ioe) {
            downloader.setState(new DNSuspended());
            throw new SuspendedException(cause);
        }
    }

    @Override
    public void abortResumableCheck(@Nullable KiiDownloaderImpl downloader, @Nullable Throwable cause) throws TerminatedException, SuspendedException {
        throw new IllegalStateException("Unexpected state.");
    }
}

