/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.query;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.query.KiiClause;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiQuery {
    private JSONObject mJson = new JSONObject();
    private String nextPaginationKey = null;
    private int mLimit;
    private static final JSONObject ALLCLAUSE;

    public KiiQuery(@Nullable KiiClause clause) {
        try {
            if (clause == null) {
                this.mJson.put("clause", (Object)ALLCLAUSE);
            } else {
                this.mJson.put("clause", (Object)clause.toJson());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Query clause generate error", e);
        }
    }

    @NonNull
    public static KiiQuery create(@Nullable String queryString) {
        try {
            JSONObject queryJson;
            KiiQuery query = new KiiQuery();
            if (queryString == null) {
                queryJson = new JSONObject();
                queryJson.put("clause", (Object)ALLCLAUSE);
            } else {
                queryJson = new JSONObject(queryString);
            }
            query.mJson = queryJson;
            return query;
        }
        catch (JSONException e) {
            throw new RuntimeException("Query clause generate error", e);
        }
    }

    public KiiQuery() {
        this(null);
    }

    public void sortByDesc(@NonNull String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Empty key is not acceptable.");
        }
        try {
            this.mJson.put("orderBy", (Object)key);
            this.mJson.put("descending", true);
        }
        catch (JSONException jse) {
            throw new IllegalArgumentException("Invalid arugment.", jse);
        }
    }

    public void sortByAsc(@NonNull String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Empty key is not acceptable.");
        }
        try {
            this.mJson.put("orderBy", (Object)key);
            this.mJson.put("descending", false);
        }
        catch (JSONException jse) {
            throw new IllegalArgumentException("Invalid arugment.", jse);
        }
    }

    public void setLimit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("Expects value higher than 0 for limit");
        }
        this.mLimit = limit;
    }

    void setNextPaginationKey(String key) {
        this.nextPaginationKey = key;
    }

    JSONObject toJson() {
        JSONObject query = new JSONObject();
        try {
            query.put("bucketQuery", (Object)this.mJson);
            if (this.nextPaginationKey != null) {
                query.put("paginationKey", (Object)this.nextPaginationKey);
            }
            if (this.mLimit > 0) {
                query.put("bestEffortLimit", this.mLimit);
            }
        }
        catch (JSONException jse) {
            throw new RuntimeException("Unexpected error.", jse);
        }
        return query;
    }

    @NonNull
    public String toString() {
        return this.toJson().toString();
    }

    static {
        try {
            ALLCLAUSE = new JSONObject("{\"type\":\"all\"}");
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error!", e);
        }
    }
}

