/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.query;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.GeoPoint;
import com.kii.cloud.storage.utils.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiClause {
    private JSONObject mJson = null;

    private KiiClause() {
    }

    JSONObject toJson() {
        return this.mJson;
    }

    @NonNull
    public static KiiClause equals(@NonNull String key, int value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"eq");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("value", value);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause equals(@NonNull String key, long value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"eq");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("value", value);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause equals(@NonNull String key, double value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"eq");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("value", value);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause equals(@NonNull String key, boolean value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"eq");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("value", value);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause equals(@NonNull String key, @NonNull String value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"eq");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("value", (Object)value);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause equals(@NonNull String key, @NonNull Object value) {
        KiiClause.checkInstance1(value);
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"eq");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("value", value);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause notEquals(@NonNull String key, int value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"not");
            clause.mJson.put("clause", (Object)KiiClause.equals(key, value).toJson());
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause notEquals(@NonNull String key, long value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"not");
            clause.mJson.put("clause", (Object)KiiClause.equals(key, value).toJson());
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause notEquals(@NonNull String key, double value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"not");
            clause.mJson.put("clause", (Object)KiiClause.equals(key, value).toJson());
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause notEquals(@NonNull String key, boolean value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"not");
            clause.mJson.put("clause", (Object)KiiClause.equals(key, value).toJson());
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause notEquals(@NonNull String key, @NonNull String value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"not");
            clause.mJson.put("clause", (Object)KiiClause.equals(key, value).toJson());
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause notEquals(@NonNull String key, @NonNull Object value) {
        KiiClause.checkInstance1(value);
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"not");
            clause.mJson.put("clause", (Object)KiiClause.equals(key, value).toJson());
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause or(KiiClause ... clauses) {
        if (clauses == null) {
            throw new IllegalArgumentException("Clause can not be null");
        }
        if (clauses.length <= 0) {
            throw new IllegalArgumentException("No clause found");
        }
        if (clauses.length == 1) {
            return clauses[0];
        }
        KiiClause cls = new KiiClause();
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"or");
            JSONArray array = new JSONArray();
            for (int i = 0; i < clauses.length; ++i) {
                KiiClause clause = clauses[i];
                array.put((Object)clause.toJson());
            }
            json.put("clauses", (Object)array);
            cls.mJson = json;
        }
        catch (JSONException jse) {
            throw new IllegalArgumentException("Invalid arugment.", jse);
        }
        return cls;
    }

    @NonNull
    public static KiiClause and(KiiClause ... clauses) {
        if (clauses == null) {
            throw new IllegalArgumentException("Clause can not be null");
        }
        if (clauses.length <= 0) {
            throw new IllegalArgumentException("No clause found");
        }
        if (clauses.length == 1) {
            return clauses[0];
        }
        KiiClause cls = new KiiClause();
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"and");
            JSONArray array = new JSONArray();
            for (int i = 0; i < clauses.length; ++i) {
                KiiClause clause = clauses[i];
                array.put((Object)clause.toJson());
            }
            json.put("clauses", (Object)array);
            cls.mJson = json;
        }
        catch (JSONException jse) {
            throw new IllegalArgumentException("Invalid arugment.", jse);
        }
        return cls;
    }

    @NonNull
    public static KiiClause not(@NonNull KiiClause clause) {
        if (clause == null) {
            throw new IllegalArgumentException("Clause can not be null");
        }
        KiiClause cls = new KiiClause();
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"not");
            json.put("clause", (Object)clause.toJson());
            cls.mJson = json;
        }
        catch (JSONException jse) {
            throw new IllegalArgumentException("Invalid arugment.", jse);
        }
        return cls;
    }

    @NonNull
    public static KiiClause inWithIntValue(@NonNull String key, int ... value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        if (value.length < 1 || value.length > 200) {
            throw new IllegalArgumentException("value is empty or exceeds maximum length(200)");
        }
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"in");
            clause.mJson.put("field", (Object)key);
            JSONArray elements = new JSONArray();
            for (int v : value) {
                elements.put(v);
            }
            clause.mJson.put("values", (Object)elements);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause inWithLongValue(@NonNull String key, long ... value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        if (value.length < 1 || value.length > 200) {
            throw new IllegalArgumentException("value is empty or exceeds maximum length(200)");
        }
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"in");
            clause.mJson.put("field", (Object)key);
            JSONArray elements = new JSONArray();
            for (long v : value) {
                elements.put(v);
            }
            clause.mJson.put("values", (Object)elements);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause inWithDoubleValue(@NonNull String key, double ... value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        if (value.length < 1 || value.length > 200) {
            throw new IllegalArgumentException("value is empty or exceeds maximum length(200)");
        }
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"in");
            clause.mJson.put("field", (Object)key);
            JSONArray elements = new JSONArray();
            for (double v : value) {
                elements.put(v);
            }
            clause.mJson.put("values", (Object)elements);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause inWithStringValue(@NonNull String key, String ... value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        if (value.length < 1 || value.length > 200) {
            throw new IllegalArgumentException("value is empty or exceeds maximum length(200)");
        }
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"in");
            clause.mJson.put("field", (Object)key);
            JSONArray elements = new JSONArray();
            for (String v : value) {
                elements.put((Object)v);
            }
            clause.mJson.put("values", (Object)elements);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThan(@NonNull String key, @NonNull Object value) {
        KiiClause.checkInstance2(value);
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThan(@NonNull String key, int value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThan(@NonNull String key, long value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThan(@NonNull String key, double value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThan(@NonNull String key, @NonNull String value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", (Object)value);
            clause.mJson.put("lowerIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThanOrEqual(@NonNull String key, @NonNull Object value) {
        KiiClause.checkInstance2(value);
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThanOrEqual(@NonNull String key, int value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThanOrEqual(@NonNull String key, long value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThanOrEqual(@NonNull String key, double value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", value);
            clause.mJson.put("lowerIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause greaterThanOrEqual(@NonNull String key, @NonNull String value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("lowerLimit", (Object)value);
            clause.mJson.put("lowerIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThan(@NonNull String key, @NonNull Object value) {
        KiiClause.checkInstance2(value);
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThan(@NonNull String key, int value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThan(@NonNull String key, long value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThan(@NonNull String key, double value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThan(@NonNull String key, @NonNull String value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", (Object)value);
            clause.mJson.put("upperIncluded", false);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThanOrEqual(@NonNull String key, @NonNull Object value) {
        KiiClause.checkInstance2(value);
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThanOrEqual(@NonNull String key, int value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThanOrEqual(@NonNull String key, long value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThanOrEqual(@NonNull String key, double value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", value);
            clause.mJson.put("upperIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause lessThanOrEqual(@NonNull String key, @NonNull String value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"range");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("upperLimit", (Object)value);
            clause.mJson.put("upperIncluded", true);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause startsWith(@NonNull String key, @NonNull String value) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"prefix");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("prefix", (Object)value);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause geoBox(@NonNull String key, @NonNull GeoPoint northEast, @NonNull GeoPoint southWest) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("key is null or empty");
        }
        if (northEast == null || southWest == null) {
            throw new IllegalArgumentException("northEast or southWest point is null");
        }
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"geobox");
            clause.mJson.put("field", (Object)key);
            JSONObject box = new JSONObject();
            box.put("ne", (Object)northEast.toJSON());
            box.put("sw", (Object)southWest.toJSON());
            clause.mJson.put("box", (Object)box);
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause geoDistance(@NonNull String key, @NonNull GeoPoint center, double radius, @Nullable String calculatedDistance) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("key is null or empty");
        }
        if (center == null) {
            throw new IllegalArgumentException("center is null");
        }
        if (radius <= 0.0 || radius > 2.0E7 || Double.isNaN(radius)) {
            throw new IllegalArgumentException("Invalid radius, valid range is ]0-20000000]");
        }
        if (calculatedDistance != null && !Utils.validateCalculatedDistance(calculatedDistance)) {
            throw new IllegalArgumentException("Invalid calculatedDistance param, valid pattern is ^[a-zA-Z_][a-zA-Z0-9_]*$");
        }
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"geodistance");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("center", (Object)center.toJSON());
            clause.mJson.put("radius", radius);
            if (calculatedDistance != null) {
                clause.mJson.put("putDistanceInto", (Object)calculatedDistance);
            }
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    @NonNull
    public static KiiClause hasField(@NonNull String key, @NonNull FieldType fieldType) {
        KiiClause clause = new KiiClause();
        try {
            clause.mJson = new JSONObject();
            clause.mJson.put("type", (Object)"hasField");
            clause.mJson.put("field", (Object)key);
            clause.mJson.put("fieldType", (Object)fieldType.name());
            return clause;
        }
        catch (JSONException ex) {
            throw new RuntimeException("Invalid param given!", ex);
        }
    }

    private static void checkInstance1(Object object) {
        if (!(object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof String)) {
            throw new IllegalArgumentException("Unsupported type: " + object.getClass().getCanonicalName());
        }
    }

    private static void checkInstance2(Object object) {
        if (!(object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException("Unsupported type: " + object.getClass().getCanonicalName());
        }
    }

    public static enum FieldType {
        STRING,
        INTEGER,
        DECIMAL,
        BOOLEAN;

    }
}

