/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.photocolle;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.callback.KiiSocialCallBack;
import com.kii.cloud.storage.exception.social.SocialException;
import com.kii.cloud.storage.photocolle.KiiCloudPhotoColle;
import com.kii.cloud.storage.social.KiiBaseSocialConnect;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import com.kii.sdk.photocolle.AuthenticateCallback;
import com.kii.sdk.photocolle.AuthenticationContext;
import com.kii.sdk.photocolle.AuthenticationContextAccessException;
import com.kii.sdk.photocolle.Authority;
import com.kii.sdk.photocolle.Scope;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import org.json.JSONObject;

public class PhotoColleSocialConnect
extends KiiBaseSocialConnect
implements KiiSocialConnect {
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private EnumSet<Scope> predefinedScopes;
    private String[] extendedScopes;
    private KiiCloudPhotoColle photoColle;

    private PhotoColleSocialConnect() {
        this.clientId = null;
        this.clientSecret = null;
        this.redirectUri = null;
        this.predefinedScopes = null;
        this.extendedScopes = null;
        this.photoColle = null;
    }

    static PhotoColleSocialConnect newInstance() {
        return new PhotoColleSocialConnect();
    }

    static PhotoColleSocialConnect newInstance(Bundle b) {
        return new PhotoColleSocialConnect(b);
    }

    @Nullable
    public KiiCloudPhotoColle getKiiCloudPhotocolle(@NonNull Context context) {
        if (this.photoColle == null) {
            AuthenticationContext authContext;
            if (KiiUser.getCurrentUser() == null) {
                return null;
            }
            String userID = KiiUser.getCurrentUser().toUri().getLastPathSegment();
            try {
                authContext = AuthenticationContext.loadFrom((Context)context, (String)userID, (String)this.clientId, (String)this.clientSecret);
            }
            catch (Exception e) {
                return null;
            }
            this.photoColle = new KiiCloudPhotoColle(context, authContext);
        }
        return this.photoColle;
    }

    public void initialize(@NonNull String clientId, @NonNull String clientSecret, @NonNull String redirectUri, @Nullable EnumSet<Scope> predefinedScopes, @Nullable String[] extendedScopes) {
        this.initializeInner(clientId, clientSecret, redirectUri, predefinedScopes, extendedScopes);
    }

    @Override
    public void initialize(@NonNull String clientId, @NonNull String clientSecret, @NonNull Bundle options) {
        if (options == null) {
            throw new IllegalArgumentException("options must not be null");
        }
        this.initializeInner(clientId, clientSecret, options.getString("redirectUri"), this.getPredefinedScopes(options), this.getExtendedScopes(options));
    }

    @Override
    public boolean isLinked() {
        return this.photoColle != null;
    }

    @Override
    public void link(@NonNull Activity activity, @Nullable Bundle options, final @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        if (!this.isInitialized()) {
            throw new IllegalStateException("PhotoColleSocialConnect is not initialized");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        final Context context = activity.getApplicationContext();
        Authority.authenticate((Context)context, (String)this.clientId, (String)this.clientSecret, (String)this.redirectUri, this.predefinedScopes, (String[])this.extendedScopes, null, (AuthenticateCallback)new AuthenticateCallback(){

            public void onAuthenticated(final AuthenticationContext authContext, Exception exception) {
                if (exception != null) {
                    callback.onLinkCompleted(KiiSocialConnect.SocialNetwork.PHOTOCOLLE, KiiUser.getCurrentUser(), exception);
                    return;
                }
                try {
                    JSONObject requestJson = new JSONObject();
                    requestJson.put("accessToken", (Object)authContext.getAccessToken());
                    PhotoColleSocialConnect.this.link(requestJson, new KiiSocialCallBack(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onLinkCompleted(KiiSocialConnect.SocialNetwork network, KiiUser user, Exception exception) {
                            try {
                                if (exception == null) {
                                    PhotoColleSocialConnect.this.photoColle = new KiiCloudPhotoColle(context, authContext);
                                    authContext.saveTo(context, KiiUser.getCurrentUser().toUri().getLastPathSegment());
                                }
                            }
                            catch (AuthenticationContextAccessException e) {
                                Log.v("PhotoColleSocialConnect", "error", e);
                            }
                            finally {
                                callback.onLinkCompleted(network, user, exception);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    callback.onLinkCompleted(KiiSocialConnect.SocialNetwork.PHOTOCOLLE, KiiUser.getCurrentUser(), e);
                }
            }
        });
    }

    @Override
    public void unlink(final @NonNull Activity activity, @Nullable Bundle options, final @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(true);
        if (!this.isInitialized()) {
            throw new IllegalStateException("PhotoColleSocialConnect is not initialized");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.unlink(activity, new KiiSocialCallBack(){

            @Override
            public void onUnLinkCompleted(KiiSocialConnect.SocialNetwork network, KiiUser user, Exception exception) {
                callback.onUnLinkCompleted(network, user, exception);
                if (exception == null) {
                    try {
                        AuthenticationContext.removeFrom((Context)activity, (String)user.toUri().getLastPathSegment());
                    }
                    catch (AuthenticationContextAccessException e) {
                        Log.d("PhotoColleSocialConnect", "error", e);
                    }
                }
            }
        });
    }

    @Override
    public void respondAuthOnActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    }

    @Override
    public void logIn(@NonNull Activity activity, @Nullable Bundle options, final @NonNull KiiSocialCallBack callback) {
        Utils.checkInitialize(false);
        if (!this.isInitialized()) {
            throw new IllegalStateException("PhotoColleSocialConnect is not initialized");
        }
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        final Context context = activity.getApplicationContext();
        Authority.authenticate((Context)context, (String)this.clientId, (String)this.clientSecret, (String)this.redirectUri, this.predefinedScopes, (String[])this.extendedScopes, null, (AuthenticateCallback)new AuthenticateCallback(){

            public void onAuthenticated(final AuthenticationContext authContext, Exception exception) {
                if (exception != null) {
                    callback.onLoginCompleted(KiiSocialConnect.SocialNetwork.PHOTOCOLLE, null, exception);
                    return;
                }
                try {
                    JSONObject requestJson = new JSONObject();
                    requestJson.put("accessToken", (Object)authContext.getAccessToken());
                    PhotoColleSocialConnect.this.login(requestJson, new KiiSocialCallBack(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onLoginCompleted(KiiSocialConnect.SocialNetwork network, KiiUser user, Exception exception) {
                            try {
                                if (exception == null) {
                                    PhotoColleSocialConnect.this.photoColle = new KiiCloudPhotoColle(context, authContext);
                                    authContext.saveTo(context, KiiUser.getCurrentUser().toUri().getLastPathSegment());
                                }
                            }
                            catch (AuthenticationContextAccessException e) {
                                Log.v("PhotoColleSocialConnect", "error", e);
                            }
                            finally {
                                callback.onLoginCompleted(network, user, exception);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    callback.onLoginCompleted(KiiSocialConnect.SocialNetwork.PHOTOCOLLE, null, e);
                }
            }
        });
    }

    @Override
    @Nullable
    public String getAccessToken() {
        throw new UnsupportedOperationException("getAccessToken is not supported.");
    }

    @Override
    public long getAccessExpires() {
        throw new UnsupportedOperationException("getAccessExpires is not supported.");
    }

    @Override
    @Nullable
    public Bundle getAccessTokenBundle() {
        throw new UnsupportedOperationException("getAccessTokenBundle is not supported.");
    }

    private void initializeInner(String clientId, String clientSecret, String redirectUri, EnumSet<Scope> predefinedScopes, String[] extendedScopes) {
        if (TextUtils.isEmpty((CharSequence)clientId)) {
            throw new IllegalArgumentException("clientId must not be null and empty");
        }
        if (TextUtils.isEmpty((CharSequence)clientSecret)) {
            throw new IllegalArgumentException("clientSecret must not be null and empty");
        }
        if (TextUtils.isEmpty((CharSequence)redirectUri)) {
            throw new IllegalArgumentException("redirectUri must not be null and empty");
        }
        if (this.isEmptyCollection(predefinedScopes) && this.isEmptyArray(extendedScopes)) {
            throw new IllegalArgumentException("At least, predefinedScopes or extendedScopes must not be null");
        }
        if (this.containsNullOrEmpty(extendedScopes)) {
            throw new IllegalArgumentException("extendedScopes must not contain null or empty");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.predefinedScopes = predefinedScopes;
        this.extendedScopes = extendedScopes;
    }

    private boolean isInitialized() {
        return this.clientId != null && this.clientSecret != null && this.redirectUri != null && (this.predefinedScopes != null || this.extendedScopes != null);
    }

    private EnumSet<Scope> getPredefinedScopes(Bundle options) {
        Serializable serializable = options.getSerializable("predefinedScopes");
        if (serializable == null) {
            return null;
        }
        if (!(serializable instanceof EnumSet)) {
            throw new IllegalArgumentException("predefinedScopes must be EnumSet<Scope>");
        }
        for (Object element : (EnumSet)serializable) {
            if (element instanceof Scope) continue;
            throw new IllegalArgumentException("predefinedScopes must be EnumSet<Scope>");
        }
        EnumSet retval = (EnumSet)serializable;
        return retval;
    }

    private String[] getExtendedScopes(Bundle options) {
        return options.getStringArray("extendedScopes");
    }

    private boolean isEmptyCollection(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private boolean isEmptyArray(String[] array) {
        return array == null || array.length == 0;
    }

    private boolean containsNullOrEmpty(String[] array) {
        if (array != null) {
            for (String element : array) {
                if (!TextUtils.isEmpty((CharSequence)element)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getSocialNetworkName() {
        return "docomo";
    }

    @Override
    protected String getLoginContentType() {
        return "application/vnd.kii.AuthTokenDocomoRequest+json";
    }

    @Override
    protected String getLinkContentType() {
        return "application/vnd.kii.LinkDocomoRequest+json";
    }

    @Override
    protected KiiSocialConnect.SocialNetwork getNetwork() {
        return KiiSocialConnect.SocialNetwork.PHOTOCOLLE;
    }

    @Override
    protected void onLoginCompleted(JSONObject requestJson, Bundle tokenBundle) {
    }

    @Override
    protected void onLinkCompleted(JSONObject requestJson) {
    }

    @Override
    protected void onPreUnlink(Activity activity) throws IOException, SocialException {
    }

    @Override
    protected void onUnlinkCompleted() {
        this.clearPhotoColleInstance();
    }

    void clearPhotoColleInstance() {
        this.photoColle = null;
    }

    Bundle getParcelableBundle() {
        Bundle b = new Bundle();
        b.putString("clientId", this.clientId);
        b.putString("clientSecret", this.clientSecret);
        b.putString("redirectUri", this.redirectUri);
        b.putSerializable("predefinedScopes", this.predefinedScopes);
        b.putSerializable("extendedScopes", (Serializable)this.extendedScopes);
        return b;
    }

    void setParcelableBundle(Bundle b) {
        String clientId = b.getString("clientId");
        String clientSecret = b.getString("clientSecret");
        String redirectUri = b.getString("redirectUri");
        EnumSet predefinedScopes = (EnumSet)b.getSerializable("predefinedScopes");
        String[] extendedScopes = b.getStringArray("extendedScopes");
        if (clientId == null || clientSecret == null || redirectUri == null || predefinedScopes == null && extendedScopes == null) {
            return;
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.predefinedScopes = predefinedScopes;
        this.extendedScopes = extendedScopes;
    }

    private PhotoColleSocialConnect(Bundle b) {
        String clientId = b.getString("clientId");
        String clientSecret = b.getString("clientSecret");
        String redirectUri = b.getString("redirectUri");
        EnumSet predefinedScopes = (EnumSet)b.getSerializable("predefinedScopes");
        String[] extendedScopes = b.getStringArray("extendedScopes");
        if (clientId == null || clientSecret == null || redirectUri == null || predefinedScopes == null && extendedScopes == null) {
            return;
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.predefinedScopes = predefinedScopes;
        this.extendedScopes = extendedScopes;
    }
}

