/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.exception;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudExecutionException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_BAD_STATUS_CODE = "bad_http_status_code";
    private String mError = null;
    private String mException = null;
    private String mErrorDescription = null;
    private int mStatus = -1;
    private String mBody = null;

    protected CloudExecutionException() {
    }

    protected CloudExecutionException(String message, Throwable cause) {
        super(message, cause);
    }

    protected CloudExecutionException(String message, Throwable cause, int httpStatus, String httpBody) {
        super(message, cause);
        this.mStatus = httpStatus;
        this.mBody = httpBody;
    }

    public CloudExecutionException(int status, @Nullable String body, @Nullable String error, @Nullable String exception, @Nullable String description) {
        this.mError = error;
        this.mException = exception;
        this.mErrorDescription = description;
        this.mStatus = status;
        this.mBody = body;
    }

    public CloudExecutionException(int status, @Nullable String body) {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: " + this.mStatus);
        sb.append("\n");
        sb.append("Body: ");
        sb.append(body);
        this.mStatus = status;
        this.mBody = body;
        this.mError = "bad_http_status_code(" + status + ")";
        this.mErrorDescription = sb.toString();
    }

    @Nullable
    public String getError() {
        return this.mError;
    }

    @Nullable
    public String getErrorDetails() {
        return this.mErrorDescription;
    }

    @Nullable
    public String getException() {
        return this.mException;
    }

    public int getStatus() {
        return this.mStatus;
    }

    @Nullable
    public String getBody() {
        return this.mBody;
    }

    @Nullable
    public String getErrorCode() {
        if (Utils.isEmpty(this.mBody)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(this.mBody);
            return json.getString("errorCode");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Override
    @NonNull
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("Error: ");
        sb.append(this.mError);
        if (!TextUtils.isEmpty((CharSequence)this.mErrorDescription)) {
            sb.append("\n");
            sb.append("Error Description: ");
            sb.append(this.mErrorDescription);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mException)) {
            sb.append("\n");
            sb.append("Exception: ");
            sb.append(this.mException);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBody)) {
            sb.append("\n");
            sb.append("HTTP Response Status: ");
            sb.append(this.mStatus);
            sb.append("\n");
            sb.append("HTTP Response Body: ");
            sb.append(this.mBody);
        }
        return sb.toString();
    }
}

