/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.engine;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage._KiiCloudHttpEngineProxy;
import com.kii.cloud.storage._KiiUserInternalBridge;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudHttpEngine;
import com.kii.cloud.storage.engine._HttpClientFactory;
import com.kii.cloud.storage.engine._HttpClientFactoryOptions;
import com.kii.cloud.storage.engine._HttpProgressCallback;
import com.kii.cloud.storage.exception.RedirectionException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.exception.system.SystemException;
import com.kii.cloud.storage.resumabletransfer.impl.DownloaderCommonLogic;
import com.kii.cloud.storage.resumabletransfer.impl.FileModifiedException;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiCloudEngine
implements KiiCloudHttpEngine {
    private static final String TAG = "KiiCloudEngine";
    private static final String FLD_ERROR_CODE = "errorCode";
    public static final String TOKEN_OWNER_HEADER = "X-Kii-TokenOwnerUserID";
    private static _HttpClientFactory clientFactory = new _HttpClientFactory();
    private static Object lock = new Object();
    private static final KiiCloudHttpEngine INSTANCE = _KiiCloudHttpEngineProxy.createProxy(new KiiCloudEngine());

    public static synchronized void updateAccessToken(@NonNull String accessToken) {
        _KiiUserInternalBridge.updateKiiUserAccessToken(accessToken);
    }

    public static KiiCloudHttpEngine getInstance() {
        return INSTANCE;
    }

    private KiiCloudEngine() {
    }

    public static void setAuthBearer(@NonNull HttpUriRequest request) {
        KiiCloudEngine.setAuthBearer(request, KiiCloudEngine.getAccessToken());
    }

    public static void setAuthBearer(@NonNull HttpUriRequest request, @Nullable String accessToken) {
        String userId = KiiCloudEngine.getUserID();
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            request.setHeader("Authorization", "Bearer " + accessToken);
        }
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            request.setHeader(TOKEN_OWNER_HEADER, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ApiResponse downloadFileRequest(@NonNull HttpUriRequest request, @NonNull File targetFile, @Nullable _HttpProgressCallback callback) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Header[] contentLengths;
        KiiCloudEngine.logRequest(request);
        ApiResponse res = new ApiResponse();
        _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(true);
        HttpClient client = clientFactory.createClient(options);
        HttpResponse response = client.execute(request);
        int status = response.getStatusLine().getStatusCode();
        if (status >= 300) {
            return KiiCloudEngine.httpResponseParser(response);
        }
        res.status = status;
        res.headers = response.getAllHeaders();
        Header[] headers = response.getHeaders("ETag");
        if (headers != null && headers.length > 0) {
            res.eTag = headers[0].getValue();
            Log.v(TAG, "Etag: " + res.eTag);
        }
        if ((contentLengths = response.getHeaders("Content-Length")) != null && contentLengths.length > 0) {
            res.contentLength = contentLengths[0].getValue();
            Log.v(TAG, "Content-Length: " + res.contentLength);
        } else {
            res.contentLength = Long.toString(response.getEntity().getContentLength());
        }
        Header[] contentTypes = response.getHeaders("Content-Type");
        if (contentTypes != null && contentTypes.length > 0) {
            res.contentType = contentTypes[0].getValue();
            Log.v(TAG, "Content-Type: " + res.contentType);
        }
        long total_length = Long.valueOf(res.contentLength);
        Log.i(TAG, "content length:" + total_length);
        Log.i(TAG, "saving file to:" + targetFile.getAbsolutePath());
        HttpEntity entity = response.getEntity();
        BufferedInputStream instream = null;
        FilterOutputStream out = null;
        try {
            if (entity != null) {
                int l;
                instream = new BufferedInputStream(entity.getContent());
                out = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] tmp = new byte[2048];
                int current_length = 0;
                while ((l = instream.read(tmp)) != -1) {
                    ((BufferedOutputStream)out).write(tmp, 0, l);
                    current_length += l;
                    if (callback == null) continue;
                    callback.onProgress(current_length, total_length);
                }
                if (total_length > 0L && total_length != (long)current_length) {
                    throw new IOException("Can't get whole content");
                }
            }
        }
        finally {
            if (instream != null) {
                instream.close();
            }
            if (out != null) {
                out.close();
            }
            if (entity != null) {
                entity.consumeContent();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ApiResponse downloadFileByChunkRequest(@NonNull String targetPath, @NonNull HttpUriRequest request, long completedInBytes, @NonNull DownloaderCommonLogic logic) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, FileModifiedException {
        ApiResponse res;
        block15: {
            KiiCloudEngine.logRequest(request);
            res = new ApiResponse();
            _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(true);
            HttpClient client = clientFactory.createClient(options);
            HttpResponse response = client.execute(request);
            int status = response.getStatusLine().getStatusCode();
            if (status < 300) {
                res.status = status;
                Header[] headers = response.getHeaders("ETag");
                if (headers != null && headers.length > 0) {
                    res.eTag = headers[0].getValue();
                }
            } else {
                return KiiCloudEngine.httpResponseParser(response);
            }
            Log.i(TAG, "saving file to:" + targetPath);
            HttpEntity entity = response.getEntity();
            BufferedInputStream instream = null;
            RandomAccessFile raf = null;
            try {
                boolean suc;
                if (entity == null) break block15;
                instream = new BufferedInputStream(entity.getContent());
                File f = new File(targetPath);
                if (completedInBytes == 0L && f.exists() && !(suc = f.delete())) {
                    throw new IOException("failed to access file");
                }
                raf = new RandomAccessFile(targetPath, "rw");
                byte[] buffer = new byte[1024];
                raf.seek(completedInBytes);
                long lastLen = completedInBytes;
                Object object = lock;
                synchronized (object) {
                    int l;
                    while ((l = instream.read(buffer)) != -1 && !logic.cancelled()) {
                        Log.v(TAG, "tid:" + Thread.currentThread().getId());
                        Log.v(TAG, "lastLen: " + lastLen);
                        Log.v(TAG, "filelen: " + f.length());
                        if (lastLen != f.length()) {
                            throw new FileModifiedException("dest file has modified");
                        }
                        raf.write(buffer, 0, l);
                        lastLen = f.length();
                    }
                }
            }
            finally {
                if (instream != null) {
                    instream.close();
                }
                if (raf != null) {
                    raf.close();
                }
                if (entity != null) {
                    entity.consumeContent();
                }
            }
        }
        return res;
    }

    private _HttpClientFactoryOptions optionsFromRequest(@NonNull HttpUriRequest request) {
        boolean retry = true;
        String method = request.getMethod();
        if (method.toUpperCase().equals("POST")) {
            String xMethod;
            Header h = request.getFirstHeader("X-HTTP-Method-Override");
            if (h != null && (xMethod = h.getValue()).toUpperCase().equals("PATCH")) {
                return new _HttpClientFactoryOptions(true);
            }
            retry = false;
        }
        _HttpClientFactoryOptions options = new _HttpClientFactoryOptions(retry);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ApiResponse httpRequest(@NonNull HttpUriRequest request) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        KiiCloudEngine.logRequest(request);
        ApiResponse res = new ApiResponse();
        _HttpClientFactoryOptions options = this.optionsFromRequest(request);
        HttpClient client = clientFactory.createClient(options);
        HttpResponse response = null;
        HttpEntity entity = null;
        try {
            response = client.execute(request);
            if (response == null) {
                throw new IOException("failed to get response.");
            }
            entity = response.getEntity();
            res = KiiCloudEngine.httpResponseParser(response);
        }
        finally {
            if (entity != null) {
                entity.consumeContent();
            }
        }
        return res;
    }

    private static ApiResponse httpResponseParser(HttpResponse response) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        ApiResponse res = new ApiResponse();
        StatusLine sl = response.getStatusLine();
        if (sl == null) {
            throw new IOException("Can't get staus code");
        }
        int status = sl.getStatusCode();
        Log.i(TAG, "Http status code:" + status);
        String body = KiiCloudEngine.getBody(response);
        Log.v(TAG, "Client.apiRequest(): Response: " + body);
        if (status < 300) {
            Header[] contentLengths;
            res.body = body;
            res.status = status;
            res.headers = response.getAllHeaders();
            Header[] headers = response.getHeaders("ETag");
            if (headers != null && headers.length > 0) {
                res.eTag = headers[0].getValue();
                Log.v(TAG, "Etag: " + res.eTag);
            }
            if ((contentLengths = response.getHeaders("Content-Length")) != null && contentLengths.length > 0) {
                res.contentLength = contentLengths[0].getValue();
                Log.v(TAG, "Content-Length: " + res.contentLength);
            }
            return res;
        }
        if (300 <= status && status < 400) {
            throw new RedirectionException("Redirected by network.");
        }
        Header[] headers = response.getHeaders("Content-Type");
        if (KiiCloudEngine.parsable(headers) && body != null) {
            KiiCloudEngine.httpExceptionParser(status, body);
        } else {
            KiiCloudEngine.throwExceptionByStatus(status);
        }
        return res;
    }

    private static String getBody(HttpResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        if (response.getStatusLine().getStatusCode() == 204 || response.getEntity() == null) {
            return null;
        }
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        if (Utils.isEmpty(body)) {
            return null;
        }
        return body;
    }

    private static boolean parsable(Header[] headers) {
        if (headers == null || headers.length < 1) {
            return false;
        }
        String contentType = headers[0].getValue().toLowerCase(Locale.ENGLISH);
        return contentType.startsWith("application/json") || contentType.startsWith("application/vnd.") && contentType.contains("xception+json");
    }

    private static void httpExceptionParser(int status, String body) throws BadRequestException, IOException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        try {
            JSONObject obj = new JSONObject(body);
            String strErrorCode = obj.optString(FLD_ERROR_CODE);
            Log.v("Exception", "Error Code : " + strErrorCode);
            try {
                SystemException.Reason systemReason = SystemException.Reason.valueOf(strErrorCode);
                throw new SystemException(systemReason.toString(), null, systemReason);
            }
            catch (Exception e) {
                switch (status) {
                    case 400: {
                        BadRequestException.Reason reason;
                        try {
                            reason = BadRequestException.Reason.valueOf(strErrorCode);
                        }
                        catch (Exception e2) {
                            reason = BadRequestException.Reason.__UNKNOWN__;
                        }
                        throw new BadRequestException(reason.toString(), null, reason, body);
                    }
                    case 401: {
                        throw new UnauthorizedException("Unauthorized access", null, body);
                    }
                    case 403: {
                        throw new ForbiddenException("Forbidden access", null, body);
                    }
                    case 404: {
                        NotFoundException.Reason notFoundReason;
                        try {
                            notFoundReason = NotFoundException.Reason.valueOf(strErrorCode);
                        }
                        catch (Exception e3) {
                            notFoundReason = NotFoundException.Reason.__UNKNOWN__;
                        }
                        throw new NotFoundException(notFoundReason.toString(), null, notFoundReason, body);
                    }
                    case 409: {
                        ConflictException.Reason confReason;
                        try {
                            confReason = ConflictException.Reason.valueOf(strErrorCode);
                        }
                        catch (Exception e4) {
                            confReason = ConflictException.Reason.__UNKNOWN__;
                        }
                        throw new ConflictException(confReason.toString(), null, confReason, body);
                    }
                }
                throw new UndefinedException(status, body);
            }
        }
        catch (JSONException e) {
            throw new UndefinedException(status, body);
        }
    }

    private static void throwExceptionByStatus(int status) throws BadRequestException, IOException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        switch (status) {
            case 400: {
                BadRequestException.Reason reason = BadRequestException.Reason.__UNKNOWN__;
                throw new BadRequestException(reason.toString(), null, reason, null);
            }
            case 401: {
                throw new UnauthorizedException("Unauthorized access", null, null);
            }
            case 403: {
                throw new ForbiddenException("Forbidden access", null, null);
            }
            case 404: {
                NotFoundException.Reason notFoundReason = NotFoundException.Reason.__UNKNOWN__;
                throw new NotFoundException(notFoundReason.toString(), null, notFoundReason, null);
            }
            case 409: {
                ConflictException.Reason confReason = ConflictException.Reason.__UNKNOWN__;
                throw new ConflictException(confReason.toString(), null, confReason, null);
            }
        }
        throw new UndefinedException(status, null);
    }

    private static final void logRequest(HttpUriRequest request) {
        Log.v(TAG, request.getMethod() + " " + request.getURI());
        for (Header h : request.getAllHeaders()) {
            Log.v(TAG, h.getName() + ": " + h.getValue());
        }
    }

    @Nullable
    public static synchronized String getAccessToken() {
        if (KiiUser.getCurrentUser() == null) {
            return null;
        }
        return KiiUser.getCurrentUser().getAccessToken();
    }

    @Nullable
    public static synchronized String getUserID() {
        if (KiiUser.getCurrentUser() == null) {
            return null;
        }
        return KiiUser.getCurrentUser().getID();
    }
}

