/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.engine;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.engine._HttpProgressCallback;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.entity.FileEntity;

public class CountingFileEntity
extends FileEntity {
    private long file_size;
    private _HttpProgressCallback callback;

    public CountingFileEntity(@NonNull File file, @NonNull String contentType, @Nullable _HttpProgressCallback callback) {
        super(file, contentType);
        this.file_size = file.length();
        this.callback = callback;
    }

    public void writeTo(@NonNull OutputStream outstream) throws IOException {
        super.writeTo((OutputStream)new CountingOutputStream(outstream, this.file_size, this.callback));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final _HttpProgressCallback callback;
        private long transferred;
        private long totalsize;

        public CountingOutputStream(@NonNull OutputStream out, long totalsize, @Nullable _HttpProgressCallback callback) {
            super(out);
            this.callback = callback;
            this.transferred = 0L;
            this.totalsize = totalsize;
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.transferred += (long)len;
            if (this.callback == null) {
                return;
            }
            this.callback.onProgress(this.transferred, this.totalsize);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.transferred;
            if (this.callback == null) {
                return;
            }
            this.callback.onProgress(this.transferred, this.totalsize);
        }
    }
}

