/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.KiiPushMessageSender;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.PushMessageBundleHelper;
import com.kii.cloud.storage.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public abstract class ReceivedMessage {
    private String sender;
    private Scope scope;
    private Bundle message;

    ReceivedMessage(Bundle message, String sender, String scope) {
        this.message = message;
        this.sender = sender;
        this.setScope(scope);
    }

    ReceivedMessage(Bundle message, String sender) {
        this.message = message;
        this.sender = sender;
    }

    @Nullable
    public KiiUser getSender() {
        if (this.sender == null) {
            return null;
        }
        if (Utils.isThingID(this.sender)) {
            return null;
        }
        return KiiUser.createByUri(Uri.parse((String)Utils.path("kiicloud://", "users", this.sender)));
    }

    @Nullable
    public KiiPushMessageSender getPushMessageSender() {
        if (this.sender == null) {
            return null;
        }
        if (Utils.isThingID(this.sender)) {
            return KiiThing.createByUri(Uri.parse((String)Utils.path("kiicloud://", "things", this.sender)));
        }
        return KiiUser.createByUri(Uri.parse((String)Utils.path("kiicloud://", "users", this.sender)));
    }

    @NonNull
    public abstract PushMessageBundleHelper.MessageType pushMessageType();

    private void setScope(String scope) {
        try {
            this.scope = Scope.valueOf(scope);
        }
        catch (Exception e) {
            this.scope = null;
        }
    }

    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @NonNull
    public Bundle getMessage() {
        return this.message;
    }

    @NonNull
    public Map<String, String> getMessageAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.message.keySet()) {
            Object value = this.message.get(key);
            if (value == null) {
                map.put(key, null);
                continue;
            }
            map.put(key, value.toString());
        }
        return map;
    }

    public static enum Scope {
        APP,
        APP_AND_GROUP,
        APP_AND_USER,
        APP_AND_THING;

    }
}

