/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.PushMessageBundleHelper;
import com.kii.cloud.storage.ReceivedMessage;
import com.kii.cloud.storage.utils.Utils;

public class PushToAppMessage
extends ReceivedMessage {
    private BucketType bucketType;
    private String bucketName;
    private String objectId;
    private String objectScopeGroupId;
    private String objectScopeUserId;
    private String objectScopeThingId;

    PushToAppMessage(Bundle bundle) {
        super(bundle, bundle.getString("sender"), bundle.getString("objectScopeType"));
        this.bucketType = this.getBucketType(bundle.getString("bucketType"));
        this.objectScopeGroupId = bundle.getString("objectScopeGroupID");
        this.objectScopeUserId = bundle.getString("objectScopeUserID");
        this.objectScopeThingId = bundle.getString("objectScopeThingID");
        this.bucketName = bundle.getString("bucketID");
        this.objectId = bundle.getString("objectID");
    }

    @Nullable
    public KiiGroup getEventSourceGroup() {
        if (this.objectScopeGroupId == null) {
            return null;
        }
        return KiiGroup.groupWithID(this.objectScopeGroupId);
    }

    @Nullable
    public KiiUser getEventSourceUser() {
        if (this.objectScopeUserId == null) {
            return null;
        }
        return KiiUser.userWithID(this.objectScopeUserId);
    }

    @Nullable
    public KiiThing getEventSourceThing() {
        if (this.objectScopeThingId == null) {
            return null;
        }
        return KiiThing.thingWithID(this.objectScopeThingId);
    }

    @Nullable
    public KiiBucket getKiiBucket() {
        if (!this.containsKiiBucket()) {
            return null;
        }
        ReceivedMessage.Scope scope = this.getScope();
        if (ReceivedMessage.Scope.APP.equals((Object)scope)) {
            if (this.bucketType == BucketType.READ_WRITE) {
                return Kii.bucket(this.bucketName);
            }
            if (this.bucketType == BucketType.CRYPTO) {
                return Kii.encryptedBucket(this.bucketName);
            }
            throw new RuntimeException("Unexpected error!");
        }
        if (ReceivedMessage.Scope.APP_AND_GROUP.equals((Object)scope)) {
            KiiGroup group = this.getEventSourceGroup();
            if (this.bucketType == BucketType.READ_WRITE) {
                return group.bucket(this.bucketName);
            }
            if (this.bucketType == BucketType.CRYPTO) {
                return group.encryptedBucket(this.bucketName);
            }
            throw new RuntimeException("Unexpected error!");
        }
        if (ReceivedMessage.Scope.APP_AND_USER.equals((Object)scope)) {
            KiiUser user = this.getEventSourceUser();
            if (this.bucketType == BucketType.READ_WRITE) {
                return user.bucket(this.bucketName);
            }
            if (this.bucketType == BucketType.CRYPTO) {
                return user.encryptedBucket(this.bucketName);
            }
            throw new RuntimeException("Unexpected error!");
        }
        if (ReceivedMessage.Scope.APP_AND_THING.equals((Object)scope)) {
            KiiThing thing = this.getEventSourceThing();
            if (this.bucketType == BucketType.READ_WRITE) {
                return thing.bucket(this.bucketName);
            }
            if (this.bucketType == BucketType.CRYPTO) {
                return thing.encryptedBucket(this.bucketName);
            }
            throw new RuntimeException("Unexpected error!");
        }
        throw new RuntimeException("Unexpected error!");
    }

    @Nullable
    public KiiObject getKiiObject() {
        if (!this.containsKiiObject()) {
            return null;
        }
        if (this.objectId == null) {
            return null;
        }
        String scopePath = null;
        ReceivedMessage.Scope scope = this.getScope();
        String qualifiedBucketName = this.bucketName;
        if (this.bucketType == BucketType.CRYPTO) {
            qualifiedBucketName = "CRYPTO:" + this.bucketName;
        }
        if (ReceivedMessage.Scope.APP.equals((Object)scope)) {
            scopePath = Utils.path("kiicloud://", "buckets", qualifiedBucketName, "objects", this.objectId);
        } else if (ReceivedMessage.Scope.APP_AND_GROUP.equals((Object)scope)) {
            scopePath = Utils.path("kiicloud://", "groups", this.objectScopeGroupId, "buckets", qualifiedBucketName, "objects", this.objectId);
        } else if (ReceivedMessage.Scope.APP_AND_USER.equals((Object)scope)) {
            scopePath = Utils.path("kiicloud://", "users", this.objectScopeUserId, "buckets", qualifiedBucketName, "objects", this.objectId);
        } else if (ReceivedMessage.Scope.APP_AND_THING.equals((Object)scope)) {
            scopePath = Utils.path("kiicloud://", "things", this.objectScopeThingId, "buckets", qualifiedBucketName, "objects", this.objectId);
        } else {
            throw new RuntimeException("Unexpected error!");
        }
        return KiiObject.createByUri(Uri.parse((String)scopePath));
    }

    private BucketType getBucketType(String bucketType) {
        if (bucketType == null) {
            return null;
        }
        if ("rw".equals(bucketType)) {
            return BucketType.READ_WRITE;
        }
        if ("sync".equals(bucketType)) {
            return BucketType.SYNC;
        }
        if ("crypto".equals(bucketType)) {
            return BucketType.CRYPTO;
        }
        throw new RuntimeException("Unexpected Error!");
    }

    public boolean containsKiiObject() {
        ReceivedMessage.Scope scope;
        if (this.containsKiiBucket() && (ReceivedMessage.Scope.APP.equals((Object)(scope = this.getScope())) || ReceivedMessage.Scope.APP_AND_GROUP.equals((Object)scope) || ReceivedMessage.Scope.APP_AND_USER.equals((Object)scope) || ReceivedMessage.Scope.APP_AND_THING.equals((Object)scope))) {
            return this.objectId != null;
        }
        return false;
    }

    public boolean containsKiiBucket() {
        ReceivedMessage.Scope scope = this.getScope();
        if (scope == null) {
            return false;
        }
        if (scope == ReceivedMessage.Scope.APP_AND_GROUP && this.getEventSourceGroup() == null) {
            return false;
        }
        if (scope == ReceivedMessage.Scope.APP_AND_USER && this.getEventSourceUser() == null) {
            return false;
        }
        if (scope == ReceivedMessage.Scope.APP_AND_THING && this.getEventSourceThing() == null) {
            return false;
        }
        return (BucketType.READ_WRITE.equals((Object)this.bucketType) || BucketType.CRYPTO.equals((Object)this.bucketType)) && this.bucketName != null;
    }

    @Override
    @NonNull
    public PushMessageBundleHelper.MessageType pushMessageType() {
        return PushMessageBundleHelper.MessageType.PUSH_TO_APP;
    }

    static enum BucketType {
        READ_WRITE,
        SYNC,
        CRYPTO;

    }
}

