/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.async.executor.KiiUncancelabeTask;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiBaseObject;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiCallback;
import com.kii.cloud.storage.KiiEncryptedBucket;
import com.kii.cloud.storage.KiiListResult;
import com.kii.cloud.storage.KiiPushMessageSender;
import com.kii.cloud.storage.KiiPushSubscription;
import com.kii.cloud.storage.KiiScope;
import com.kii.cloud.storage.KiiSubject;
import com.kii.cloud.storage.KiiThingOwner;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.ThingFields;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiThing
extends KiiBaseObject
implements KiiScope,
Parcelable,
KiiSubject,
KiiPushMessageSender {
    private final String TAG = "KiiThing";
    static final String PROPERTY_THING_ID = "_thingID";
    static final String PROPERTY_VENDOR_THING_ID = "_vendorThingID";
    static final String PROPERTY_PASSWORD = "_password";
    static final String PROPERTY_THING_TYPE = "_thingType";
    static final String PROPERTY_VENDOR = "_vendor";
    static final String PROPERTY_FIRMWARE_VERSION = "_firmwareVersion";
    static final String PROPERTY_PRODUCT_NAME = "_productName";
    static final String PROPERTY_LOT = "_lot";
    static final String PROPERTY_CREATED = "_created";
    static final String PROPERTY_STRING_FIELD_1 = "_stringField1";
    static final String PROPERTY_STRING_FIELD_2 = "_stringField2";
    static final String PROPERTY_STRING_FIELD_3 = "_stringField3";
    static final String PROPERTY_STRING_FIELD_4 = "_stringField4";
    static final String PROPERTY_STRING_FIELD_5 = "_stringField5";
    static final String[] PROPERTY_STRING_FIELDS = new String[]{"_stringField1", "_stringField2", "_stringField3", "_stringField4", "_stringField5"};
    static final String PROPERTY_NUMBER_FIELD_1 = "_numberField1";
    static final String PROPERTY_NUMBER_FIELD_2 = "_numberField2";
    static final String PROPERTY_NUMBER_FIELD_3 = "_numberField3";
    static final String PROPERTY_NUMBER_FIELD_4 = "_numberField4";
    static final String PROPERTY_NUMBER_FIELD_5 = "_numberField5";
    static final String[] PROPERTY_NUMBER_FIELDS = new String[]{"_numberField1", "_numberField2", "_numberField3", "_numberField4", "_numberField5"};
    static final String PROPERTY_ACCESS_TOKEN = "_accessToken";
    static final String PROPERTY_DISABLED = "_disabled";
    static final String PROPERTY_ONLINE = "_online";
    static final String PROPERTY_ONLINE_STATUS_MODIFIED = "_onlineStatusModifiedAt";
    private static HashSet<String> reservedKeys = new HashSet();
    public static final Parcelable.Creator<KiiThing> CREATOR;

    private KiiThing(String thingID) {
        this.setReserveProperty(PROPERTY_THING_ID, thingID);
    }

    private KiiThing(JSONObject json) {
        super(json);
    }

    private KiiThing(String thingID, JSONObject json) {
        super(json);
        this.setReserveProperty(PROPERTY_THING_ID, thingID);
    }

    private KiiThing(Bundle b) throws JSONException {
        super(new JSONObject(b.getString("mJSON")), new JSONObject(b.getString("mJSONPatch")));
    }

    static KiiThing createByUri(Uri uri) {
        String id = KiiThing.parseIdFromUri(uri);
        return KiiThing.thingWithID(id);
    }

    @NonNull
    public static KiiThing thingWithID(@NonNull String thingID) {
        if (TextUtils.isEmpty((CharSequence)thingID)) {
            throw new IllegalArgumentException("Specified ID is empty or null");
        }
        KiiThing thing = new KiiThing(thingID);
        return thing;
    }

    @WorkerThread
    public static void registerOwnerWithThingID(@NonNull String thingID, @NonNull KiiThingOwner owner) throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        if (Utils.isEmpty(thingID)) {
            throw new IllegalArgumentException("thingID is null or empty");
        }
        KiiThing.registerOwnerWithIdentifier(thingID, owner);
    }

    @WorkerThread
    public static void registerOwnerWithVenderThingID(@NonNull String vendorThingID, @NonNull KiiThingOwner owner) throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        if (Utils.isEmpty(vendorThingID)) {
            throw new IllegalArgumentException("vendorThingID is null or empty");
        }
        KiiThing.registerOwnerWithIdentifier("VENDOR_THING_ID:" + vendorThingID, owner);
    }

    private static void registerOwnerWithIdentifier(String identifier, KiiThingOwner owner) throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        if (owner == null) {
            throw new IllegalArgumentException("owner is null");
        }
        if (owner.getThingOwnerID() == null) {
            throw new IllegalArgumentException("owner is not saved on the Kii Cloud.");
        }
        Utils.checkInitialize(true);
        HttpPut request = new HttpPut(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", identifier, "ownership", owner.getThingOwnerID()));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static void registerOwnerWithThingID(final @NonNull String thingID, final @NonNull KiiThingOwner owner, final @NonNull KiiCallback<KiiThingOwner> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.registerOwnerWithThingID(thingID, owner);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(owner, this.getException());
            }
        });
    }

    public static void registerOwnerWithVenderThingID(final @NonNull String vendorThingID, final @NonNull KiiThingOwner owner, final @NonNull KiiCallback<KiiThingOwner> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.registerOwnerWithVenderThingID(vendorThingID, owner);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(owner, this.getException());
            }
        });
    }

    private static String parseIdFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Input uri is null");
        }
        String scheme = uri.getScheme();
        List segments = uri.getPathSegments();
        if (!"kiicloud".equals(scheme)) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        String authority = uri.getAuthority();
        if (!"things".equals(authority)) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        if (segments.size() != 1) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        return (String)segments.get(0);
    }

    @Override
    boolean isValidKey(String key) {
        return KiiThing.isValidThingFieldKey(key);
    }

    static boolean isValidThingFieldKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        return reservedKeys == null || reservedKeys.size() <= 0 || !reservedKeys.contains(key);
    }

    public boolean disabled() {
        return this.mJSON.optBoolean(PROPERTY_DISABLED);
    }

    @WorkerThread
    @NonNull
    public static KiiThing register(@NonNull String vendorThingID, @NonNull String password, @Nullable String thingType, @Nullable ThingFields thingFields) throws IOException, BadRequestException, ConflictException, UndefinedException, UnauthorizedException, ForbiddenException, NotFoundException {
        Utils.checkInitialize(false);
        if (!KiiThing.isValidVendorThingID(vendorThingID)) {
            throw new IllegalArgumentException("Invalid vendorThingID format:" + vendorThingID);
        }
        if (!KiiThing.isValidThingPassword(password)) {
            throw new IllegalArgumentException("Invalid password format:" + password);
        }
        JSONObject requestBody = null;
        try {
            requestBody = thingFields == null ? new JSONObject() : new JSONObject(thingFields.toJsonString());
            if (!Utils.isEmpty(thingType)) {
                requestBody.put(PROPERTY_THING_TYPE, (Object)thingType);
            }
            requestBody.put(PROPERTY_VENDOR_THING_ID, (Object)vendorThingID);
            requestBody.put(PROPERTY_PASSWORD, (Object)password);
        }
        catch (JSONException e1) {
            throw new IllegalArgumentException("The thing data has problem");
        }
        HttpPost request = new HttpPost(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things"));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.ThingRegistrationAndAuthorizationRequest+json");
        request.setEntity((HttpEntity)new StringEntity(requestBody.toString(), "UTF-8"));
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject respObj = new JSONObject(response.body);
            KiiThing thing = new KiiThing(respObj.getString(PROPERTY_THING_ID), requestBody);
            thing.setCreated(respObj.getLong(PROPERTY_CREATED));
            if (respObj.has(PROPERTY_ACCESS_TOKEN)) {
                thing.setAccessToken(respObj.getString(PROPERTY_ACCESS_TOKEN));
            }
            return thing;
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @WorkerThread
    public void refresh() throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        Utils.checkInitialize(true);
        HttpGet request = new HttpGet(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", this.getID()));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            this.mJSON = new JSONObject(response.body);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    private void refreshMerge() throws IOException, ForbiddenException, BadRequestException, UndefinedException, ConflictException, NotFoundException, UnauthorizedException {
        try {
            JSONObject clone = new JSONObject(this.mJSON.toString());
            this.refresh();
            Iterator i = clone.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                this.mJSON.put(key, clone.get(key));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @WorkerThread
    public void update() throws IOException, BadRequestException, NotFoundException, UnauthorizedException, ForbiddenException, ConflictException, UndefinedException {
        Utils.checkInitialize(true);
        this.refreshMerge();
        HttpPost request = new HttpPost(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", this.getID()));
        request.setHeader("X-HTTP-Method-Override", "PATCH");
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.ThingUpdateRequest+json");
        request.setEntity((HttpEntity)new StringEntity(this.mJSON.toString(), "UTF-8"));
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    @WorkerThread
    public void delete() throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        Utils.checkInitialize(true);
        HttpDelete request = new HttpDelete(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", this.getID()));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        this.mJSON = new JSONObject();
    }

    @WorkerThread
    public boolean isOwner(@NonNull KiiThingOwner owner) throws IOException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        if (owner == null) {
            throw new IllegalArgumentException("owner is null");
        }
        if (owner.getThingOwnerID() == null) {
            throw new IllegalArgumentException("owner is not saved on the Kii Cloud.");
        }
        Utils.checkInitialize(true);
        HttpHead request = new HttpHead(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", this.getID(), "ownership", owner.getThingOwnerID()));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        try {
            ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            return response.status == 204;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public void registerOwner(@NonNull KiiThingOwner owner) throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        KiiThing.registerOwnerWithThingID(this.getID(), owner);
    }

    @WorkerThread
    public void unregisterOwner(@NonNull KiiThingOwner owner) throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        if (owner == null) {
            throw new IllegalArgumentException("owner is null");
        }
        if (owner.getThingOwnerID() == null) {
            throw new IllegalArgumentException("owner is not saved on the Kii Cloud.");
        }
        Utils.checkInitialize(true);
        HttpDelete request = new HttpDelete(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", this.getID(), "ownership", owner.getThingOwnerID()));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    @WorkerThread
    public void disable() throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        this.changeStatus(true);
    }

    @WorkerThread
    public void enable() throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        this.changeStatus(false);
    }

    private void changeStatus(boolean disabled) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("disabled", disabled);
        }
        catch (JSONException ignore) {
            throw new IllegalArgumentException("The thing data has problem");
        }
        HttpPut request = new HttpPut(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", this.getID(), "status"));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.ThingStatusUpdateRequest+json");
        request.setEntity((HttpEntity)new StringEntity(requestBody.toString(), "UTF-8"));
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        if (response.status == 204) {
            this.set(PROPERTY_DISABLED, disabled);
        }
    }

    @WorkerThread
    @NonNull
    public static KiiThing loadWithThingID(@NonNull String thingId) throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        if (thingId == null) {
            throw new IllegalArgumentException("thingId is null");
        }
        Utils.checkInitialize(true);
        HttpGet request = new HttpGet(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", thingId));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            return new KiiThing(new JSONObject(response.body));
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @WorkerThread
    @NonNull
    public static KiiThing loadWithVendorThingID(@NonNull String vendorThingID) throws IOException, NotFoundException, UnauthorizedException, ForbiddenException, BadRequestException, ConflictException, UndefinedException {
        if (vendorThingID == null) {
            throw new IllegalArgumentException("thingId is null");
        }
        Utils.checkInitialize(true);
        HttpGet request = new HttpGet(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", "VENDOR_THING_ID:" + vendorThingID));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            return new KiiThing(new JSONObject(response.body));
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public static void register(final @NonNull String vendorThingID, final @NonNull String password, final @Nullable String thingType, final @Nullable ThingFields thingFields, final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiThing thing = null;

            @Override
            public void run() {
                try {
                    this.thing = KiiThing.register(vendorThingID, password, thingType, thingFields);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.thing, this.getException());
            }
        });
    }

    public void refresh(final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.this.refresh();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(KiiThing.this, this.getException());
            }
        });
    }

    public void update(final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.this.update();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(KiiThing.this, this.getException());
            }
        });
    }

    public void delete(final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.this.delete();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(KiiThing.this, this.getException());
            }
        });
    }

    public void isOwner(final @NonNull KiiThingOwner owner, final @NonNull KiiCallback<Boolean> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private boolean result;

            @Override
            public void run() {
                try {
                    this.result = KiiThing.this.isOwner(owner);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.result, this.getException());
            }
        });
    }

    public void registerOwner(final @NonNull KiiThingOwner owner, final @NonNull KiiCallback<KiiThingOwner> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.this.registerOwner(owner);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(owner, this.getException());
            }
        });
    }

    public void unregisterOwner(final @NonNull KiiThingOwner owner, final @NonNull KiiCallback<KiiThingOwner> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.this.unregisterOwner(owner);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(owner, this.getException());
            }
        });
    }

    public void disable(final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.this.disable();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(KiiThing.this, this.getException());
            }
        });
    }

    public void enable(final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiThing.this.enable();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(KiiThing.this, this.getException());
            }
        });
    }

    public static void loadWithThingID(final @NonNull String thingId, final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiThing thing;

            @Override
            public void run() {
                try {
                    this.thing = KiiThing.loadWithThingID(thingId);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.thing, this.getException());
            }
        });
    }

    public static void loadWithVendorThingID(final @NonNull String vendorThingID, final @NonNull KiiCallback<KiiThing> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiThing thing;

            @Override
            public void run() {
                try {
                    this.thing = KiiThing.loadWithVendorThingID(vendorThingID);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.thing, this.getException());
            }
        });
    }

    @NonNull
    public KiiBucket bucket(@NonNull String bucketName) {
        return new KiiBucket(this, bucketName);
    }

    @NonNull
    public KiiEncryptedBucket encryptedBucket(@NonNull String bucketName) {
        return new KiiEncryptedBucket(this, bucketName);
    }

    @NonNull
    public KiiTopic topic(@NonNull String name) {
        return new KiiTopic(this, name);
    }

    @NonNull
    public KiiListResult<KiiTopic> listTopics() throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        return this.listTopics((String)null);
    }

    @WorkerThread
    @NonNull
    public KiiListResult<KiiTopic> listTopics(@Nullable String paginationKey) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        String topicUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "things", this.getID(), "topics");
        if (!Utils.isEmpty(paginationKey)) {
            topicUrl = topicUrl + "?paginationKey=" + URLEncoder.encode(paginationKey, "UTF-8");
        }
        HttpGet request = new HttpGet(topicUrl);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject json = new JSONObject(response.body);
            String newPaginationKey = null;
            if (json.has("paginationKey")) {
                newPaginationKey = json.getString("paginationKey");
            }
            JSONArray array = json.getJSONArray("topics");
            ArrayList<KiiTopic> topics = new ArrayList<KiiTopic>();
            for (int i = 0; i < array.length(); ++i) {
                topics.add(this.topic(array.getJSONObject(i).getString("topicID")));
            }
            return new KiiListResult<KiiTopic>(topics, newPaginationKey);
        }
        catch (JSONException e) {
            Log.e("KiiThing", e.getMessage());
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void listTopics(@NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        this.listTopics(null, callback);
    }

    public void listTopics(final @Nullable String paginationKey, final @NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiListResult<KiiTopic> result = null;

            @Override
            public void run() {
                try {
                    this.result = KiiThing.this.listTopics(paginationKey);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.result, this.getException());
            }
        });
    }

    @NonNull
    public KiiPushSubscription pushSubscription() {
        Utils.checkInitialize(true);
        return new KiiPushSubscription(this);
    }

    private void setCreated(long value) {
        this.setReserveProperty(PROPERTY_CREATED, value);
    }

    private void setAccessToken(String value) {
        this.setReserveProperty(PROPERTY_ACCESS_TOKEN, value);
    }

    public void setThingType(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("ThingType is invalid.");
        }
        this.setReserveProperty(PROPERTY_THING_TYPE, value);
    }

    public void setVendor(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("Vendor is invalid.");
        }
        this.setReserveProperty(PROPERTY_VENDOR, value);
    }

    public void setFirmwareVersion(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("FirmwareVersion is invalid.");
        }
        this.setReserveProperty(PROPERTY_FIRMWARE_VERSION, value);
    }

    public void setProductName(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("ProductName is invalid.");
        }
        this.setReserveProperty(PROPERTY_PRODUCT_NAME, value);
    }

    public void setLot(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("Lot is invalid.");
        }
        this.setReserveProperty(PROPERTY_LOT, value);
    }

    public void setStringField1(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("StringField1 is invalid.");
        }
        this.setReserveProperty(PROPERTY_STRING_FIELD_1, value);
    }

    public void setStringField2(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("StringField2 is invalid.");
        }
        this.setReserveProperty(PROPERTY_STRING_FIELD_2, value);
    }

    public void setStringField3(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("StringField3 is invalid.");
        }
        this.setReserveProperty(PROPERTY_STRING_FIELD_3, value);
    }

    public void setStringField4(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("StringField4 is invalid.");
        }
        this.setReserveProperty(PROPERTY_STRING_FIELD_4, value);
    }

    public void setStringField5(@NonNull String value) {
        if (!KiiThing.isValidThingGenericField(value)) {
            throw new IllegalArgumentException("StringField5 is invalid.");
        }
        this.setReserveProperty(PROPERTY_STRING_FIELD_5, value);
    }

    public void setNumberField1(@NonNull Long value) {
        this.setReserveProperty(PROPERTY_NUMBER_FIELD_1, value);
    }

    public void setNumberField2(@NonNull Long value) {
        this.setReserveProperty(PROPERTY_NUMBER_FIELD_2, value);
    }

    public void setNumberField3(@NonNull Long value) {
        this.setReserveProperty(PROPERTY_NUMBER_FIELD_3, value);
    }

    public void setNumberField4(@NonNull Long value) {
        this.setReserveProperty(PROPERTY_NUMBER_FIELD_4, value);
    }

    public void setNumberField5(@NonNull Long value) {
        this.setReserveProperty(PROPERTY_NUMBER_FIELD_5, value);
    }

    @Nullable
    public String getID() {
        return this.getString(PROPERTY_THING_ID, null);
    }

    public long getCreatedTime() {
        return this.getLong(PROPERTY_CREATED);
    }

    @Nullable
    public String getAccessToken() {
        return this.getString(PROPERTY_ACCESS_TOKEN, null);
    }

    @Nullable
    public String getVendorThingID() {
        return this.getString(PROPERTY_VENDOR_THING_ID, null);
    }

    @Nullable
    public String getThingType() {
        return this.getString(PROPERTY_THING_TYPE, null);
    }

    @Nullable
    public String getVendor() {
        return this.getString(PROPERTY_VENDOR, null);
    }

    @Nullable
    public String getFirmwareVersion() {
        return this.getString(PROPERTY_FIRMWARE_VERSION, null);
    }

    @Nullable
    public String getProductName() {
        return this.getString(PROPERTY_PRODUCT_NAME, null);
    }

    @Nullable
    public String getLot() {
        return this.getString(PROPERTY_LOT, null);
    }

    @Nullable
    public String getStringField1() {
        return this.getString(PROPERTY_STRING_FIELD_1, null);
    }

    @Nullable
    public String getStringField2() {
        return this.getString(PROPERTY_STRING_FIELD_2, null);
    }

    @Nullable
    public String getStringField3() {
        return this.getString(PROPERTY_STRING_FIELD_3, null);
    }

    @Nullable
    public String getStringField4() {
        return this.getString(PROPERTY_STRING_FIELD_4, null);
    }

    @Nullable
    public String getStringField5() {
        return this.getString(PROPERTY_STRING_FIELD_5, null);
    }

    @Nullable
    public Long getNumberField1() {
        try {
            return this.getLong(PROPERTY_NUMBER_FIELD_1);
        }
        catch (IllegalKiiBaseObjectFormatException e) {
            return null;
        }
    }

    @Nullable
    public Long getNumberField2() {
        try {
            return this.getLong(PROPERTY_NUMBER_FIELD_2);
        }
        catch (IllegalKiiBaseObjectFormatException e) {
            return null;
        }
    }

    @Nullable
    public Long getNumberField3() {
        try {
            return this.getLong(PROPERTY_NUMBER_FIELD_3);
        }
        catch (IllegalKiiBaseObjectFormatException e) {
            return null;
        }
    }

    @Nullable
    public Long getNumberField4() {
        try {
            return this.getLong(PROPERTY_NUMBER_FIELD_4);
        }
        catch (IllegalKiiBaseObjectFormatException e) {
            return null;
        }
    }

    @Nullable
    public Long getNumberField5() {
        try {
            return this.getLong(PROPERTY_NUMBER_FIELD_5);
        }
        catch (IllegalKiiBaseObjectFormatException e) {
            return null;
        }
    }

    @Nullable
    public Boolean isOnline() {
        try {
            return this.mJSON.getBoolean(PROPERTY_ONLINE);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public long getOnlineStatusModifiedAt() {
        return this.getLong(PROPERTY_ONLINE_STATUS_MODIFIED, -1L);
    }

    public static boolean isValidVendorThingID(@Nullable String vendorThingID) {
        return !TextUtils.isEmpty((CharSequence)vendorThingID) && Utils.validateVendorThingID(vendorThingID);
    }

    public static boolean isValidThingPassword(@Nullable String password) {
        return !TextUtils.isEmpty((CharSequence)password) && Utils.validateThingPassword(password);
    }

    public static boolean isValidThingGenericField(@NonNull String field) {
        return Utils.validateThingGenericField(field);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Bundle b = new Bundle();
        b.putString("mJSON", this.mJSON.toString());
        b.putString("mJSONPatch", this.mJSONPatch.toString());
        dest.writeBundle(b);
    }

    static {
        reservedKeys.add(PROPERTY_ONLINE);
        reservedKeys.add(PROPERTY_ONLINE_STATUS_MODIFIED);
        reservedKeys.add(PROPERTY_THING_ID);
        reservedKeys.add(PROPERTY_VENDOR_THING_ID);
        reservedKeys.add(PROPERTY_PASSWORD);
        reservedKeys.add(PROPERTY_THING_TYPE);
        reservedKeys.add(PROPERTY_VENDOR);
        reservedKeys.add(PROPERTY_FIRMWARE_VERSION);
        reservedKeys.add(PROPERTY_PRODUCT_NAME);
        reservedKeys.add(PROPERTY_LOT);
        reservedKeys.add(PROPERTY_CREATED);
        reservedKeys.addAll(Arrays.asList(PROPERTY_STRING_FIELDS));
        reservedKeys.addAll(Arrays.asList(PROPERTY_NUMBER_FIELDS));
        reservedKeys.add(PROPERTY_ACCESS_TOKEN);
        CREATOR = new Parcelable.Creator<KiiThing>(){

            @NonNull
            public KiiThing createFromParcel(@NonNull Parcel in) {
                try {
                    return new KiiThing(in.readBundle());
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unexpected error!", e);
                }
            }

            @NonNull
            public KiiThing[] newArray(int size) {
                return new KiiThing[size];
            }
        };
    }
}

