/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.kii.cloud.async.executor.KiiObjectBodyTask;
import com.kii.cloud.async.executor.KiiObjectPublishTask;
import com.kii.cloud.async.executor.KiiObjectTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.GeoPoint;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiACL;
import com.kii.cloud.storage.KiiBaseObject;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiScope;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.callback.KiiObjectBodyCallback;
import com.kii.cloud.storage.callback.KiiObjectCallBack;
import com.kii.cloud.storage.callback.KiiObjectPublishCallback;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.CountingFileEntity;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.engine._HttpProgressCallback;
import com.kii.cloud.storage.exception.GroupOperationException;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.KiiDownloader;
import com.kii.cloud.storage.resumabletransfer.KiiUploader;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderFactory;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderFactory;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.MimeUtil;
import com.kii.cloud.storage.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;

public final class KiiObject
extends KiiBaseObject
implements FileHolder,
Parcelable {
    private static final String TAG = "KiiObject";
    private static final String BODY_SEGEMENT = "body";
    private static final String PUBLISH_SEGMENT = "publish";
    private KiiScope mScope;
    private String mBucket;
    private String mId;
    private long mModifiedTime = -1L;
    private long mCreatedTime = -1L;
    private String mEtag = null;
    private boolean mDeleted = false;
    private String mBodyContentType = null;
    private static HashSet<String> reservedKeys = new HashSet();
    static final String PROPERTY_URI = "_kiireserved_uri";
    public static final Parcelable.Creator<KiiObject> CREATOR;

    KiiObject(KiiScope scope, String bucket, String objectID) {
        this.mJSON = new JSONObject();
        this.mBucket = bucket;
        this.mScope = scope;
        this.mId = objectID;
    }

    KiiObject(KiiScope scope, String bucket, JSONObject obj) {
        super(obj);
        if (!Utils.validateQualifiedBucketName(bucket)) {
            throw new IllegalArgumentException("Invalid format:" + bucket);
        }
        this.mBucket = bucket;
        this.mScope = scope;
        try {
            this.mId = obj.getString("_id");
            this.mModifiedTime = obj.getLong("_modified");
            this.mCreatedTime = obj.getLong("_created");
            this.mEtag = obj.getString("_version");
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error!", e);
        }
    }

    KiiObject(KiiScope scope, String bucket) {
        if (!Utils.validateQualifiedBucketName(bucket)) {
            throw new IllegalArgumentException("Invalid format:" + bucket);
        }
        this.mJSON = new JSONObject();
        this.mBucket = bucket;
        this.mScope = scope;
    }

    @NonNull
    public static KiiObject createByUri(@NonNull Uri uri) {
        return new KiiObject(uri);
    }

    KiiObject(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Input uri is null");
        }
        String scheme = uri.getScheme();
        List segments = uri.getPathSegments();
        if (!"kiicloud".equals(scheme)) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        String authority = uri.getAuthority();
        if ("buckets".equals(authority)) {
            if (segments.size() != 3) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            if (!"objects".equals(segments.get(1))) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            this.mScope = null;
            this.mBucket = (String)segments.get(0);
            this.mId = (String)segments.get(2);
        } else if ("users".equals(authority)) {
            if (segments.size() != 5) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            if (!"buckets".equals(segments.get(1))) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            if (!"objects".equals(segments.get(3))) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            this.mScope = KiiUser.createByUri(Uri.parse((String)Utils.path("kiicloud://", "users", segments.get(0))));
            this.mBucket = (String)segments.get(2);
            this.mId = (String)segments.get(4);
        } else if ("groups".equals(authority)) {
            if (segments.size() != 5) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            if (!"buckets".equals(segments.get(1))) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            if (!"objects".equals(segments.get(3))) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            this.mScope = KiiGroup.createByUri(Uri.parse((String)Utils.path("kiicloud://", "groups", segments.get(0))));
            this.mBucket = (String)segments.get(2);
            this.mId = (String)segments.get(4);
        } else if ("things".equals(authority)) {
            if (segments.size() != 5) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            if (!"buckets".equals(segments.get(1))) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            if (!"objects".equals(segments.get(3))) {
                throw new IllegalArgumentException("Do not support this uri:" + uri);
            }
            this.mScope = KiiThing.createByUri(Uri.parse((String)Utils.path("kiicloud://", "things", segments.get(0))));
            this.mBucket = (String)segments.get(2);
            this.mId = (String)segments.get(4);
        }
        this.mJSON = new JSONObject();
    }

    @WorkerThread
    public void save() throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        this.checkScope();
        if (TextUtils.isEmpty((CharSequence)this.getId())) {
            this.saveToCloud();
        } else {
            this.updateToCloud(true, true);
        }
    }

    private void checkScope() throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        if (this.mScope != null) {
            if (this.mScope instanceof KiiGroup) {
                if (((KiiGroup)this.mScope).getID() == null) {
                    try {
                        ((KiiGroup)this.mScope).save();
                    }
                    catch (GroupOperationException e) {
                        Utils.throwException(e);
                    }
                }
            } else if (this.mScope instanceof KiiUser) {
                String id = ((KiiUser)this.mScope).getID();
                if (TextUtils.isEmpty((CharSequence)id)) {
                    throw new RuntimeException("Scope of a user scope object can not be null");
                }
            } else if (this.mScope instanceof KiiThing) {
                String id = ((KiiThing)this.mScope).getID();
                if (TextUtils.isEmpty((CharSequence)id)) {
                    throw new RuntimeException("Scope of a thing scope object can not be null");
                }
            } else {
                throw new RuntimeException("scope is other than user/group/application");
            }
        }
    }

    @WorkerThread
    public void save(boolean overWrite) throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        this.checkScope();
        if (TextUtils.isEmpty((CharSequence)this.getId())) {
            this.saveToCloud();
        } else {
            this.updateToCloud(true, overWrite);
        }
    }

    @WorkerThread
    public void saveAllFields(boolean overWrite) throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        this.checkScope();
        if (TextUtils.isEmpty((CharSequence)this.getId())) {
            this.saveToCloud();
        } else {
            this.updateToCloud(false, overWrite);
        }
    }

    public int save(@Nullable KiiObjectCallBack callback, boolean overWrite) {
        KiiObjectTask objTask = new KiiObjectTask(KiiObjectTask.TaskType.SAVE, this, callback, overWrite);
        KiiTaskExecutor.getInstance().execute(objTask);
        return objTask.getTaskId();
    }

    public int saveAllFields(@Nullable KiiObjectCallBack callback, boolean overWrite) {
        KiiObjectTask objTask = new KiiObjectTask(KiiObjectTask.TaskType.SAVE_ALLFIELDS, this, callback, overWrite);
        KiiTaskExecutor.getInstance().execute(objTask);
        return objTask.getTaskId();
    }

    private void saveToCloud() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        String bucketUrl = this.getBucketUrl();
        HttpPost request = new HttpPost(bucketUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        String entityToCloud = this.mJSON.toString();
        Log.v(TAG, "request body: " + entityToCloud);
        StringEntity entity = new StringEntity(entityToCloud, "UTF8");
        entity.setContentType("application/json");
        request.setEntity((HttpEntity)entity);
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        this.mEtag = res.eTag;
        try {
            String retUuid;
            JSONObject respObj = new JSONObject(res.body);
            this.mId = retUuid = respObj.getString("objectID");
            this.mModifiedTime = this.mCreatedTime = respObj.getLong("createdAt");
            this.mJSONPatch = new JSONObject();
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    private void updateToCloud(boolean patch, boolean overWrite) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        String entityToCloud;
        HttpPost request;
        Utils.checkInitialize(false);
        String uuid = this.getId();
        String bucketUrl = this.getBucketUrl();
        if (patch) {
            request = new HttpPost(Utils.path(bucketUrl, uuid));
            request.setHeader("X-HTTP-Method-Override", "PATCH");
            entityToCloud = this.mJSONPatch.toString();
        } else {
            request = new HttpPut(Utils.path(bucketUrl, uuid));
            entityToCloud = this.mJSON.toString();
        }
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        Log.v(TAG, "mEtag: " + this.mEtag);
        if (!overWrite && this.isSaved()) {
            if (this.mEtag == null) {
                throw new IllegalStateException("IllegalState, refresh the kiiobject before call this method");
            }
            request.setHeader("If-Match", this.mEtag);
        } else if (!overWrite && !this.isSaved()) {
            if (patch && TextUtils.isEmpty((CharSequence)this.mEtag)) {
                throw new IllegalStateException("Can not create or update KiiObject in this state. If you want to update KiiObject, please call KiiObject#refresh() before call this method.");
            }
            request.setHeader("If-None-Match", "*");
        }
        Log.v(TAG, "request body: " + entityToCloud);
        StringEntity entity = new StringEntity(entityToCloud, "UTF8");
        entity.setContentType("application/json");
        ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        this.mEtag = res.eTag;
        try {
            JSONObject respObj = new JSONObject(res.body);
            String retUuid = respObj.optString("objectID", null);
            if (!TextUtils.isEmpty((CharSequence)retUuid)) {
                this.mId = retUuid;
            }
            if (patch) {
                this.mCreatedTime = respObj.getLong("_created");
                this.mModifiedTime = respObj.getLong("_modified");
            } else {
                this.mModifiedTime = respObj.getLong("modifiedAt");
                this.mCreatedTime = respObj.getLong("createdAt");
            }
            this.mJSONPatch = new JSONObject();
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    private String createBucket() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, NotFoundException, UndefinedException {
        String type = this.getBucket();
        String bucketUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "buckets", type);
        HttpPut bucketRequest = new HttpPut(bucketUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)bucketRequest);
        bucketRequest.setHeader("X-Kii-AppID", Kii.getAppId());
        bucketRequest.setHeader("X-Kii-AppKey", Kii.getAppKey());
        bucketRequest.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        JSONObject bucketReqBody = new JSONObject();
        try {
            bucketReqBody.put("bucketType", (Object)"DEFAULT");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        StringEntity entity = new StringEntity(bucketReqBody.toString());
        entity.setContentType("application/vnd.kii.BucketCreationRequest+json");
        bucketRequest.setEntity((HttpEntity)entity);
        try {
            ApiResponse apiResponse = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)bucketRequest);
        }
        catch (ConflictException conflictException) {
            // empty catch block
        }
        return type;
    }

    @WorkerThread
    public void delete() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        String bucket = this.getBucket();
        if (TextUtils.isEmpty((CharSequence)bucket)) {
            throw new IllegalStateException("Missing entity type");
        }
        String uuid = this.getId();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Missing unique identifier");
        }
        String deleteUrl = Utils.path(this.getBucketUrl(), uuid);
        HttpDelete request = new HttpDelete(deleteUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        this.clearAll();
        this.mDeleted = true;
    }

    @WorkerThread
    @NonNull
    public String publishBody() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        return this.publishBodyImpl(new JSONObject());
    }

    @WorkerThread
    @NonNull
    public String publishBodyExpiresAt(long expiresAt) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("expiresAt", expiresAt);
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return this.publishBodyImpl(requestBody);
    }

    @WorkerThread
    @NonNull
    public String publishBodyExpiresIn(int expiresIn) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        if (expiresIn <= 0) {
            throw new IllegalArgumentException("The expiration date must be in the future.");
        }
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("expiresIn", expiresIn);
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return this.publishBodyImpl(requestBody);
    }

    private String publishBodyImpl(JSONObject requestBodyJSON) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        String objectID = this.getId();
        if (Utils.isEmpty(objectID)) {
            throw new IllegalStateException("Missing unique identifier");
        }
        String bucket = this.getBucket();
        if (Utils.isEmpty(bucket)) {
            throw new IllegalStateException("Missing entity type");
        }
        String postUrl = Utils.path(this.getBucketUrl(), objectID, BODY_SEGEMENT, PUBLISH_SEGMENT);
        HttpPost request = new HttpPost(postUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        String requestBody = requestBodyJSON.toString();
        Log.v(TAG, "request body: " + requestBody);
        StringEntity entity = new StringEntity(requestBody, "UTF8");
        entity.setContentType("application/vnd.kii.ObjectBodyPublicationRequest+json");
        request.setEntity((HttpEntity)entity);
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject object = new JSONObject(response.body);
            return object.getString("url");
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @WorkerThread
    public void uploadBody(@NonNull File sourceFile, @Nullable String contentType) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        this.uploadBodyImpl(sourceFile, contentType, null);
    }

    private void uploadBodyImpl(File sourceFile, String contentType, final KiiObjectBodyTask task) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        if (sourceFile == null) {
            throw new IllegalArgumentException("Upload or update file is null");
        }
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        if (sourceFile.isDirectory()) {
            throw new IllegalArgumentException("File path is directory.");
        }
        String bucket = this.getBucket();
        if (TextUtils.isEmpty((CharSequence)bucket)) {
            throw new IllegalStateException("Missing entity type");
        }
        String uuid = this.getId();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Missing unique identifier");
        }
        if (TextUtils.isEmpty((CharSequence)contentType) && TextUtils.isEmpty((CharSequence)(contentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeUtil.getSuffixOfFile(sourceFile.getName()))))) {
            contentType = "application/octet-stream";
        }
        String url = Utils.path(this.getBucketUrl(), uuid, BODY_SEGEMENT);
        HttpPut request = new HttpPut(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        CountingFileEntity entity = new CountingFileEntity(sourceFile, contentType, new _HttpProgressCallback(){

            @Override
            public void onProgress(long completedSizeInBytes, long totalSizeInBytes) {
                if (task == null) {
                    return;
                }
                task.updateTransferProgress(completedSizeInBytes, totalSizeInBytes);
            }
        });
        request.setEntity((HttpEntity)entity);
        request.setHeader("Content-Type", contentType);
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        this.mBodyContentType = contentType;
        try {
            JSONObject respObj = new JSONObject(res.body);
            this.mModifiedTime = respObj.getLong("modifiedAt");
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @WorkerThread
    public void downloadBody(@NonNull File destFile) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        this.downloadBodyImpl(destFile, null);
    }

    private void downloadBodyImpl(File destFile, final KiiObjectBodyTask task) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        if (destFile == null) {
            throw new IllegalArgumentException("Destination file is null");
        }
        if (destFile.isDirectory()) {
            throw new IllegalArgumentException("File path is directory.");
        }
        String objectID = this.getId();
        if (Utils.isEmpty(objectID)) {
            throw new IllegalStateException("Missing unique identifier");
        }
        String bucket = this.getBucket();
        if (Utils.isEmpty(bucket)) {
            throw new IllegalStateException("Missing entity type");
        }
        String url = Utils.path(this.getBucketUrl(), objectID, BODY_SEGEMENT);
        HttpGet request = new HttpGet(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse res = KiiCloudEngine.getInstance().downloadFileRequest((HttpUriRequest)request, destFile, new _HttpProgressCallback(){

            @Override
            public void onProgress(long currentSizeInBytes, long totalSizeInBytes) {
                if (task == null) {
                    return;
                }
                task.updateTransferProgress(currentSizeInBytes, totalSizeInBytes);
            }
        });
        this.mBodyContentType = res.contentType;
    }

    @WorkerThread
    public void deleteBody() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        String bucket = this.getBucket();
        if (TextUtils.isEmpty((CharSequence)bucket)) {
            throw new IllegalStateException("Missing entity type");
        }
        String objectId = this.getId();
        if (TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalStateException("Missing unique identifier");
        }
        String deleteUrl = Utils.path(this.getBucketUrl(), objectId, BODY_SEGEMENT);
        HttpDelete request = new HttpDelete(deleteUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        this.mBodyContentType = null;
    }

    private void clearAll() {
        this.mJSON = new JSONObject();
        this.mId = null;
        this.mBucket = null;
        this.mScope = null;
        this.mCreatedTime = -1L;
        this.mModifiedTime = -1L;
        this.mEtag = null;
        this.mBodyContentType = null;
    }

    boolean isDeleted() {
        return this.mDeleted;
    }

    @WorkerThread
    public void refresh() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        String bucket = this.getBucket();
        if (TextUtils.isEmpty((CharSequence)bucket)) {
            throw new IllegalStateException("Missing entity type");
        }
        String uuid = this.getId();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Missing unique identifier");
        }
        String getUrl = Utils.path(this.getBucketUrl(), uuid);
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        this.mEtag = res.eTag;
        try {
            JSONObject respObj;
            this.mJSON = respObj = new JSONObject(res.body);
            this.mCreatedTime = respObj.getLong("_created");
            this.mModifiedTime = respObj.optLong("_modified", -1L);
            if (this.mModifiedTime == -1L) {
                this.mModifiedTime = this.mCreatedTime;
            }
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public int save(@Nullable KiiObjectCallBack callBack) {
        KiiObjectTask objTask = new KiiObjectTask(KiiObjectTask.TaskType.SAVE, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(objTask);
        return objTask.getTaskId();
    }

    public int delete(@Nullable KiiObjectCallBack callBack) {
        KiiObjectTask objTask = new KiiObjectTask(KiiObjectTask.TaskType.DELETE, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(objTask);
        return objTask.getTaskId();
    }

    public void publishBody(@Nullable KiiObjectPublishCallback callback) {
        KiiObjectPublishTask publishTask = new KiiObjectPublishTask(KiiObjectPublishTask.ObjectPublishTaskType.PUBLISH_BODY, this, callback, new Object[0]);
        KiiTaskExecutor.getInstance().execute(publishTask);
    }

    public void publishBodyExpiresAt(long expiresAt, @Nullable KiiObjectPublishCallback callback) {
        KiiObjectPublishTask publishTask = new KiiObjectPublishTask(KiiObjectPublishTask.ObjectPublishTaskType.PUBLISH_BODY_EXPIRES_AT, this, callback, expiresAt);
        KiiTaskExecutor.getInstance().execute(publishTask);
    }

    public void publishBodyExpiresIn(int expiresIn, @Nullable KiiObjectPublishCallback callback) {
        KiiObjectPublishTask publishTask = new KiiObjectPublishTask(KiiObjectPublishTask.ObjectPublishTaskType.PUBLISH_BODY_EXPIRES_IN, this, callback, expiresIn);
        KiiTaskExecutor.getInstance().execute(publishTask);
    }

    @WorkerThread
    public void uploadBody(final @NonNull File sourceFile, final @Nullable String contentType, @Nullable KiiObjectBodyCallback callback) {
        KiiObjectBodyTask objTask = new KiiObjectBodyTask(KiiObjectBodyTask.ObjectBodyTaskType.UPLOAD_BODY, this, callback, new Object[0]){

            @Override
            public void run() {
                try {
                    KiiObject.this.uploadBodyImpl(sourceFile, contentType, this);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }
        };
        KiiTaskExecutor.getInstance().execute(objTask);
    }

    public void downloadBody(final @NonNull File destFile, @Nullable KiiObjectBodyCallback callback) {
        KiiObjectBodyTask objTask = new KiiObjectBodyTask(KiiObjectBodyTask.ObjectBodyTaskType.DOWNLOAD_BODY, this, callback, new Object[0]){

            @Override
            public void run() {
                try {
                    KiiObject.this.downloadBodyImpl(destFile, this);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }
        };
        KiiTaskExecutor.getInstance().execute(objTask);
    }

    public int deleteBody(@Nullable KiiObjectCallBack callBack) {
        KiiObjectTask objTask = new KiiObjectTask(KiiObjectTask.TaskType.DELETE_BODY, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(objTask);
        return objTask.getTaskId();
    }

    public int refresh(@Nullable KiiObjectCallBack callBack) {
        KiiObjectTask objTask = new KiiObjectTask(KiiObjectTask.TaskType.REFRESH, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(objTask);
        return objTask.getTaskId();
    }

    String getId() {
        return this.mId;
    }

    @Nullable
    public Uri toUri() {
        String uuid = this.getId();
        if (Utils.isEmpty(uuid)) {
            return null;
        }
        String bucket = this.getBucket();
        if (Utils.isEmpty(bucket)) {
            throw new IllegalStateException("Missing entity type");
        }
        String url = Utils.path("kiicloud://", this.getPathSegment(), this.mId);
        return Uri.parse((String)url);
    }

    String getBucket() {
        return this.mBucket;
    }

    Uri toUri2() {
        KiiGroup sc;
        if (this.isDeleted()) {
            throw new IllegalStateException("object has already deleted");
        }
        if (this.mScope instanceof KiiGroup && (sc = (KiiGroup)this.mScope).isDeleted()) {
            throw new IllegalStateException("Parent group has already deleted");
        }
        return this.toUri();
    }

    private String getBucketUrl() {
        return Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), this.getPathSegment());
    }

    private String getPathSegment() {
        if (this.mScope == null) {
            return Utils.path("buckets", this.mBucket, "objects");
        }
        if (this.mScope instanceof KiiGroup) {
            String scopeId = this.getGroupId((KiiGroup)this.mScope);
            return Utils.path("groups", scopeId, "buckets", this.mBucket, "objects");
        }
        if (this.mScope instanceof KiiUser) {
            String scopeId = this.getUserId((KiiUser)this.mScope);
            return Utils.path("users", scopeId, "buckets", this.mBucket, "objects");
        }
        if (this.mScope instanceof KiiThing) {
            String scopeId = ((KiiThing)this.mScope).getID();
            return Utils.path("things", scopeId, "buckets", this.mBucket, "objects");
        }
        throw new IllegalStateException("Unknown scope");
    }

    private String getUserId(KiiUser parentUser) {
        String id = parentUser.getID();
        if (id == null) {
            throw new IllegalStateException("No login user");
        }
        return id;
    }

    private String getGroupId(KiiGroup parentGroup) {
        String id = parentGroup.getID();
        if (id == null) {
            throw new IllegalStateException("Group ID is null");
        }
        return id;
    }

    public long getModifedTime() {
        return this.mModifiedTime;
    }

    public long getCreatedTime() {
        return this.mCreatedTime;
    }

    @NonNull
    public KiiACL acl() {
        return new KiiACL(this);
    }

    String getUFPUri() {
        String id = this.getId();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("Missing unique identifier");
        }
        String bucketPath = this.getBucketUrl();
        return Utils.path(bucketPath, id);
    }

    public void set(@NonNull String key, @NonNull GeoPoint value) {
        if (value == null) {
            throw new IllegalArgumentException("Specified value is null.");
        }
        super.set(key, value.toJSON());
    }

    @Override
    public void set(@NonNull String key, @NonNull JSONObject value) {
        this.assertKey(key);
        if (value == null) {
            throw new IllegalArgumentException("Value canot be null.");
        }
        try {
            this.mJSON.put(key, (Object)value);
            this.mJSONPatch.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @Override
    public void set(@NonNull String key, @NonNull String value) {
        super.set(key, value);
    }

    @NonNull
    public GeoPoint getGeoPoint(@NonNull String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Key is empty or null");
        }
        JSONObject json = super.getJSONObject(key);
        try {
            return GeoPoint.createFromJSON(json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Nullable
    public GeoPoint getGeoPoint(@NonNull String key, @Nullable GeoPoint fallback) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Key is empty or null");
        }
        JSONObject json = this.mJSON.optJSONObject(key);
        if (json == null) {
            return fallback;
        }
        try {
            return GeoPoint.createFromJSON(json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @NonNull
    public JSONObject toJSON() {
        JSONObject json = this.getJSONOfArbitraryFields();
        try {
            json.put("_created", this.getCreatedTime());
            json.put("_modified", this.getModifedTime());
            Uri uri = this.toUri();
            if (uri == null) {
                json.put(PROPERTY_URI, JSONObject.NULL);
            } else {
                json.put(PROPERTY_URI, (Object)uri);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return json;
    }

    @NonNull
    public String toString() {
        return this.toJSON().toString();
    }

    @NonNull
    public KiiUploader uploader(@NonNull Context context, @NonNull File source) {
        if (context == null || source == null) {
            throw new IllegalArgumentException("Context or File is null");
        }
        return KiiUploaderFactory.newUploader(context, this, source);
    }

    @NonNull
    public KiiDownloader downloader(@NonNull Context context, @NonNull File dest) throws InvalidHolderException {
        if (context == null || dest == null) {
            throw new IllegalArgumentException("Context or dest file is null");
        }
        return KiiDownloaderFactory.newDownloader(context, this, dest);
    }

    public int describeContents() {
        return 0;
    }

    private Bundle getScopeBundle() {
        Bundle b = new Bundle();
        String scopeName = this.getScopeName();
        b = new Bundle();
        b.putString("scopeName", scopeName);
        b.putString("scopeId", this.getScopeId());
        return b;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle b = new Bundle();
        if (this.mId != null) {
            b.putString("id", this.getId());
        }
        b.putString("bucket", this.mBucket);
        b.putString("etag", this.mEtag);
        b.putString("json", this.mJSON.toString());
        b.putString("json-patch", this.mJSONPatch.toString());
        b.putBoolean("isDeleted", this.mDeleted);
        b.putLong("created", this.mCreatedTime);
        b.putLong("modified", this.mModifiedTime);
        Bundle scopeBundle = this.getScopeBundle();
        b.putBundle("scope", scopeBundle);
        dest.writeBundle(b);
    }

    KiiObject(Bundle b) throws JSONException {
        super(new JSONObject(b.getString("json")), new JSONObject(b.getString("json-patch")));
        this.mBucket = b.getString("bucket");
        this.mId = b.getString("id");
        Bundle scopeBundle = b.getBundle("scope");
        this.mScope = this.createScope(scopeBundle);
        this.mModifiedTime = b.getLong("modified");
        this.mCreatedTime = b.getLong("created");
        this.mEtag = b.getString("etag");
        this.mDeleted = b.getBoolean("isDeleted");
    }

    private String getScopeName() {
        String scopeName = null;
        scopeName = this.mScope instanceof KiiGroup ? "group" : (this.mScope instanceof KiiUser ? "user" : (this.mScope instanceof KiiThing ? "thing" : "app"));
        return scopeName;
    }

    private String getScopeId() {
        String scopeId = null;
        if (this.mScope instanceof KiiGroup) {
            scopeId = this.getGroupId((KiiGroup)this.mScope);
        } else if (this.mScope instanceof KiiUser) {
            scopeId = this.getUserId((KiiUser)this.mScope);
        } else if (this.mScope instanceof KiiThing) {
            scopeId = ((KiiThing)this.mScope).getID();
        }
        return scopeId;
    }

    private KiiScope createScope(Bundle bundle) {
        KiiScope scope = null;
        String name = bundle.getString("scopeName");
        String id = bundle.getString("scopeId");
        if ("group".equals(name)) {
            scope = KiiGroup.createByUri(Uri.parse((String)Utils.path("kiicloud://", "groups", id)));
        } else if ("user".equals(name)) {
            scope = KiiUser.createByUri(Uri.parse((String)Utils.path("kiicloud://", "users", id)));
        } else if ("thing".equals(name)) {
            scope = KiiThing.createByUri(Uri.parse((String)Utils.path("kiicloud://", "things", id)));
        }
        return scope;
    }

    public static boolean isValidObjectID(@Nullable String objectID) {
        return Utils.isValidObjectID(objectID);
    }

    private boolean isSaved() {
        return this.mCreatedTime > -1L;
    }

    @Nullable
    public String getBodyContentType() {
        return this.mBodyContentType;
    }

    @Override
    boolean isValidKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        return reservedKeys == null || reservedKeys.size() <= 0 || !reservedKeys.contains(key);
    }

    static {
        reservedKeys.add(PROPERTY_URI);
        CREATOR = new Parcelable.Creator<KiiObject>(){

            @NonNull
            public KiiObject createFromParcel(@NonNull Parcel in) {
                try {
                    return new KiiObject(in.readBundle());
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unexpected error!");
                }
            }

            @NonNull
            public KiiObject[] newArray(int size) {
                return new KiiObject[size];
            }
        };
    }
}

