/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class KiiBaseObject {
    protected JSONObject mJSON;
    protected JSONObject mJSONPatch;

    KiiBaseObject(JSONObject json) {
        this.mJSON = json;
        this.mJSONPatch = new JSONObject();
    }

    KiiBaseObject(JSONObject json, JSONObject patch) {
        this.mJSON = json;
        this.mJSONPatch = patch;
    }

    KiiBaseObject() {
        this.mJSON = new JSONObject();
        this.mJSONPatch = new JSONObject();
    }

    @NonNull
    public HashSet<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        Iterator it = this.mJSON.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!this.isValidKey(key) || key.startsWith("_")) continue;
            keySet.add(key);
        }
        return keySet;
    }

    protected JSONObject getJSONOfArbitraryFields() {
        HashSet<String> keyset = this.keySet();
        Iterator<String> it = keyset.iterator();
        JSONObject json = new JSONObject();
        while (it.hasNext()) {
            String key = it.next();
            try {
                Object value = this.mJSON.get(key);
                json.put(key, value);
            }
            catch (JSONException e) {
                throw new IllegalKiiBaseObjectFormatException(e.getMessage());
            }
        }
        return json;
    }

    public void set(@NonNull String key, int value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, int value) {
        this.setInner(key, value);
    }

    private void setInner(String key, int value) {
        try {
            this.mJSON.put(key, value);
            this.mJSONPatch.put(key, value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void set(@NonNull String key, long value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, long value) {
        this.setInner(key, value);
    }

    private void setInner(String key, long value) {
        try {
            this.mJSON.put(key, value);
            this.mJSONPatch.put(key, value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public boolean has(@NonNull String key) {
        return this.mJSON.has(key);
    }

    public void remove(@NonNull String key) {
        this.assertKey(key);
        this.mJSON.remove(key);
        this.mJSONPatch.remove(key);
    }

    @Nullable
    public byte[] getByteArray(@NonNull String key) {
        if (!this.has(key)) {
            return null;
        }
        try {
            String temp = this.mJSON.getString(key);
            if (TextUtils.isEmpty((CharSequence)temp)) {
                return null;
            }
            return Base64.decode((String)temp, (int)0);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void set(@NonNull String key, @NonNull byte[] value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, byte[] value) {
        this.setInner(key, value);
    }

    private void setInner(String key, byte[] value) {
        String temp = value == null ? "" : Base64.encodeToString((byte[])value, (int)0);
        try {
            this.mJSON.put(key, (Object)temp);
            this.mJSONPatch.put(key, (Object)temp);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @NonNull
    public String getString(@NonNull String key) {
        try {
            return this.mJSON.getString(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @NonNull
    public Object getObject(@NonNull String key) {
        try {
            return this.mJSON.get(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @Nullable
    public Object getObject(@NonNull String key, @Nullable Object fallback) {
        Object ret = this.mJSON.opt(key);
        if (ret == null) {
            return fallback;
        }
        return ret;
    }

    @Nullable
    public String getString(@NonNull String key, @Nullable String value) {
        return this.mJSON.optString(key, value);
    }

    public void set(@NonNull String key, @NonNull String value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    private void setInner(String key, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value canot be null.");
        }
        try {
            this.mJSON.put(key, (Object)value);
            this.mJSONPatch.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    void setReserveProperty(String key, String value) {
        this.setInner(key, value);
    }

    @NonNull
    public Boolean getBoolean(@NonNull String key) {
        try {
            return this.mJSON.getBoolean(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @NonNull
    public Boolean getBoolean(@NonNull String key, @NonNull Boolean default_value) {
        return this.mJSON.optBoolean(key, default_value.booleanValue());
    }

    public double getDouble(@NonNull String key) {
        try {
            return this.mJSON.getDouble(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public double getDouble(@NonNull String key, double default_value) {
        return this.mJSON.optDouble(key, default_value);
    }

    @NonNull
    public JSONArray getJsonArray(@NonNull String key) {
        try {
            return this.mJSON.getJSONArray(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @NonNull
    public JSONArray getJSONArray(@NonNull String key, @NonNull JSONArray default_value) {
        JSONArray jsonArray = this.mJSON.optJSONArray(key);
        return jsonArray == null ? default_value : jsonArray;
    }

    public void set(@NonNull String key, @NonNull Boolean value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, Boolean value) {
        this.setInner(key, value);
    }

    private void setInner(String key, Boolean value) {
        try {
            this.mJSON.put(key, (Object)value);
            this.mJSONPatch.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void set(@NonNull String key, double value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, double value) {
        this.setInner(key, value);
    }

    private void setInner(String key, double value) {
        try {
            this.mJSON.put(key, value);
            this.mJSONPatch.put(key, value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void set(@NonNull String key, @NonNull JSONArray value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, JSONArray value) {
        this.setInner(key, value);
    }

    private void setInner(String key, JSONArray value) {
        try {
            this.mJSON.put(key, (Object)value);
            this.mJSONPatch.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void set(@NonNull String key, @NonNull Uri value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, Uri value) {
        this.setInner(key, value);
    }

    private void setInner(String key, Uri value) {
        if (value == null) {
            throw new IllegalArgumentException("Value canot be null.");
        }
        try {
            this.mJSON.put(key, (Object)value.toString());
            this.mJSONPatch.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @NonNull
    public Uri getUri(@NonNull String key) {
        try {
            String uri = this.mJSON.getString(key);
            return Uri.parse((String)uri);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public int getInt(@NonNull String key) {
        try {
            return this.mJSON.getInt(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public int getInt(@NonNull String key, int default_value) {
        return this.mJSON.optInt(key, default_value);
    }

    public long getLong(@NonNull String key) {
        try {
            return this.mJSON.getLong(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public long getLong(@NonNull String key, long default_value) {
        return this.mJSON.optLong(key, default_value);
    }

    @NonNull
    public JSONObject getJSONObject(@NonNull String key) {
        try {
            return this.mJSON.getJSONObject(key);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void set(@NonNull String key, @NonNull JSONObject value) {
        this.assertKey(key);
        this.setInner(key, value);
    }

    void setReserveProperty(String key, JSONObject value) {
        this.setInner(key, value);
    }

    private void setInner(String key, JSONObject value) {
        if (value == null) {
            throw new IllegalArgumentException("Value canot be null.");
        }
        try {
            this.mJSON.put(key, (Object)value);
            this.mJSONPatch.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    void assertStringValue(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException("Value can not be null or empty string");
        }
    }

    void assertKey(String key) {
        if (!this.isValidKey(key)) {
            throw new IllegalArgumentException("Key is invalid :" + key);
        }
    }

    abstract boolean isValidKey(String var1);

    protected void removeReserveProperty(String key) {
        this.mJSON.remove(key);
        this.mJSONPatch.remove(key);
    }
}

