/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import com.kii.cloud.storage.KiiACL;
import com.kii.cloud.storage.KiiAnonymousUser;
import com.kii.cloud.storage.KiiAnyAuthenticatedUser;
import com.kii.cloud.storage.KiiBaseBucket;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.KiiSubject;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.KiiUser;

public final class KiiACLEntry {
    private boolean isGrant;
    private KiiSubject mSubject;
    private Object mParent;
    private KiiACL.Action mAction;

    public KiiACLEntry(@NonNull KiiSubject subject, @NonNull KiiACL.Action action, boolean grant) {
        if (subject == null || action == null) {
            throw new IllegalArgumentException("subject and action can not be null");
        }
        this.mSubject = subject;
        this.mAction = action;
        this.isGrant = grant;
    }

    public KiiACLEntry(@NonNull Object parent, @NonNull KiiSubject subject, @NonNull KiiACL.Action action, boolean grant) {
        this(subject, action, grant);
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        if (!(parent instanceof KiiTopic || parent instanceof KiiObject || parent instanceof KiiBaseBucket)) {
            throw new IllegalArgumentException("unknown parent");
        }
        this.mParent = parent;
        if (subject == null || action == null) {
            throw new IllegalArgumentException("subject and action can not be null");
        }
    }

    public void setSubject(@NonNull KiiSubject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("subject can not be null");
        }
        this.mSubject = subject;
    }

    public void setAction(@NonNull KiiACL.Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action can not be null");
        }
        this.mAction = action;
    }

    public void setGrant(boolean grant) {
        this.isGrant = grant;
    }

    @NonNull
    public KiiSubject getSubject() {
        return this.mSubject;
    }

    @NonNull
    public KiiACL.Action getAction() {
        return this.mAction;
    }

    public boolean grant() {
        return this.isGrant;
    }

    void setParent(Object parent) {
        this.mParent = parent;
    }

    public int hashCode() {
        StringBuilder builder = new StringBuilder().append(KiiACLEntry.getParentId(this.mParent)).append(KiiACLEntry.getSubjectId(this.mSubject)).append(KiiACL.getActionString(this.mAction)).append(this.isGrant ? "grant" : "revoke");
        return builder.toString().hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof KiiACLEntry)) {
            return false;
        }
        KiiACLEntry entry = (KiiACLEntry)that;
        return this.hasEqualState(entry);
    }

    private boolean hasEqualState(KiiACLEntry entry) {
        return KiiACLEntry.getParentId(this.mParent).equals(KiiACLEntry.getParentId(entry.mParent)) && this.isGrant == entry.isGrant && this.mAction.equals(entry.mAction) && KiiACLEntry.getSubjectId(this.mSubject).equals(KiiACLEntry.getSubjectId(entry.mSubject));
    }

    static String getParentId(Object parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof KiiObject) {
            return ((KiiObject)parent).getId();
        }
        if (parent instanceof KiiBucket) {
            return ((KiiBucket)parent).getQualifiedBucketName();
        }
        if (parent instanceof KiiTopic) {
            return ((KiiTopic)parent).getName();
        }
        throw new RuntimeException("Unexpected error." + parent.getClass().getCanonicalName());
    }

    static String getSubjectId(KiiSubject subject) {
        if (subject instanceof KiiUser) {
            return ((KiiUser)subject).getID();
        }
        if (subject instanceof KiiGroup) {
            return ((KiiGroup)subject).getID();
        }
        if (subject instanceof KiiAnyAuthenticatedUser) {
            return "ANY_AUTHENTICATED_USER";
        }
        if (subject instanceof KiiAnonymousUser) {
            return "ANONYMOUS_USER";
        }
        if (subject instanceof KiiThing) {
            return ((KiiThing)subject).getID();
        }
        throw new RuntimeException("Unexpected error." + subject.getClass().getCanonicalName());
    }
}

