/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.async.executor.KiiACLTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiACLEntry;
import com.kii.cloud.storage.KiiAnonymousUser;
import com.kii.cloud.storage.KiiAnyAuthenticatedUser;
import com.kii.cloud.storage.KiiBaseBucket;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.KiiSubject;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.callback.KiiACLCallBack;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.ACLOperationException;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class KiiACL {
    private Object mParent;
    private Set<KiiACLEntry> entrySet = new CopyOnWriteArraySet<KiiACLEntry>();

    KiiACL(KiiObject object) {
        this.mParent = object;
    }

    KiiACL(KiiBaseBucket bucket) {
        this.mParent = bucket;
    }

    KiiACL(KiiTopic topic) {
        this.mParent = topic;
    }

    private void sendACLRequest(String url, ACLOperation operation) throws AppException, IOException {
        HttpPut request = null;
        switch (operation) {
            case GRANT: {
                request = new HttpPut(url);
                break;
            }
            case REVOKE: {
                request = new HttpDelete(url);
                break;
            }
            default: {
                throw new UnsupportedOperationException("not grant/revoke request");
            }
        }
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    private void objectACLRequest(KiiObject object, Action action, ACLOperation operation, String lastSegment) throws AppException, IOException {
        if (object.isDeleted()) {
            throw new IllegalStateException("object is already deleted from cloud");
        }
        if (TextUtils.isEmpty((CharSequence)object.getId())) {
            object.save();
        }
        String uri = object.getUFPUri();
        this.assertObjectAction(action);
        String requestUri = Utils.path(uri, "acl", KiiACL.getActionString(action), lastSegment);
        this.sendACLRequest(requestUri, operation);
    }

    private void bucketACLRequest(KiiBucket bucket, Action action, ACLOperation operation, String lastSegment) throws AppException, IOException {
        String uri = bucket.getBucketUrl();
        this.assertBucketAction(action);
        String requestUri = Utils.path(uri, "acl", KiiACL.getActionString(action), lastSegment);
        this.sendACLRequest(requestUri, operation);
    }

    private void topicACLRequest(KiiTopic topic, Action action, ACLOperation operation, String lastSegment) throws AppException, IOException {
        String uri = topic.getUFEUri();
        this.assertTopicAction(action);
        String requestUri = Utils.path(uri, "acl", KiiACL.getActionString(action), lastSegment);
        this.sendACLRequest(requestUri, operation);
    }

    private void aclRequest(KiiSubject subject, Action action, ACLOperation operation) throws AppException, IOException {
        String subjectStr = this.getSubjectString(subject);
        if (this.mParent == null) {
            throw new UnsupportedOperationException("Bucket container ACL operation has not implemented.");
        }
        if (this.mParent instanceof KiiObject) {
            KiiObject obj = (KiiObject)this.mParent;
            this.objectACLRequest(obj, action, operation, subjectStr);
        } else if (this.mParent instanceof KiiBucket) {
            KiiBucket bucket = (KiiBucket)this.mParent;
            this.bucketACLRequest(bucket, action, operation, subjectStr);
        } else if (this.mParent instanceof KiiTopic) {
            KiiTopic topic = (KiiTopic)this.mParent;
            this.topicACLRequest(topic, action, operation, subjectStr);
        } else {
            throw new RuntimeException("Unexpected error." + this.mParent.getClass().getCanonicalName());
        }
    }

    private String getSubjectString(KiiSubject subject) {
        if (subject instanceof KiiUser) {
            KiiUser user = (KiiUser)subject;
            return "UserID:" + user.getID();
        }
        if (subject instanceof KiiGroup) {
            KiiGroup group = (KiiGroup)subject;
            return "GroupID:" + group.getID();
        }
        if (subject instanceof KiiAnyAuthenticatedUser) {
            return "UserID:ANY_AUTHENTICATED_USER";
        }
        if (subject instanceof KiiAnonymousUser) {
            return "UserID:ANONYMOUS_USER";
        }
        if (subject instanceof KiiThing) {
            return "ThingID:" + ((KiiThing)subject).getID();
        }
        throw new RuntimeException("Unexpected error." + subject.getClass().getCanonicalName());
    }

    private ACLOperation getOperation(KiiACLEntry entry) {
        return entry.grant() ? ACLOperation.GRANT : ACLOperation.REVOKE;
    }

    @WorkerThread
    public void save() throws ACLOperationException {
        for (KiiACLEntry entry : this.entrySet) {
            try {
                this.aclRequest(entry.getSubject(), entry.getAction(), this.getOperation(entry));
                this.entrySet.remove(entry);
            }
            catch (IOException ioe) {
                throw new ACLOperationException(ioe.getMessage(), ioe, new ArrayList<KiiACLEntry>(this.entrySet));
            }
            catch (AppException appException) {
                throw new ACLOperationException(appException.getMessage(), appException, new ArrayList<KiiACLEntry>(this.entrySet));
            }
        }
    }

    public int save(@NonNull KiiACLCallBack callback) {
        KiiACLTask task = new KiiACLTask(KiiACLTask.TaskType.SAVE, this, callback);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    public void putACLEntry(@NonNull KiiACLEntry entry) {
        entry.setParent(this.mParent);
        this.entrySet.add(entry);
    }

    public void removeACLEntry(@NonNull KiiACLEntry entry) {
        entry.setParent(this.mParent);
        this.entrySet.remove(entry);
    }

    @WorkerThread
    @NonNull
    public Set<KiiACLEntry> listACLEntries() throws ACLOperationException {
        HashSet<KiiACLEntry> entries = new HashSet<KiiACLEntry>();
        String id = KiiACLEntry.getParentId(this.mParent);
        if (TextUtils.isEmpty((CharSequence)id)) {
            return entries;
        }
        ApiResponse resp = null;
        try {
            String aclUrl = Utils.path(this.getParentUFPUrl(), "acl");
            HttpGet request = new HttpGet(aclUrl);
            KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
            request.setHeader("X-Kii-AppID", Kii.getAppId());
            request.setHeader("X-Kii-AppKey", Kii.getAppKey());
            request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
            resp = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new ACLOperationException(e.getMessage(), e, null);
        }
        catch (AppException e) {
            throw new ACLOperationException(e.getMessage(), e, null);
        }
        if (resp.status == 200) {
            try {
                JSONObject respObj = new JSONObject(resp.body);
                this.parseListResponse(respObj, entries);
            }
            catch (JSONException e) {
                throw new IllegalKiiBaseObjectFormatException(resp.body);
            }
        }
        return entries;
    }

    private KiiSubject getSubjetFromUserID(String userID) {
        if ("ANONYMOUS_USER".equalsIgnoreCase(userID)) {
            return KiiAnonymousUser.create();
        }
        if ("ANY_AUTHENTICATED_USER".equalsIgnoreCase(userID)) {
            return KiiAnyAuthenticatedUser.create();
        }
        return KiiUser.userWithID(userID);
    }

    private String getParentUFPUrl() throws IOException, BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException {
        if (this.mParent instanceof KiiObject) {
            return ((KiiObject)this.mParent).getUFPUri();
        }
        if (this.mParent instanceof KiiBucket) {
            return ((KiiBucket)this.mParent).getBucketUrl();
        }
        if (this.mParent instanceof KiiTopic) {
            return ((KiiTopic)this.mParent).getUFEUri();
        }
        throw new RuntimeException("Unexpected error." + this.mParent.getClass().getCanonicalName());
    }

    public int listACLEntries(@NonNull KiiACLCallBack callback) {
        KiiACLTask task = new KiiACLTask(KiiACLTask.TaskType.LISTENTRY, this, callback);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    static String getActionString(Action action) {
        return action.toString();
    }

    private void assertObjectAction(Action action) {
        if (!(action instanceof ObjectAction)) {
            throw new IllegalArgumentException("Action is not appicable for object!");
        }
    }

    private void assertBucketAction(Action action) {
        if (!(action instanceof BucketAction)) {
            throw new IllegalArgumentException("Action is not appicable for bucket!");
        }
    }

    private void assertTopicAction(Action action) {
        if (!(action instanceof TopicAction)) {
            throw new IllegalArgumentException("Action is not appicable for topic!");
        }
    }

    private Action getAction(ActionName actionName) {
        switch (actionName) {
            case CREATE_OBJECTS_IN_BUCKET: {
                return BucketAction.CREATE_OBJECTS_IN_BUCKET;
            }
            case QUERY_OBJECTS_IN_BUCKET: {
                return BucketAction.QUERY_OBJECTS_IN_BUCKET;
            }
            case READ_OBJECTS_IN_BUCKET: {
                return BucketAction.READ_OBJECTS_IN_BUCKET;
            }
            case DROP_BUCKET_WITH_ALL_CONTENT: {
                return BucketAction.DROP_BUCKET_WITH_ALL_CONTENT;
            }
            case READ_EXISTING_OBJECT: {
                return ObjectAction.READ_EXISTING_OBJECT;
            }
            case WRITE_EXISTING_OBJECT: {
                return ObjectAction.WRITE_EXISTING_OBJECT;
            }
            case SUBSCRIBE_TO_TOPIC: {
                return TopicAction.SUBSCRIBE_TO_TOPIC;
            }
            case SEND_MESSAGE_TO_TOPIC: {
                return TopicAction.SEND_MESSAGE_TO_TOPIC;
            }
        }
        throw new RuntimeException("Unexpected error.");
    }

    private void parseListResponse(JSONObject json, HashSet<KiiACLEntry> entries) throws JSONException {
        for (ActionName as : ActionName.values()) {
            JSONArray whiteList = json.optJSONArray(as.toString());
            if (whiteList == null) continue;
            for (int i = 0; i < whiteList.length(); ++i) {
                KiiSubject sbj;
                Action action = this.getAction(as);
                JSONObject entry = whiteList.getJSONObject(i);
                KiiACLEntry kae = null;
                if (entry.has("groupID")) {
                    String gid = entry.getString("groupID");
                    kae = new KiiACLEntry(this.mParent, KiiGroup.groupWithID(gid), action, true);
                    entries.add(kae);
                    continue;
                }
                if (entry.has("userID")) {
                    String uid = entry.getString("userID");
                    sbj = this.getSubjetFromUserID(uid);
                    kae = new KiiACLEntry(this.mParent, sbj, action, true);
                    entries.add(kae);
                    continue;
                }
                if (!entry.has("thingID")) continue;
                String tid = entry.getString("thingID");
                sbj = KiiThing.thingWithID(tid);
                kae = new KiiACLEntry(this.mParent, sbj, action, true);
                entries.add(kae);
            }
        }
    }

    static enum ActionName {
        CREATE_OBJECTS_IN_BUCKET,
        QUERY_OBJECTS_IN_BUCKET,
        DROP_BUCKET_WITH_ALL_CONTENT,
        READ_OBJECTS_IN_BUCKET,
        READ_EXISTING_OBJECT,
        WRITE_EXISTING_OBJECT,
        SUBSCRIBE_TO_TOPIC,
        SEND_MESSAGE_TO_TOPIC;

    }

    static enum ACLOperation {
        GRANT,
        REVOKE;

    }

    public static enum TopicAction implements Action
    {
        SUBSCRIBE_TO_TOPIC,
        SEND_MESSAGE_TO_TOPIC;

    }

    public static enum ObjectAction implements Action
    {
        READ_EXISTING_OBJECT,
        WRITE_EXISTING_OBJECT;

    }

    public static enum BucketAction implements Action
    {
        QUERY_OBJECTS_IN_BUCKET,
        CREATE_OBJECTS_IN_BUCKET,
        DROP_BUCKET_WITH_ALL_CONTENT,
        READ_OBJECTS_IN_BUCKET;

    }

    public static interface Action {
    }
}

