/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.analytics._KiiAnalyticsBridge;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.async.executor.KiiUncancelabeTask;
import com.kii.cloud.async.executor.TaskMap;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiCallback;
import com.kii.cloud.storage.KiiEncryptedBucket;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiListResult;
import com.kii.cloud.storage.KiiServerCodeEntry;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.UserCredentials;
import com.kii.cloud.storage._KiiInstanceManager;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.photocolle._PhotoColleInternalBridge;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderFactory;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderFactory;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Kii {
    static final String TAG = "KiiClient";
    private static final String SAVESTATE_KEY_PREFIX = "com.kii.cloud.storage.";
    private static final String SAVESTATE_BUNDLE_KEY = "com.kii.cloud.storage.state";
    private static boolean enableAnalytics = false;
    private long mAccessTokenExpiresIn = 0L;
    private Context mAppContext;
    private String mAppId;
    private String mAppKey;
    private KiiUser mLoginUser;
    private String mBaseURL;
    private Site mSite;
    private String mKiiAppsBaseURL;
    private static Kii mClient = null;

    static Kii getInstance() {
        return mClient;
    }

    static void clearInstance() {
        mClient = null;
    }

    @Nullable
    public static String getBaseURL() {
        if (mClient == null) {
            return null;
        }
        return Kii.mClient.mBaseURL;
    }

    @Nullable
    public static Site getSite() {
        if (mClient == null) {
            return null;
        }
        return Kii.mClient.mSite;
    }

    public static long getAccessTokenExpiration() {
        if (mClient == null) {
            throw new IllegalStateException("SDK has not initialized");
        }
        return Kii.mClient.mAccessTokenExpiresIn;
    }

    @Nullable
    public static String getAppId() {
        if (mClient == null) {
            return null;
        }
        return Kii.mClient.mAppId;
    }

    @Nullable
    public static String getAppKey() {
        if (mClient == null) {
            return null;
        }
        return Kii.mClient.mAppKey;
    }

    @Nullable
    public static String getKiiAppsBaseURL() {
        if (mClient == null) {
            return null;
        }
        return Kii.mClient.mKiiAppsBaseURL;
    }

    private String createKiiAppsBaseURL(String appId, String serverUrl) {
        String siteName = null;
        Uri baseUri = Uri.parse((String)serverUrl);
        if (Site.JP.getHost().equals(baseUri.getHost())) {
            siteName = Site.JP.getSiteName();
        } else if (Site.US.getHost().equals(baseUri.getHost())) {
            siteName = Site.US.getSiteName();
        } else if (Site.CN.getHost().equals(baseUri.getHost())) {
            siteName = Site.CN.getSiteName();
        } else if (Site.SG.getHost().equals(baseUri.getHost())) {
            siteName = Site.SG.getSiteName();
        } else if (Site.CN3.getHost().equals(baseUri.getHost())) {
            siteName = Site.CN3.getSiteName();
        } else if (Site.EU.getHost().equals(baseUri.getHost())) {
            siteName = Site.EU.getSiteName();
        }
        if (siteName == null) {
            return null;
        }
        return "https://" + appId + "." + siteName + ".kiiapps.com/api";
    }

    public static boolean cancelTask(int token) {
        Runnable r = TaskMap.getInstance().get(token);
        return KiiTaskExecutor.getInstance().cancel(r);
    }

    void setCurrentUser(KiiUser user) {
        Utils.checkInitialize(false);
        Kii.mClient.mLoginUser = user;
    }

    private Kii(Context context, Site site, String appId, String appKey, String serverUrl) {
        if (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)appKey) || TextUtils.isEmpty((CharSequence)serverUrl)) {
            throw new IllegalArgumentException("AppId/AppKey/ServerUrl can not be null.");
        }
        if (context != null) {
            this.mAppContext = context.getApplicationContext();
        }
        this.mSite = site;
        this.mAppId = appId;
        this.mAppKey = appKey;
        this.mBaseURL = serverUrl;
        this.mKiiAppsBaseURL = this.createKiiAppsBaseURL(appId, serverUrl);
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String appKey) {
        Kii.initialize(appId, appKey, Site.US.getBaseUri());
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String appKey, @NonNull Site site) {
        Kii.newKii(null, site, appId, appKey, site.getBaseUri());
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String appKey, @NonNull String serverUrl) {
        Kii.newKii(null, null, appId, appKey, serverUrl);
    }

    public static synchronized void initialize(@Nullable Context context, @NonNull String appId, @NonNull String appKey) {
        Kii.initialize(context, appId, appKey, Site.US.getBaseUri());
    }

    public static synchronized void initialize(@Nullable Context context, @NonNull String appId, @NonNull String appKey, @NonNull Site site) {
        Kii.newKii(context, null, appId, appKey, site.getBaseUri());
    }

    public static synchronized void initialize(@Nullable Context context, @NonNull String appId, @NonNull String appKey, @NonNull String serverUrl) {
        Kii.newKii(context, null, appId, appKey, serverUrl);
    }

    public static synchronized void initialize(@Nullable Context context, @NonNull String appId, @NonNull String appKey, boolean enableKiiAnalytics) {
        Kii.initialize(context, appId, appKey, Site.US.getBaseUri(), enableKiiAnalytics);
    }

    public static synchronized void initialize(@Nullable Context context, @NonNull String appId, @NonNull String appKey, @NonNull Site site, boolean enableKiiAnalytics) {
        Kii.initialize(context, appId, appKey, site.getBaseUri(), enableKiiAnalytics);
    }

    public static synchronized void initialize(@NonNull Context context, @NonNull String appId, @NonNull String appKey, @NonNull String serverUrl, boolean enableKiiAnalytics) {
        Kii.initialize(context, appId, appKey, serverUrl);
        if (!enableAnalytics && enableKiiAnalytics) {
            enableAnalytics = enableKiiAnalytics;
            _KiiAnalyticsBridge.initialize(context, appId, appKey, serverUrl);
        }
    }

    private static synchronized void newKii(Context context, Site site, String appId, String appKey, String serverUrl) {
        if (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)appKey) || TextUtils.isEmpty((CharSequence)serverUrl)) {
            throw new IllegalArgumentException("AppId/AppKey/ServerUrl can not be null.");
        }
        if (mClient != null && appId.equals(Kii.getAppId()) && appKey.equals(Kii.getAppKey()) && serverUrl.equals(Kii.getBaseURL())) {
            return;
        }
        if (site == null) {
            site = Site.fromBaseUri(serverUrl);
        }
        mClient = new Kii(context, site, appId, appKey, serverUrl);
    }

    public static boolean getAnalyticsEnabled() {
        return enableAnalytics;
    }

    public static synchronized void setAccessTokenExpiration(long expiresIn) {
        if (mClient == null) {
            throw new IllegalStateException("SDK has not initialized.");
        }
        if (expiresIn < 0L) {
            throw new IllegalArgumentException("expiresIn can not be negative.");
        }
        Kii.mClient.mAccessTokenExpiresIn = expiresIn;
    }

    @NonNull
    public static String getSDKVersion() {
        return "2.4.14";
    }

    static KiiUser getCurrentUser() {
        if (mClient == null) {
            return null;
        }
        return Kii.mClient.mLoginUser;
    }

    static boolean isLoggedIn() {
        if (mClient == null) {
            return false;
        }
        return Kii.mClient.mLoginUser != null;
    }

    static void logOut() {
        Utils.checkInitialize(false);
        if (Kii.mClient.mLoginUser != null) {
            Kii.mClient.mLoginUser.clearAccessToken();
        }
        Kii.mClient.mLoginUser = null;
        KiiUploaderFactory.discardMap();
        KiiDownloaderFactory.discardMap();
        Kii.clearStoredUserCredentials();
        _PhotoColleInternalBridge.clearPhotoColleInstance();
    }

    @Nullable
    public static KiiUser user() {
        return KiiUser.getCurrentUser();
    }

    @NonNull
    public static KiiBucket bucket(@NonNull String bucketName) {
        return new KiiBucket(null, bucketName);
    }

    @NonNull
    public static KiiEncryptedBucket encryptedBucket(@NonNull String bucketName) {
        return new KiiEncryptedBucket(null, bucketName);
    }

    @NonNull
    public static String getBuildNumber() {
        return "${env.SVN_REVISION}";
    }

    @NonNull
    public static KiiGroup group(@Nullable String groupName, @Nullable List<KiiUser> groupMembers) {
        return new KiiGroup(groupName, groupMembers);
    }

    @NonNull
    public static KiiGroup group(@Nullable String groupName) {
        return new KiiGroup(groupName, null);
    }

    @NonNull
    public static KiiSocialConnect socialConnect(@NonNull KiiSocialConnect.SocialNetwork network) {
        if (network == null) {
            throw new IllegalArgumentException("SocialNetwork is null");
        }
        switch (network) {
            case FACEBOOK: {
                return _KiiInstanceManager.getInstance().getFacebookConnect();
            }
            case RENREN: {
                throw new UnsupportedOperationException("Not implemented!");
            }
            case TWITTER: {
                return _KiiInstanceManager.getInstance().getTwitterConnect();
            }
            case PHOTOCOLLE: {
                return _KiiInstanceManager.getInstance().getPhotoColleSocialConnect();
            }
            case SOCIALNETWORK_CONNECTOR: {
                return _KiiInstanceManager.getInstance().getSocialNetworkConnect();
            }
            case QQ: {
                return _KiiInstanceManager.getInstance().getQQConnect();
            }
        }
        throw new RuntimeException("Invalid SocialNetwork");
    }

    @NonNull
    public static KiiTopic topic(@NonNull String name) {
        KiiTopic topic = new KiiTopic(null, name);
        return topic;
    }

    @NonNull
    public static KiiListResult<KiiTopic> listTopics() throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        return Kii.listTopics((String)null);
    }

    @WorkerThread
    @NonNull
    public static KiiListResult<KiiTopic> listTopics(@Nullable String paginationKey) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        String topicUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "topics");
        if (!Utils.isEmpty(paginationKey)) {
            topicUrl = topicUrl + "?paginationKey=" + URLEncoder.encode(paginationKey, "UTF-8");
        }
        HttpGet request = new HttpGet(topicUrl);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject json = new JSONObject(response.body);
            String newPaginationKey = null;
            if (json.has("paginationKey")) {
                newPaginationKey = json.getString("paginationKey");
            }
            JSONArray array = json.getJSONArray("topics");
            ArrayList<KiiTopic> topics = new ArrayList<KiiTopic>();
            for (int i = 0; i < array.length(); ++i) {
                topics.add(Kii.topic(array.getJSONObject(i).getString("topicID")));
            }
            return new KiiListResult<KiiTopic>(topics, newPaginationKey);
        }
        catch (JSONException e) {
            Log.e(TAG, e.getMessage());
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public static void listTopics(@NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        Kii.listTopics(null, callback);
    }

    public static void listTopics(final @Nullable String paginationKey, final @NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiListResult<KiiTopic> result = null;

            @Override
            public void run() {
                try {
                    this.result = Kii.listTopics(paginationKey);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.result, this.getException());
            }
        });
    }

    @NonNull
    public static KiiServerCodeEntry serverCodeEntry(@NonNull String entryName) {
        if (TextUtils.isEmpty((CharSequence)entryName)) {
            throw new IllegalArgumentException("entryName is null or empty.");
        }
        if (!KiiServerCodeEntry.isValidEntryName(entryName)) {
            throw new IllegalArgumentException("entryName is invalid.");
        }
        return new KiiServerCodeEntry(entryName);
    }

    @NonNull
    public static KiiServerCodeEntry serverCodeEntry(@NonNull String entryName, @NonNull String version) {
        if (TextUtils.isEmpty((CharSequence)entryName)) {
            throw new IllegalArgumentException("entryName is null or empty.");
        }
        if (!KiiServerCodeEntry.isValidEntryName(entryName)) {
            throw new IllegalArgumentException("entryName is invalid.");
        }
        if (TextUtils.isEmpty((CharSequence)version)) {
            throw new IllegalArgumentException("version is null or empty.");
        }
        return new KiiServerCodeEntry(entryName, version);
    }

    public static void onSaveInstanceState(@Nullable Bundle outState) {
        if (outState == null || mClient == null) {
            return;
        }
        Bundle state = new Bundle();
        state.putString("appId", Kii.getAppId());
        state.putString("appKey", Kii.getAppKey());
        state.putString("serverUrl", Kii.getBaseURL());
        state.putLong("accessTokenExpiresIn", Kii.getAccessTokenExpiration());
        state.putParcelable("kiiUser", (Parcelable)KiiUser.getCurrentUser());
        state.putBundle("socialConnectBundle", _KiiInstanceManager.getInstance().getParcelableBundle());
        outState.putBundle(SAVESTATE_BUNDLE_KEY, state);
    }

    public static void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        Kii.onRestoreInstanceState(null, savedInstanceState);
    }

    public static void onRestoreInstanceState(@Nullable Context context, @Nullable Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        Bundle state = savedInstanceState.getBundle(SAVESTATE_BUNDLE_KEY);
        if (state == null) {
            return;
        }
        if (state.containsKey("appId") && state.containsKey("appKey") && state.containsKey("serverUrl")) {
            String appId = state.getString("appId");
            String appKey = state.getString("appKey");
            String serverUrl = state.getString("serverUrl");
            long tokenExpiresIn = state.getLong("accessTokenExpiresIn");
            if (appId != null && appKey != null && serverUrl != null) {
                Kii.initialize(context, appId, appKey, serverUrl);
            }
            Kii.mClient.mAccessTokenExpiresIn = tokenExpiresIn;
            KiiUser user = (KiiUser)state.getParcelable("kiiUser");
            if (user != null) {
                mClient.setCurrentUser(user);
            }
            if (state.containsKey("socialConnectBundle")) {
                _KiiInstanceManager.getInstance().setParcelableBundle(state.getBundle("socialConnectBundle"));
            }
        }
    }

    static String getRefreshToken() {
        UserCredentials userCredentials;
        if (!Kii.isLoggedIn()) {
            return null;
        }
        String refreshToken = null;
        refreshToken = KiiUser.getCurrentUser().getRefreshToken();
        if (refreshToken == null && (userCredentials = Kii.loadUserCredentials()) != null && Kii.getBaseURL().equals(userCredentials.getBaseURL()) && Kii.getAppId().equals(userCredentials.getAppId())) {
            refreshToken = userCredentials.getRefreshToken();
        }
        return refreshToken;
    }

    static void clearStoredUserCredentials() {
        SharedPreferences preferences = Kii.getSharedPreferences();
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.remove("user_credentials");
            editor.apply();
        }
    }

    static void storeUserCredentials(UserCredentials credentials) {
        SharedPreferences preferences = Kii.getSharedPreferences();
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("user_credentials", credentials.toJsonString());
            editor.apply();
        }
    }

    static UserCredentials loadUserCredentials() {
        SharedPreferences preferences = Kii.getSharedPreferences();
        if (preferences == null) {
            return null;
        }
        UserCredentials userCredentials = UserCredentials.fromJsonString(preferences.getString("user_credentials", null));
        return userCredentials;
    }

    private static SharedPreferences getSharedPreferences() {
        if (Kii.getInstance().mAppContext != null) {
            return Kii.getInstance().mAppContext.getSharedPreferences("com.kii.cloud.preferences", 0);
        }
        return null;
    }

    static boolean hasApplicationContext() {
        return Kii.getInstance().mAppContext != null;
    }

    public static enum Site {
        JP("https://api-jp.kii.com/api", "jp"),
        US("https://api.kii.com/api", "us"),
        CN("https://api-cn2.kii.com/api", "cn"),
        SG("https://api-sg.kii.com/api", "sg"),
        CN3("https://api-cn3.kii.com/api", "cn3"),
        EU("https://api-eu.kii.com/api", "eu");

        private String mBaseUri = null;
        private String mSiteName = null;

        private Site(String baseUri, String siteName) {
            this.mBaseUri = baseUri;
            this.mSiteName = siteName;
        }

        private String getBaseUri() {
            return this.mBaseUri;
        }

        private String getSiteName() {
            return this.mSiteName;
        }

        private String getHost() {
            Uri baseUri = Uri.parse((String)this.mBaseUri);
            return baseUri.getHost();
        }

        public static Site fromBaseUri(String baseUri) {
            for (Site site : Site.values()) {
                if (!site.getBaseUri().equals(baseUri)) continue;
                return site;
            }
            return null;
        }
    }
}

