/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;

public class GeoPoint {
    private double latitude;
    private double longitude;

    public GeoPoint(double latitude, double longitude) {
        if (!this.inRange(-90.0, 90.0, latitude)) {
            throw new IllegalArgumentException("latitude is out of range. should be in -90 to +90");
        }
        if (!this.inRange(-180.0, 180.0, longitude)) {
            throw new IllegalArgumentException("longitude format is out of range. should be in -180 to +180");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @NonNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        try {
            json.put("_type", (Object)"point");
            json.put("lat", this.latitude);
            json.put("lon", this.longitude);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    static GeoPoint createFromJSON(JSONObject json) throws JSONException {
        double lat = json.getDouble("lat");
        double lon = json.getDouble("lon");
        return new GeoPoint(lat, lon);
    }

    private boolean inRange(double min, double max, double number) {
        return !Double.isNaN(number) && number > min && number < max;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(@NonNull Object rh) {
        if (!(rh instanceof GeoPoint)) {
            return false;
        }
        GeoPoint gpRh = (GeoPoint)rh;
        double latRh = gpRh.getLatitude();
        double lonRh = gpRh.getLongitude();
        return this.getLatitude() == latRh && this.getLongitude() == lonRh;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getLatitude());
        return (int)(bits ^= Double.doubleToLongBits(this.getLongitude()) * 31L) ^ (int)(bits >> 32);
    }

    @NonNull
    public String toString() {
        return this.toJSON().toString();
    }
}

