/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.kii.cloud.async.executor.KiiPushInstallationTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.storage.KiiPushInstallation;
import com.kii.cloud.storage.callback.KiiPushCallBack;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import java.io.IOException;

public class GCMPushInstallation
extends KiiPushInstallation {
    GCMPushInstallation() {
    }

    GCMPushInstallation(boolean development) {
        super(development);
    }

    @Override
    @WorkerThread
    public void install(@NonNull String registrationId) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        super.install(registrationId, KiiPushInstallation.PushBackend.GCM);
    }

    @Override
    public int install(@NonNull String registrationId, @Nullable KiiPushCallBack callback) {
        KiiPushInstallationTask task = new KiiPushInstallationTask(this, registrationId, callback, KiiPushInstallationTask.TaskType.INSTALL);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }

    @Override
    @WorkerThread
    public void uninstall(@NonNull String registrationId) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        super.uninstall(registrationId, KiiPushInstallation.PushBackend.GCM);
    }

    @Override
    public int uninstall(@NonNull String registrationId, @Nullable KiiPushCallBack callback) {
        KiiPushInstallationTask task = new KiiPushInstallationTask(this, registrationId, callback, KiiPushInstallationTask.TaskType.UNINSTALL);
        KiiTaskExecutor.getInstance().execute(task);
        return task.getTaskId();
    }
}

