/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiPushMessage;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class GCMMessage {
    private KiiPushMessage.Data data;
    private JSONObject parent;

    GCMMessage(KiiPushMessage.Data data, JSONObject parent) {
        this.parent = parent;
        this.data = data;
    }

    @NonNull
    public String toString() {
        return this.toJSON().toString();
    }

    @NonNull
    public JSONObject toJSON() {
        JSONObject ret = null;
        try {
            ret = new JSONObject(this.parent.toString());
            if (this.data != null) {
                ret.put("data", (Object)this.data.toJSONObject());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return ret;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        KiiPushMessage.Data data;
        JSONObject parent = new JSONObject();

        @NonNull
        public GCMMessage build() {
            if (this.data != null && !GCMData.isValidGCMData(this.data)) {
                throw new IllegalStateException("Data contains key that is GCM reserve word");
            }
            GCMMessage message = new GCMMessage(this.data, this.parent);
            return message;
        }

        Builder() {
            try {
                this.parent.put("enabled", true);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
        }

        @NonNull
        public Builder enable(boolean enabled) {
            try {
                this.parent.put("enabled", enabled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder withData(@Nullable KiiPushMessage.Data data) {
            this.data = data;
            return this;
        }

        @NonNull
        public Builder withGCMData(@Nullable GCMData data) {
            this.data = data;
            return this;
        }

        @NonNull
        public Builder withRestrictedPackageName(@Nullable String restrictedPackageName) {
            try {
                this.parent.put("restrictedPackageName", (Object)restrictedPackageName);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder withTimeToLive(int timeToLive) {
            try {
                this.parent.put("timeToLive", timeToLive);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder withCollapseKey(@Nullable String collapseKey) {
            try {
                this.parent.put("collapseKey", (Object)collapseKey);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder delayWhileIdle(boolean delayWhileIdle) {
            try {
                this.parent.put("delayWhileIdle", delayWhileIdle);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }
    }

    public static class GCMData
    extends KiiPushMessage.Data {
        static final String[] GCM_RESERVE_KEYS = new String[]{"from", "registration_ids", "collapse_key", "data", "delay_while_idle", "time_to_live", "restricted_package_name", "dry_run"};

        @Override
        public void put(@NonNull String key, int value) {
            super.put(key, value);
        }

        @Override
        public void put(@NonNull String key, long value) {
            super.put(key, value);
        }

        @Override
        public void put(@NonNull String key, double value) {
            super.put(key, value);
        }

        @Override
        public void put(@NonNull String key, boolean value) {
            super.put(key, value);
        }

        @Override
        public void put(@NonNull String key, @Nullable String value) {
            super.put(key, value);
        }

        public static boolean isValidKey(@Nullable String key) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                return false;
            }
            if (key.startsWith("google")) {
                return false;
            }
            for (String reserveKey : GCM_RESERVE_KEYS) {
                if (!reserveKey.equalsIgnoreCase(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean _isValidKey(String key) {
            return GCMData.isValidKey(key);
        }

        static boolean isValidGCMData(KiiPushMessage.Data data) {
            JSONObject json = data.toJSONObject();
            Iterator it = json.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.startsWith("google")) {
                    return false;
                }
                for (String reserveKey : GCM_RESERVE_KEYS) {
                    if (!reserveKey.equalsIgnoreCase(key)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

