/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiPushMessage;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.callback.KiiTopicCallBack;

public class KiiTopicTask
implements KiiTask,
Runnable {
    private TaskType type;
    private KiiTopicCallBack callback;
    private KiiTopic target;
    private KiiPushMessage message;
    private Exception e;
    int taskId;

    public KiiTopicTask(@NonNull TaskType type, @NonNull KiiTopic target, @NonNull KiiTopicCallBack callback, @Nullable KiiPushMessage message) {
        this.type = type;
        this.callback = callback;
        this.target = target;
        this.message = message;
    }

    @Override
    public void run() {
        switch (this.type) {
            case SAVE: {
                this.doSave();
                break;
            }
            case SENDMESSAGE: {
                this.doSendMessage();
                break;
            }
            case DELETE: {
                this.doDelete();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
    }

    private void doSave() {
        try {
            this.target.save();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doDelete() {
        try {
            this.target.delete();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doSendMessage() {
        try {
            this.target.sendMessage(this.message);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        switch (this.type) {
            case SAVE: {
                this.callback.onSaveCompleted(this.taskId, this.target, this.e);
                break;
            }
            case SENDMESSAGE: {
                this.callback.onSendMessageCompleted(this.taskId, this.target, this.message, this.e);
                break;
            }
            case DELETE: {
                this.callback.onDeleteCompleted(this.taskId, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
    }

    @Override
    public void executeStartCallback() {
        this.callback.onTaskStart(this.taskId);
    }

    @Override
    public void executeCancelCallback() {
        this.callback.onTaskCancel(this.taskId);
    }

    public static enum TaskType {
        SAVE,
        SENDMESSAGE,
        DELETE;

    }
}

