/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiFutureTask;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.async.executor.TaskMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class KiiTaskExecutor
extends ThreadPoolExecutor {
    private static InternalHandler handler = new InternalHandler(Looper.getMainLooper());

    @Override
    public void execute(@NonNull Runnable command) {
        KiiFutureTask fTask = new KiiFutureTask(command, null);
        int id = TaskMap.getInstance().add(fTask);
        KiiTask kTask = (KiiTask)((Object)command);
        kTask.setTaskId(id);
        super.execute(fTask);
    }

    @NonNull
    public static synchronized KiiTaskExecutor getInstance() {
        return InnerInit.getOuterInstance();
    }

    private KiiTaskExecutor() {
        super(5, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        handler.getLooper();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        KiiFutureTask future = (KiiFutureTask)r;
        Message msg = handler.obtainMessage();
        msg.what = 0;
        msg.obj = future;
        msg.sendToTarget();
        TaskMap.getInstance().remove(future.getTaskId());
        super.afterExecute(r, t);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        KiiFutureTask future = (KiiFutureTask)r;
        Message msg = handler.obtainMessage();
        msg.what = 1;
        msg.obj = future;
        msg.sendToTarget();
        super.beforeExecute(t, r);
    }

    public boolean cancel(@Nullable Runnable r) {
        KiiFutureTask future = (KiiFutureTask)r;
        if (r == null) {
            return false;
        }
        boolean suc = future.cancel(true);
        TaskMap.getInstance().remove(future.getTaskId());
        if (suc) {
            Message msg = handler.obtainMessage();
            msg.what = 2;
            msg.obj = future;
            msg.sendToTarget();
        }
        return suc;
    }

    static class InternalHandler
    extends Handler {
        public static final int COMPLETED = 0;
        public static final int STARTED = 1;
        public static final int CANCELLED = 2;

        public InternalHandler(Looper mainLooper) {
            super(mainLooper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            KiiFutureTask kTask = (KiiFutureTask)msg.obj;
            switch (msg.what) {
                case 0: {
                    kTask.executeCompletionCallback();
                    break;
                }
                case 1: {
                    kTask.executeStartCallback();
                    break;
                }
                case 2: {
                    kTask.executeCancelCallback();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message id");
                }
            }
        }
    }

    private static class InnerInit {
        private static KiiTaskExecutor OUTER_INSTANCE;

        private InnerInit() {
        }

        private static synchronized KiiTaskExecutor getOuterInstance() {
            if (OUTER_INSTANCE == null) {
                OUTER_INSTANCE = new KiiTaskExecutor();
            }
            return OUTER_INSTANCE;
        }
    }
}

