/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiPushInstallation;
import com.kii.cloud.storage.callback.KiiPushCallBack;

public class KiiPushInstallationTask
implements KiiTask,
Runnable {
    KiiPushCallBack callback;
    KiiPushInstallation target;
    String regId;
    Exception e;
    int taskId;
    TaskType type;

    public KiiPushInstallationTask(@NonNull KiiPushInstallation target, @NonNull String regId, @Nullable KiiPushCallBack callback, @NonNull TaskType type) {
        this.callback = callback;
        this.target = target;
        this.regId = regId;
        this.type = type;
    }

    @Override
    public void run() {
        switch (this.type) {
            case INSTALL: {
                this.doInstall();
                break;
            }
            case UNINSTALL: {
                this.doUninstall();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
    }

    private void doInstall() {
        try {
            this.target.install(this.regId);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doUninstall() {
        try {
            this.target.uninstall(this.regId);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        if (this.callback == null) {
            return;
        }
        switch (this.type) {
            case INSTALL: {
                this.callback.onInstallCompleted(this.taskId, this.e);
                break;
            }
            case UNINSTALL: {
                this.callback.onUninstallCompleted(this.taskId, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public void executeStartCallback() {
        if (this.callback == null) {
            return;
        }
        this.callback.onTaskStart(this.taskId);
    }

    @Override
    public void executeCancelCallback() {
        if (this.callback == null) {
            return;
        }
        this.callback.onTaskCancel(this.taskId);
    }

    public static enum TaskType {
        INSTALL,
        UNINSTALL;

    }
}

