/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.callback.KiiObjectPublishCallback;

public class KiiObjectPublishTask
implements KiiTask,
Runnable {
    ObjectPublishTaskType type;
    KiiObjectPublishCallback callback;
    KiiObject target;
    Exception e;
    Object[] arguments;
    String publishUrl;
    int taskId;

    public KiiObjectPublishTask(@NonNull ObjectPublishTaskType type, @NonNull KiiObject target, @Nullable KiiObjectPublishCallback callback, Object ... arguments) {
        this.type = type;
        this.callback = callback;
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public void run() {
        switch (this.type) {
            case PUBLISH_BODY: {
                this.doPublishBody();
                break;
            }
            case PUBLISH_BODY_EXPIRES_AT: {
                this.doPublishBodyExpiresAt();
                break;
            }
            case PUBLISH_BODY_EXPIRES_IN: {
                this.doPublishBodyExpiresIn();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    private void doPublishBody() {
        try {
            this.publishUrl = this.target.publishBody();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doPublishBodyExpiresAt() {
        try {
            if (this.arguments == null || this.arguments.length != 1 || !(this.arguments[0] instanceof Long)) {
                throw new RuntimeException("Unexpected error");
            }
            long expiresAt = (Long)this.arguments[0];
            this.publishUrl = this.target.publishBodyExpiresAt(expiresAt);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doPublishBodyExpiresIn() {
        try {
            if (this.arguments == null || this.arguments.length != 1 || !(this.arguments[0] instanceof Integer)) {
                throw new RuntimeException("Unexpected error");
            }
            int expiresIn = (Integer)this.arguments[0];
            this.publishUrl = this.target.publishBodyExpiresIn(expiresIn);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        if (this.callback == null) {
            return;
        }
        switch (this.type) {
            case PUBLISH_BODY: 
            case PUBLISH_BODY_EXPIRES_AT: 
            case PUBLISH_BODY_EXPIRES_IN: {
                this.callback.onPublishCompleted(this.publishUrl, this.target, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public void executeStartCallback() {
    }

    @Override
    public void executeCancelCallback() {
    }

    public static enum ObjectPublishTaskType {
        PUBLISH_BODY,
        PUBLISH_BODY_EXPIRES_AT,
        PUBLISH_BODY_EXPIRES_IN;

    }
}

