/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.impl.async;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.kii.cloud.analytics.WrongThreadException;
import com.kii.cloud.analytics.impl.async.KiiFutureTask;
import com.kii.cloud.analytics.impl.async.KiiTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class KiiTaskExecutor
extends ThreadPoolExecutor {
    private static final String WRONG_THREAD_MESSAGE = "AsyncTask is called from sub thread. Please call from main thread.";
    private static InternalHandler handler = new InternalHandler();
    static KiiTaskExecutor INSTANCE = null;

    @Override
    public void execute(@NonNull Runnable command) {
        KiiFutureTask fTask = new KiiFutureTask(command, null);
        super.execute(fTask);
    }

    @NonNull
    public static synchronized KiiTaskExecutor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KiiTaskExecutor();
        }
        return INSTANCE;
    }

    private KiiTaskExecutor() {
        super(5, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        KiiTaskExecutor.checkMyLooper();
        handler.getLooper();
    }

    private static void checkMyLooper() {
        if (Looper.myLooper() == null) {
            throw new WrongThreadException(WRONG_THREAD_MESSAGE);
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new WrongThreadException(WRONG_THREAD_MESSAGE);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        KiiFutureTask future = (KiiFutureTask)r;
        Message msg = handler.obtainMessage();
        msg.what = 0;
        msg.obj = future;
        msg.sendToTarget();
        super.afterExecute(r, t);
    }

    static class InternalHandler
    extends Handler {
        public static final int COMPLETED = 0;

        InternalHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            KiiTask kTask = (KiiTask)msg.obj;
            switch (msg.what) {
                case 0: {
                    kTask.executeCompletionCallback();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message id");
                }
            }
        }
    }
}

