/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.impl.async;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.analytics.KiiEvent;
import com.kii.cloud.analytics.callback.KiiEventCallback;
import com.kii.cloud.analytics.impl.async.KiiTask;

public class EventTask
implements Runnable,
KiiTask {
    private Exception e;
    private KiiEventCallback callback;
    private KiiEvent target;
    private TaskType type;

    public EventTask(@NonNull TaskType type, @NonNull KiiEvent target, @NonNull KiiEventCallback callback) {
        this.type = type;
        this.target = target;
        this.callback = callback;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        switch (this.type) {
            case UPLOAD: {
                this.callback.onUploadCompleted(this.target, this.e);
                break;
            }
            case PUSH: {
                this.callback.onPushCompleted(this.target, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
    }

    @Override
    public void run() {
        switch (this.type) {
            case UPLOAD: {
                this.doUpload();
                break;
            }
            case PUSH: {
                this.doPush();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
    }

    private void doUpload() {
        try {
            this.target.upload();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doPush() {
        try {
            this.target.push();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    public static enum TaskType {
        UPLOAD,
        PUSH;

    }
}

