/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.impl;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.kii.cloud.analytics.KiiAnalytics;
import com.kii.cloud.analytics.KiiEvent;
import com.kii.cloud.analytics.impl._KiiSessionCallback;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class _KiiSession {
    private static final long DEFAULT_CONTINUE_DURATION = 10000L;
    public static long continueDuration = 10000L;
    private static SessionEventHandler handler;
    private static HashSet<Integer> IDSet;
    private static _KiiSessionCallback callback;
    private static final String SESSION_EVENT_TYPE = "KiiSession";
    private static final String KII_SDK_PLATFORM = "Android";
    public static String resolution;
    public static String packageName;
    public static String appVersion;
    public static String osVersion;
    public static String deviceModel;
    public static String locale;

    public static void setSessionCallback(_KiiSessionCallback cb) {
        callback = cb;
    }

    public static synchronized void endSession(int objectId) {
        boolean removed = IDSet.remove(objectId);
        if (removed) {
            Message endMessage = handler.obtainMessage(1);
            handler.sendMessage(endMessage);
        }
    }

    public static synchronized void startSession(int objectId) {
        IDSet.add(objectId);
        Message startMessage = handler.obtainMessage(0);
        handler.sendMessage(startMessage);
    }

    static {
        HandlerThread ht = new HandlerThread("com.kii.cloud.analytics.impl._KiiSession");
        ht.start();
        Looper lp = ht.getLooper();
        handler = new SessionEventHandler(lp);
        IDSet = new HashSet();
    }

    static class SessionEventHandler
    extends Handler {
        private static final int MSG_START = 0;
        private static final int MSG_END = 1;
        private static final int MSG_SEND_EVENT = 2;
        private static final int IDLE = 0;
        private static final int STARTED = 1;
        private static final int ENDING = 2;
        private int sessionState = 0;
        private long startedTime;
        private long endTime;

        public SessionEventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    if (this.sessionState == 0) {
                        this.startedTime = System.currentTimeMillis();
                        this.sessionState = 1;
                    } else if (this.sessionState != 1 && this.sessionState == 2) {
                        this.sessionState = 1;
                    }
                    if (callback == null) break;
                    callback.onSessionStart(this.startedTime);
                    break;
                }
                case 1: {
                    if (!IDSet.isEmpty()) {
                        return;
                    }
                    this.sessionState = 2;
                    this.endTime = System.currentTimeMillis();
                    Message sendEventMessage = this.obtainMessage(2);
                    HashMap<String, Long> obj = new HashMap<String, Long>();
                    obj.put("startedTime", this.startedTime);
                    obj.put("endTime", this.endTime);
                    sendEventMessage.obj = obj;
                    this.sendMessageDelayed(sendEventMessage, continueDuration);
                    if (callback == null) break;
                    callback.onSessionEnd(this.endTime);
                    break;
                }
                case 2: {
                    long currentTime = System.currentTimeMillis();
                    if (this.sessionState == 1) {
                        return;
                    }
                    if (currentTime - this.endTime < continueDuration) {
                        return;
                    }
                    if (!IDSet.isEmpty()) break;
                    HashMap vals = (HashMap)msg.obj;
                    long startedTime = (Long)vals.get("startedTime");
                    long endTime = (Long)vals.get("endTime");
                    KiiEvent sessionEvent = this.prepareSessionEvent(startedTime, endTime);
                    try {
                        sessionEvent.push();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.sessionState = 0;
                    if (callback == null) break;
                    callback.onSessionEventSent(sessionEvent);
                    break;
                }
            }
        }

        KiiEvent prepareSessionEvent(long startTime, long endTime) {
            KiiEvent sessionEvent = KiiAnalytics.event(_KiiSession.SESSION_EVENT_TYPE);
            long sessionLength = endTime - startTime;
            sessionEvent.set("sessionStart", startTime);
            sessionEvent.set("sessionLength", sessionLength);
            sessionEvent.set("packageName", packageName);
            sessionEvent.set("deviceModel", deviceModel);
            sessionEvent.set("resolution", resolution);
            sessionEvent.set("locale", locale);
            sessionEvent.set("platform", _KiiSession.KII_SDK_PLATFORM);
            sessionEvent.set("osVersion", osVersion);
            sessionEvent.set("appVersion", appVersion);
            return sessionEvent;
        }
    }
}

