/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.impl;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.io.Closeable;

public class Utils {
    @NonNull
    public static String path(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            if (TextUtils.isEmpty((CharSequence)segment)) continue;
            builder.append(segment);
            builder.append("/");
        }
        String path = builder.toString();
        return path.substring(0, path.length() - 1);
    }

    public static void closeSilently(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @NonNull
    public static String getScreenResolution(@NonNull Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics displaymetrics = new DisplayMetrics();
        display.getMetrics(displaymetrics);
        int height = displaymetrics.heightPixels;
        int width = displaymetrics.widthPixels;
        return width + "X" + height;
    }

    @Nullable
    public static String getApplicationVersion(@NonNull Context context) {
        PackageManager manager = context.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }
}

