/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.impl;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.analytics.KiiAnalyticsException;
import com.kii.cloud.analytics.KiiEvent;
import com.kii.cloud.analytics.impl.ApiResponse;
import com.kii.cloud.analytics.impl.Config;
import com.kii.cloud.analytics.impl.KiiAnalyticsEngine;
import com.kii.cloud.analytics.impl.Log;
import com.kii.cloud.analytics.impl.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventStore {
    private static final String TAG = "EventStore";
    private static String FILENAME = "event.txt";
    private static String CP_FILENAME = "cp-event.txt";
    private static String TMP_FILENAME = "tmp-event.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NonNull Context ctx, @NonNull KiiEvent event) throws IOException {
        FileOutputStream fos = null;
        try (BufferedWriter br = null;){
            fos = ctx.openFileOutput(FILENAME, 32768);
            br = new BufferedWriter(new OutputStreamWriter(fos));
            br.write(event.toJson().toString());
            br.newLine();
        }
    }

    public void uploadAndRemove(@NonNull Context ctx, @NonNull Intent intent) throws EventUploadException, EventRemoveException {
        JSONArray eventArray = null;
        ApiResponse response = null;
        int currentTotal = this.totalEventInCache(ctx);
        int totalAfterLastCycle = intent.getIntExtra("totalEventsLast", 0);
        int eventAdded = currentTotal - totalAfterLastCycle;
        try {
            eventArray = this.prepareEvents(ctx);
            if (eventArray.length() <= 0) {
                return;
            }
            String appId = intent.getStringExtra("appId");
            String appKey = intent.getStringExtra("appKey");
            String baseUrl = intent.getStringExtra("serverUrl");
            String sdkClientInfo = intent.getStringExtra("sdkClientInfo");
            String url = Utils.path(baseUrl, "apps", appId, "events");
            HttpPost request = new HttpPost(url);
            request.setHeader("X-Kii-AppID", appId);
            request.setHeader("X-Kii-AppKey", appKey);
            request.setHeader("X-Kii-SDK", sdkClientInfo);
            String requestEntity = eventArray.toString();
            Log.v(TAG, "request body: " + requestEntity);
            StringEntity entity = new StringEntity(requestEntity, "UTF-8");
            entity.setContentType("application/vnd.kii.EventRecordList+json");
            request.setEntity((HttpEntity)entity);
            response = KiiAnalyticsEngine.httpRequest3((HttpUriRequest)request);
            if (response != null && response.status >= 300) {
                KiiAnalyticsException exp = new KiiAnalyticsException("Bad response from server", null, response.status, response.body);
                throw new EventUploadException("Event upload error", exp);
            }
        }
        catch (IOException ioe) {
            throw new EventUploadException("Event upload error", ioe);
        }
        finally {
            if (this.isEventsRemovable(response)) {
                try {
                    this.remove(ctx);
                }
                catch (IOException ioe) {
                    throw new EventRemoveException("Event remove error", ioe);
                }
            }
            int total = this.totalEventInCache(ctx);
            intent.putExtra("totalEventsLast", total);
            this.rescheduleEventUpload(ctx, intent, eventAdded);
        }
    }

    private boolean isEventsRemovable(ApiResponse res) {
        if (res == null) {
            return false;
        }
        return res.status < 300 || this.isAllEventFailed(res);
    }

    private boolean isAllEventFailed(ApiResponse res) {
        if (res.status != 400) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)res.contentType)) {
            return false;
        }
        return res.contentType.toLowerCase(Locale.ENGLISH).startsWith("application/vnd.kii.eventvalidationexception+json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray prepareEvents(Context ctx) throws IOException {
        JSONArray array = new JSONArray();
        FileInputStream fis = null;
        try (BufferedReader br = null;){
            fis = ctx.openFileInput(FILENAME);
            br = new BufferedReader(new InputStreamReader(fis));
            for (int i = 0; i < 50; ++i) {
                String line = br.readLine();
                if (line == null) {
                    break;
                }
                try {
                    JSONObject json = new JSONObject(line);
                    json.put("_uploadedAt", System.currentTimeMillis());
                    array.put((Object)json);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Context ctx) throws IOException {
        BufferedReader br = null;
        FileInputStream fis = null;
        BufferedWriter bw = null;
        FileOutputStream fos = null;
        try {
            fis = ctx.openFileInput(FILENAME);
            br = new BufferedReader(new InputStreamReader(fis));
            fos = ctx.openFileOutput(TMP_FILENAME, 0);
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            String line = null;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (++i <= 50) continue;
                bw.write(line);
                bw.newLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
        this.renameTmpToOriginal(ctx);
    }

    private void renameTmpToOriginal(Context ctx) throws IOException {
        File orig = new File(ctx.getFilesDir(), FILENAME);
        File origCopy = new File(ctx.getFilesDir(), CP_FILENAME);
        this.renameFile(orig, origCopy);
        File tmp = new File(ctx.getFilesDir(), TMP_FILENAME);
        try {
            this.renameFile(tmp, orig);
        }
        catch (IOException ioe) {
            Log.w(TAG, "Rename tmp to original fails, restore from backup");
            this.renameFile(origCopy, orig);
        }
        this.deleteFile(ctx, origCopy);
    }

    private void renameFile(File orig, File rename) throws IOException {
        boolean ret = orig.renameTo(rename);
        if (!ret) {
            throw new IOException("fail to rename file " + orig.getAbsolutePath());
        }
    }

    private void deleteFile(Context ctx, File file) throws IOException {
        boolean ret;
        if (file.exists() && !(ret = ctx.deleteFile(file.getName()))) {
            throw new IOException("fail to delete file " + file.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int totalEventInCache(Context ctx) {
        BufferedReader br = null;
        FileInputStream fis = null;
        int i = 0;
        try {
            fis = ctx.openFileInput(FILENAME);
            br = new BufferedReader(new InputStreamReader(fis));
            while (br.readLine() != null) {
                ++i;
            }
        }
        catch (IOException e) {
            i = 0;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return i;
    }

    private void rescheduleEventUpload(Context ctx, Intent intent, int eventAdded) {
        long interval = intent.getLongExtra("intervalLast", 3600000L);
        interval = this.getInterval(ctx, interval, eventAdded);
        Log.v(TAG, "Event Added :" + eventAdded + "Interval is :" + interval);
        if (Config.getEventUploadRepeatTime(ctx) != 0L) {
            intent.putExtra("intervalLast", interval);
            EventStore.setAlarm(ctx, intent, interval);
        }
    }

    private long getInterval(Context ctx, long interval, int eventAdded) {
        if (eventAdded >= 50) {
            interval /= 2L;
        } else if (eventAdded < 40) {
            interval *= 2L;
        }
        if (interval > 3600000L) {
            interval = 3600000L;
        } else if (interval < 300000L) {
            interval = 300000L;
        }
        return interval;
    }

    private static void setAlarm(Context ctx, Intent intent, long repeatTime) {
        Log.v(TAG, "Starting alarmmanager with repeatTime :" + repeatTime);
        AlarmManager am = (AlarmManager)ctx.getSystemService("alarm");
        PendingIntent pi = PendingIntent.getService((Context)ctx, (int)0, (Intent)intent, (int)0x10000000);
        am.setInexactRepeating(1, System.currentTimeMillis(), repeatTime, pi);
    }

    public class EventUploadException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EventUploadException(@Nullable String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class EventRemoveException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EventRemoveException(@Nullable String message, Throwable cause) {
            super(message, cause);
        }
    }
}

