/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.impl;

import android.content.Context;
import android.support.annotation.NonNull;
import com.kii.cloud.analytics.impl.Utils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.JSONException;
import org.json.JSONObject;

public class Config {
    private static final String UPLOAD_INTERVAL = "upload_interval";
    private static final String UPLOAD_CONFIG_FILE = "analytics_config.js";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getEventUploadRepeatTime(@NonNull Context ctx) {
        long repeatTime = -1L;
        BufferedReader br = null;
        FileInputStream fis = null;
        try {
            fis = ctx.openFileInput(UPLOAD_CONFIG_FILE);
            br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                JSONObject json = new JSONObject(line);
                if (!json.has(UPLOAD_INTERVAL)) continue;
                repeatTime = json.getLong(UPLOAD_INTERVAL);
                break;
            }
        }
        catch (JSONException jSONException) {
            Utils.closeSilently(br);
        }
        catch (IOException iOException) {
            Utils.closeSilently(br);
            {
                catch (Throwable throwable) {
                    Utils.closeSilently(br);
                    throw throwable;
                }
            }
        }
        Utils.closeSilently(br);
        return repeatTime;
    }
}

