/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.aggregationresult;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.kii.cloud.analytics.aggregationresult.DateRange;
import com.kii.cloud.analytics.aggregationresult.Filter;
import com.kii.cloud.analytics.aggregationresult.ResultQuery;
import com.kii.cloud.analytics.aggregationresult.SimpleDate;
import com.kii.cloud.analytics.impl.Log;
import java.util.Map;

public class ResultQueryUtil {
    private static final String TAG = "ResultQueryUtil";

    @NonNull
    public static String addQueryParams(@NonNull String url, @NonNull ResultQuery query) {
        Map<String, String> map;
        Filter filter;
        DateRange dateRange;
        Uri uri = Uri.parse((String)url);
        Uri.Builder builder = uri.buildUpon();
        String groupingKey = query.getGroupingKey();
        if (!TextUtils.isEmpty((CharSequence)groupingKey)) {
            builder.appendQueryParameter("group", groupingKey);
        }
        if ((dateRange = query.getDateRange()) != null) {
            SimpleDate start = query.getDateRange().getStart();
            SimpleDate end = query.getDateRange().getEnd();
            builder.appendQueryParameter("startDate", start.toString());
            builder.appendQueryParameter("endDate", end.toString());
        }
        if ((filter = query.getFilter()) != null && (map = filter.getMap()).size() > 0) {
            int i = 0;
            for (String key : map.keySet()) {
                String value = map.get(key);
                Log.v(TAG, "key: " + key + " value:" + value);
                builder.appendQueryParameter("filter" + (i + 1) + ".name", key);
                builder.appendQueryParameter("filter" + (i + 1) + ".value", value);
                ++i;
            }
        }
        return builder.build().toString();
    }
}

