/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics.aggregationresult;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.analytics.KiiEvent;
import com.kii.cloud.analytics.aggregationresult.DateRange;
import com.kii.cloud.analytics.aggregationresult.Filter;

public class ResultQuery {
    private Filter filter;
    private String groupingKey;
    private DateRange dateRange;

    public void setGrouping(@Nullable String groupingKey) {
        this.groupingKey = groupingKey;
    }

    public void setFilter(@Nullable Filter filter) {
        this.filter = filter;
    }

    public void setDateRange(@Nullable DateRange dateRange) {
        this.dateRange = dateRange;
    }

    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    @Nullable
    public String getGroupingKey() {
        return this.groupingKey;
    }

    @Nullable
    public DateRange getDateRange() {
        return this.dateRange;
    }

    @NonNull
    public static Builder builderWithFilter(@NonNull Filter filter) {
        return new Builder().withFilter(filter);
    }

    @NonNull
    public static Builder builderWithGroupingKey(@NonNull String groupingKey) {
        return new Builder().withGroupingKey(groupingKey);
    }

    @NonNull
    public static Builder builderWithDateRange(@NonNull DateRange dateRange) {
        return new Builder().withDateRange(dateRange);
    }

    public static final class Builder {
        Filter filter = null;
        String groupingKey = null;
        DateRange dateRange = null;

        Builder() {
        }

        @NonNull
        public Builder withFilter(@NonNull Filter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("Filter must not be null");
            }
            if (filter.getMap().isEmpty()) {
                throw new IllegalArgumentException("Filter must have at least one element");
            }
            this.filter = filter;
            return this;
        }

        @NonNull
        public Builder withGroupingKey(@NonNull String groupingKey) {
            if (!KiiEvent.isValidKey(groupingKey)) {
                throw new IllegalArgumentException("given key is empty or invalid");
            }
            this.groupingKey = groupingKey;
            return this;
        }

        @NonNull
        public Builder withDateRange(@NonNull DateRange dateRange) {
            if (dateRange == null) {
                throw new IllegalArgumentException("dateRange must not be null");
            }
            this.dateRange = dateRange;
            return this;
        }

        @NonNull
        public ResultQuery build() {
            if (this.filter == null && this.dateRange == null && this.groupingKey == null) {
                throw new IllegalStateException("At least one of filter, dateRange, or groupingKey must be specified.");
            }
            ResultQuery query = new ResultQuery();
            if (this.filter != null) {
                query.filter = this.filter;
            }
            if (this.dateRange != null) {
                query.dateRange = this.dateRange;
            }
            if (this.groupingKey != null) {
                query.groupingKey = this.groupingKey;
            }
            return query;
        }
    }
}

