/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import com.kii.cloud.analytics.KiiAnalytics;
import com.kii.cloud.analytics.impl.Utils;
import com.kii.cloud.analytics.impl._KiiSession;
import com.kii.cloud.storage.Kii;
import java.util.Locale;

public class SessionTracker {
    private SessionTracker() {
    }

    public static void onStartActivity(@Nullable Activity activity, @Nullable String appId, @Nullable String appKey, @Nullable KiiAnalytics.Site site) {
        if (activity == null) {
            return;
        }
        if (!Kii.getAnalyticsEnabled()) {
            return;
        }
        SessionTracker.onStartActivity(activity);
    }

    public static void onStartActivity(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        if (!KiiAnalytics.isInitialized()) {
            return;
        }
        Context appCtx = activity.getApplicationContext();
        _KiiSession.resolution = Utils.getScreenResolution(appCtx);
        _KiiSession.packageName = appCtx.getPackageName();
        _KiiSession.appVersion = Utils.getApplicationVersion(appCtx);
        _KiiSession.osVersion = System.getProperty("os.version");
        _KiiSession.deviceModel = Build.MODEL;
        _KiiSession.locale = Locale.getDefault().toString();
        _KiiSession.startSession(activity.hashCode());
    }

    public static void onStopActivity(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        if (!KiiAnalytics.isInitialized()) {
            return;
        }
        _KiiSession.endSession(activity.hashCode());
    }

    public static void setContinueDuration(long durationInMillis) {
        _KiiSession.continueDuration = durationInMillis;
    }
}

