/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.analytics.KeyValueObject;
import com.kii.cloud.analytics.KiiAnalytics;
import com.kii.cloud.analytics.KiiAnalyticsException;
import com.kii.cloud.analytics.KiiAnalyticsFormatException;
import com.kii.cloud.analytics.UUIDManager;
import com.kii.cloud.analytics.callback.KiiEventCallback;
import com.kii.cloud.analytics.impl.EventStore;
import com.kii.cloud.analytics.impl.KiiAnalyticsEngine;
import com.kii.cloud.analytics.impl.Log;
import com.kii.cloud.analytics.impl.Utils;
import com.kii.cloud.analytics.impl.async.EventTask;
import com.kii.cloud.analytics.impl.async.KiiTaskExecutor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;

public final class KiiEvent
extends KeyValueObject {
    private static final Pattern KEY_NAME_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]{0,63}$");
    private static final Pattern TYPE_PATTERN = Pattern.compile("^\\S.*");
    private static final String TAG = "KiiEvent";
    String mType;
    long mTriggeredAt = -1L;
    long mUploadedAt = -1L;

    KiiEvent(String type) {
        KiiEvent.validateType(type);
        this.mType = type;
        this.mJSON = new JSONObject();
        this.mTriggeredAt = System.currentTimeMillis();
    }

    public void push(@NonNull KiiEventCallback callback) {
        EventTask task = new EventTask(EventTask.TaskType.PUSH, this, callback);
        KiiTaskExecutor.getInstance().execute(task);
    }

    public void push() throws IOException {
        KiiAnalytics.checkInitialize();
        String deviceId = UUIDManager.getUUID();
        try {
            this.mJSON.put("_deviceID", (Object)deviceId);
            this.mJSON.put("_triggeredAt", this.mTriggeredAt);
            this.mJSON.put("_type", (Object)this.mType);
            Log.v(TAG, "Event json:" + this.toJson().toString());
        }
        catch (JSONException e1) {
            throw new RuntimeException("Unexpected error!", e1);
        }
        new EventStore().save(KiiAnalytics.getContext(), this);
    }

    @NonNull
    public JSONObject toJson() {
        return this.mJSON;
    }

    public void upload() throws KiiAnalyticsException {
        StringEntity entity;
        KiiAnalytics.checkInitialize();
        String url = Utils.path(KiiAnalytics.getBaseUrl(), "apps", KiiAnalytics.getAppId(), "event");
        HttpPost request = new HttpPost(url);
        request.setHeader("X-Kii-AppID", KiiAnalytics.getAppId());
        request.setHeader("X-Kii-AppKey", KiiAnalytics.getAppKey());
        String deviceId = UUIDManager.getUUID();
        this.mUploadedAt = System.currentTimeMillis();
        try {
            this.mJSON.put("_deviceID", (Object)deviceId);
            this.mJSON.put("_triggeredAt", this.mTriggeredAt);
            this.mJSON.put("_uploadedAt", this.mUploadedAt);
            this.mJSON.put("_type", (Object)this.mType);
        }
        catch (JSONException e1) {
            throw new RuntimeException("Unexpected error!", e1);
        }
        String requestEntity = this.mJSON.toString();
        Log.v(TAG, "request body: " + requestEntity);
        try {
            entity = new StringEntity(requestEntity, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected error!", e);
        }
        entity.setContentType("application/vnd.kii.EventRecord+json");
        request.setEntity((HttpEntity)entity);
        KiiAnalyticsEngine.httpRequest2((HttpUriRequest)request);
    }

    public void upload(@NonNull KiiEventCallback callback) {
        EventTask task = new EventTask(EventTask.TaskType.UPLOAD, this, callback);
        KiiTaskExecutor.getInstance().execute(task);
    }

    public static void validateKey(@NonNull String key) throws KiiAnalyticsFormatException {
        if (!KiiEvent.isValidKey(key)) {
            String message = "Invalid key format. should be ^[a-zA-Z][a-zA-Z0-9_]{1-64}";
            if (TextUtils.isEmpty((CharSequence)key)) {
                message = "key should not be null or empty";
            }
            throw new KiiAnalyticsFormatException(message);
        }
    }

    public static boolean isValidKey(@Nullable String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        return KEY_NAME_PATTERN.matcher(key).matches();
    }

    public static void validateType(@NonNull String type) throws KiiAnalyticsFormatException {
        if (!KiiEvent.isValidType(type)) {
            throw new KiiAnalyticsFormatException("Invalid type format. does not maches with \"^\\S.*\" or length is more than 128 bytes.");
        }
    }

    public static boolean isValidType(@Nullable String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if (!TYPE_PATTERN.matcher(type).matches()) {
            return false;
        }
        return KiiEvent.length(type) <= 128;
    }

    private static int length(String str) {
        return str.getBytes().length;
    }
}

